/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.TreeTraversal;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredTraverserBase<T, Self extends FilteredTraverserBase<T, Self>>
implements Iterable<T> {
    final Meta<T> myMeta;

    protected FilteredTraverserBase(@NotNull Meta<T> meta) {
        if (meta == null) {
            FilteredTraverserBase.$$$reportNull$$$0(0);
        }
        this.myMeta = meta;
    }

    @NotNull
    public Function<? super T, ? extends Iterable<? extends T>> getTree() {
        Function function = this.myMeta.tree;
        if (function == null) {
            FilteredTraverserBase.$$$reportNull$$$0(1);
        }
        return function;
    }

    @NotNull
    public final T getRoot() {
        Object t = this.myMeta.roots.iterator().next();
        if (t == null) {
            FilteredTraverserBase.$$$reportNull$$$0(2);
        }
        return t;
    }

    @NotNull
    public final Iterable<? extends T> getRoots() {
        Iterable iterable = this.myMeta.roots;
        if (iterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.traverse().iterator();
    }

    @NotNull
    protected abstract Self newInstance(@NotNull Meta<T> var1);

    @NotNull
    public final JBIterable<T> traverse(@NotNull TreeTraversal traversal) {
        if (traversal == null) {
            FilteredTraverserBase.$$$reportNull$$$0(4);
        }
        Function<Object, Iterable> adjusted = this::children;
        JBIterable<Object> jBIterable = this.myMeta.interceptor.fun(traversal).traversal(this.getRoots(), adjusted).filter(this.myMeta.filter.and());
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> traverse() {
        return this.traverse(this.myMeta.traversal);
    }

    @NotNull
    public final JBIterable<T> biOrderDfsTraversal() {
        return this.traverse(TreeTraversal.BI_ORDER_DFS);
    }

    @NotNull
    public final JBIterable<T> preOrderDfsTraversal() {
        return this.traverse(TreeTraversal.PRE_ORDER_DFS);
    }

    @NotNull
    public final JBIterable<T> postOrderDfsTraversal() {
        return this.traverse(TreeTraversal.POST_ORDER_DFS);
    }

    @NotNull
    public final JBIterable<T> bfsTraversal() {
        return this.traverse(TreeTraversal.PLAIN_BFS);
    }

    @NotNull
    public final JBIterable<T> tracingBfsTraversal() {
        return this.traverse(TreeTraversal.TRACING_BFS);
    }

    @NotNull
    public final Self reset() {
        Self Self = this.newInstance(this.myMeta.reset());
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(6);
        }
        return Self;
    }

    @NotNull
    public final Self withRoot(@Nullable T root) {
        Self Self = this.newInstance(this.myMeta.withRoots(JBIterable.of(root)));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(7);
        }
        return Self;
    }

    @NotNull
    public final Self withRoots(T ... roots) {
        Self Self = this.newInstance(this.myMeta.withRoots(JBIterable.of(roots)));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(8);
        }
        return Self;
    }

    @NotNull
    public final Self withRoots(@Nullable Iterable<? extends T> roots) {
        Self Self = this.newInstance(this.myMeta.withRoots(roots != null ? roots : JBIterable.empty()));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(9);
        }
        return Self;
    }

    @NotNull
    public final Self withTraversal(TreeTraversal type) {
        Self Self = this.newInstance(this.myMeta.withTraversal(type));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(10);
        }
        return Self;
    }

    @NotNull
    public final Self expand(@NotNull Condition<? super T> c) {
        if (c == null) {
            FilteredTraverserBase.$$$reportNull$$$0(11);
        }
        Self Self = this.newInstance(this.myMeta.expand(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(12);
        }
        return Self;
    }

    @NotNull
    public final Self regard(@NotNull Condition<? super T> c) {
        if (c == null) {
            FilteredTraverserBase.$$$reportNull$$$0(13);
        }
        Self Self = this.newInstance(this.myMeta.regard(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(14);
        }
        return Self;
    }

    @NotNull
    public final Self expandAndFilter(Condition<? super T> c) {
        Self Self = this.newInstance(this.myMeta.expand(c).filter(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(15);
        }
        return Self;
    }

    @NotNull
    public final Self expandAndSkip(Condition<? super T> c) {
        Self Self = this.newInstance(this.myMeta.expand(c).filter(Conditions.not(c)));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(16);
        }
        return Self;
    }

    @NotNull
    public final Self filter(@NotNull Condition<? super T> c) {
        if (c == null) {
            FilteredTraverserBase.$$$reportNull$$$0(17);
        }
        Self Self = this.newInstance(this.myMeta.filter(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(18);
        }
        return Self;
    }

    @NotNull
    public final <C> JBIterable<C> filter(@NotNull Class<C> type) {
        if (type == null) {
            FilteredTraverserBase.$$$reportNull$$$0(19);
        }
        JBIterable<C> jBIterable = this.traverse().filter(type);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @NotNull
    public final Self unique() {
        return this.unique(Functions.identity());
    }

    @NotNull
    public final Self unique(@NotNull Function<? super T, Object> identity) {
        if (identity == null) {
            FilteredTraverserBase.$$$reportNull$$$0(21);
        }
        return this.intercept(traversal -> traversal.unique(identity));
    }

    @NotNull
    public final Self cached() {
        IdentityHashMap cache = new IdentityHashMap();
        return this.intercept(traversal -> traversal.cached(cache));
    }

    @NotNull
    public Self onRange(@NotNull Condition<? super T> rangeCondition) {
        if (rangeCondition == null) {
            FilteredTraverserBase.$$$reportNull$$$0(22);
        }
        return this.intercept(traversal -> traversal.onRange(rangeCondition));
    }

    @NotNull
    public final Self forceIgnore(@NotNull Condition<? super T> c) {
        if (c == null) {
            FilteredTraverserBase.$$$reportNull$$$0(23);
        }
        Self Self = this.newInstance(this.myMeta.forceIgnore(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(24);
        }
        return Self;
    }

    @NotNull
    public final Self forceDisregard(@NotNull Condition<? super T> c) {
        if (c == null) {
            FilteredTraverserBase.$$$reportNull$$$0(25);
        }
        Self Self = this.newInstance(this.myMeta.forceDisregard(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(26);
        }
        return Self;
    }

    @NotNull
    public final Self intercept(@NotNull Function<? super TreeTraversal, ? extends TreeTraversal> transform) {
        if (transform == null) {
            FilteredTraverserBase.$$$reportNull$$$0(27);
        }
        Self Self = this.newInstance(this.myMeta.interceptTraversal(transform));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(28);
        }
        return Self;
    }

    @NotNull
    protected <S, SelfS extends FilteredTraverserBase<S, ?>> SelfS mapImpl(@NotNull Function<? super T, ? extends S> function, @NotNull Function<? super S, ? extends T> reverse) {
        if (function == null) {
            FilteredTraverserBase.$$$reportNull$$$0(29);
        }
        if (reverse == null) {
            FilteredTraverserBase.$$$reportNull$$$0(30);
        }
        Function<Object, JBIterable> baseTree = this.myMeta::children;
        Condition filter = this.myMeta.filter.and();
        Meta<? extends S> meta = Meta.create(s -> ((JBIterable)baseTree.fun(reverse.fun((Object)s))).map(function)).withRoots(JBIterable.from(this.getRoots()).map(function)).filter(filter == Conditions.alwaysTrue() ? Conditions.alwaysTrue() : o -> filter.value(reverse.fun((Object)o)));
        Self Self = this.newInstance(meta);
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(31);
        }
        return (SelfS)Self;
    }

    @NotNull
    protected <S, SelfS extends FilteredTraverserBase<S, ?>> SelfS mapImpl(@NotNull Function<? super T, ? extends S> function) {
        if (function == null) {
            FilteredTraverserBase.$$$reportNull$$$0(32);
        }
        Meta<Object> meta = new Meta<Object>(JBIterable.empty(), this.myMeta.traversal, Functions.constant(JBIterable.empty()), Cond.TRUE, Cond.TRUE, Cond.TRUE, Cond.FALSE, Cond.FALSE, Cond.FALSE, original -> new MappedTraversal((TreeTraversal)original, this.myMeta, JBIterable.Stateful.copy(function)), this.myMeta);
        Self Self = this.newInstance(meta);
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(33);
        }
        return (SelfS)Self;
    }

    @ApiStatus.Internal
    @NotNull
    public final JBIterable<T> children(@Nullable T node) {
        JBIterable<T> jBIterable = this.myMeta.children(node);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(34);
        }
        return jBIterable;
    }

    @NotNull
    public final List<T> toList() {
        List<T> list = this.traverse().toList();
        if (list == null) {
            FilteredTraverserBase.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public final Set<T> toSet() {
        Set<T> set = this.traverse().toSet();
        if (set == null) {
            FilteredTraverserBase.$$$reportNull$$$0(36);
        }
        return set;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{traversal=" + this.myMeta.traversal + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FilteredTraverserBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traversal";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeCondition";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FilteredTraverserBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reset";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withRoot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withTraversal";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "regard";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "expandAndFilter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "expandAndSkip";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "forceIgnore";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "forceDisregard";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "intercept";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "mapImpl";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "children";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "toSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "regard";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "onRange";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "forceIgnore";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "forceDisregard";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "mapImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class Meta<T> {
        final TreeTraversal traversal;
        final Iterable<? extends T> roots;
        final Function<? super T, ? extends Iterable<? extends T>> tree;
        final Cond<T> expand;
        final Cond<T> regard;
        final Cond<T> filter;
        final Cond<T> forceExpand;
        final Cond<T> forceIgnore;
        final Cond<T> forceDisregard;
        final Function<? super TreeTraversal, ? extends TreeTraversal> interceptor;
        final Meta<?> original;

        @NotNull
        public static <T> Meta<T> create(Function<? super T, ? extends Iterable<? extends T>> tree) {
            return new Meta<Object>(JBIterable.empty(), TreeTraversal.PRE_ORDER_DFS, tree, Cond.TRUE, Cond.TRUE, Cond.TRUE, Cond.FALSE, Cond.FALSE, Cond.FALSE, Functions.id(), null);
        }

        Meta(@NotNull Iterable<? extends T> roots, @NotNull TreeTraversal traversal, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree, @NotNull Cond<? super T> expand, @NotNull Cond<? super T> regard, @NotNull Cond<? super T> filter, @NotNull Cond<? super T> forceExpand, @NotNull Cond<? super T> forceIgnore, @NotNull Cond<? super T> forceDisregard, @NotNull Function<? super TreeTraversal, ? extends TreeTraversal> interceptor, @Nullable Meta<?> original) {
            if (roots == null) {
                Meta.$$$reportNull$$$0(0);
            }
            if (traversal == null) {
                Meta.$$$reportNull$$$0(1);
            }
            if (tree == null) {
                Meta.$$$reportNull$$$0(2);
            }
            if (expand == null) {
                Meta.$$$reportNull$$$0(3);
            }
            if (regard == null) {
                Meta.$$$reportNull$$$0(4);
            }
            if (filter == null) {
                Meta.$$$reportNull$$$0(5);
            }
            if (forceExpand == null) {
                Meta.$$$reportNull$$$0(6);
            }
            if (forceIgnore == null) {
                Meta.$$$reportNull$$$0(7);
            }
            if (forceDisregard == null) {
                Meta.$$$reportNull$$$0(8);
            }
            if (interceptor == null) {
                Meta.$$$reportNull$$$0(9);
            }
            this.roots = roots;
            this.traversal = traversal;
            this.tree = tree;
            this.expand = expand;
            this.regard = regard;
            this.filter = filter;
            this.forceExpand = forceExpand;
            this.forceIgnore = forceIgnore;
            this.forceDisregard = forceDisregard;
            this.interceptor = interceptor;
            this.original = original;
        }

        public Meta<T> reset() {
            return new Meta<Object>(this.roots, TreeTraversal.PRE_ORDER_DFS, this.tree, Cond.TRUE, Cond.TRUE, Cond.TRUE, this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> withRoots(@NotNull Iterable<? extends T> roots) {
            if (roots == null) {
                Meta.$$$reportNull$$$0(10);
            }
            return new Meta<T>(roots, this.traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> withTraversal(TreeTraversal traversal) {
            return new Meta<T>(this.roots, traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> expand(@NotNull Condition<? super T> c) {
            if (c == null) {
                Meta.$$$reportNull$$$0(11);
            }
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand.append(c), this.regard, this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> regard(@NotNull Condition<? super T> c) {
            if (c == null) {
                Meta.$$$reportNull$$$0(12);
            }
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard.append(c), this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> filter(@NotNull Condition<? super T> c) {
            if (c == null) {
                Meta.$$$reportNull$$$0(13);
            }
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard, this.filter.append(c), this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> forceExpand(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand.append(c), this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> forceIgnore(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand, this.forceIgnore.append(c), this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> forceDisregard(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard.append(c), this.interceptor, this.original);
        }

        public Meta<T> interceptTraversal(Function<? super TreeTraversal, ? extends TreeTraversal> interceptor) {
            if (interceptor == Functions.identity()) {
                return this;
            }
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard, Functions.compose(this.interceptor, interceptor), this.original);
        }

        JBIterable<T> children(@Nullable T node) {
            return this.childrenImpl(node, this.tree);
        }

        JBIterable<T> childrenImpl(@Nullable T node, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (tree == null) {
                Meta.$$$reportNull$$$0(14);
            }
            if (node == null) {
                return JBIterable.empty();
            }
            if (!(this.expand == Cond.TRUE || this.expand.valueAnd(node) || this.forceExpand != Cond.FALSE && this.forceExpand.valueOr(node))) {
                return JBIterable.empty();
            }
            if (this.regard == Cond.TRUE && this.forceDisregard == Cond.FALSE) {
                return JBIterable.from(tree.fun(node)).filter(Conditions.not(this.forceIgnore.or()));
            }
            return TreeTraversal.GUIDED_TRAVERSAL(this.createChildrenGuide(node)).traversal(node, tree);
        }

        TreeTraversal.GuidedIt.Guide<T> createChildrenGuide(final T parent) {
            return new TreeTraversal.GuidedIt.Guide<T>(){
                final Condition<? super T> expand;
                {
                    this.expand = this.buildExpandConditionForChildren(parent);
                }

                @Override
                public void guide(@NotNull TreeTraversal.GuidedIt<T> guidedIt) {
                    if (guidedIt == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.doPerformChildrenGuidance(guidedIt, this.expand);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guidedIt", "com/intellij/util/containers/FilteredTraverserBase$Meta$1", "guide"));
                }
            };
        }

        private void doPerformChildrenGuidance(TreeTraversal.GuidedIt<T> it, Condition<? super T> expand) {
            if (it.curChild == null) {
                return;
            }
            if (this.forceIgnore != Cond.FALSE && this.forceIgnore.valueOr(it.curChild)) {
                return;
            }
            if (it.curParent == null || expand == Conditions.alwaysTrue() || expand.value(it.curChild)) {
                it.queueNext(it.curChild);
            } else {
                it.result(it.curChild);
            }
        }

        private Condition<? super T> buildExpandConditionForChildren(T parent) {
            Condition[] impls = new Condition[this.regard.length + this.forceDisregard.length];
            int count = 0;
            boolean isRegard = false;
            Cond<T> c = this.forceDisregard;
            while (c != null) {
                if (c.impl != (isRegard ? Conditions.alwaysTrue() : Conditions.alwaysFalse())) {
                    Condition impl = JBIterable.Stateful.copy(c.impl);
                    if (impl instanceof EdgeFilter) {
                        ((EdgeFilter)impl).edgeSource = parent;
                    }
                    Condition condition = impls[count++] = isRegard ? Conditions.not(impl) : impl;
                }
                if (c.next == null) {
                    c = isRegard ? null : this.regard;
                    isRegard = true;
                    continue;
                }
                c = c.next;
            }
            if (count <= 0) {
                return Conditions.alwaysFalse();
            }
            Cond result = null;
            for (int i = 0; i < count; ++i) {
                result = new Cond(impls[count - i - 1], result);
            }
            return result.or();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traversal";
                    break;
                }
                case 2: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expand";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regard";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forceExpand";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forceIgnore";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forceDisregard";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interceptor";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/containers/FilteredTraverserBase$Meta";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withRoots";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expand";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "regard";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "filter";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Cond<T> {
        static final Cond<Object> TRUE = new Cond(Conditions.alwaysTrue(), null);
        static final Cond<Object> FALSE = new Cond(Conditions.alwaysFalse(), null);
        final Condition<? super T> impl;
        final Cond<T> next;
        final int length;

        Cond(Condition<? super T> impl, Cond<T> next2) {
            this.impl = impl;
            this.next = next2;
            this.length = next2 == null ? 1 : next2.length + 1;
        }

        Cond<T> append(Condition<? super T> impl) {
            Cond<? super T> result = new Cond<T>(impl, null);
            for (Cond<T> o : this.toArray(true)) {
                result = new Cond<T>(o.impl, result);
            }
            return result;
        }

        boolean valueAnd(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (!c.impl.value(t)) {
                    return false;
                }
                c = c.next;
            }
            return true;
        }

        boolean valueOr(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (c.impl.value(t)) {
                    return true;
                }
                c = c.next;
            }
            return false;
        }

        Condition<? super T> or() {
            Boolean result = false;
            Cond<T> c = this;
            while (c != null) {
                if (c.impl == Conditions.alwaysTrue()) {
                    return Conditions.alwaysTrue();
                }
                result = result != null && c.impl != Conditions.alwaysFalse() ? null : result;
                c = c.next;
            }
            return result == null ? this::valueOr : Conditions.alwaysFalse();
        }

        Condition<? super T> and() {
            Boolean result = true;
            Cond<T> c = this;
            while (c != null) {
                if (c.impl == Conditions.alwaysFalse()) {
                    return Conditions.alwaysFalse();
                }
                result = result != null && c.impl != Conditions.alwaysTrue() ? null : result;
                c = c.next;
            }
            return result == null ? this::valueAnd : Conditions.alwaysTrue();
        }

        Cond<T>[] toArray(boolean inverse) {
            Cond[] result = new Cond[this.length];
            Cond<T> cur = this;
            for (int i = 0; i < this.length; ++i) {
                result[inverse ? this.length - i - 1 : i] = cur;
                cur = cur.next;
            }
            return result;
        }

        public String toString() {
            if (this == TRUE) {
                return "Cond.TRUE";
            }
            if (this == FALSE) {
                return "Cond.FALSE";
            }
            StringBuilder sb = new StringBuilder("Cond{");
            Cond<T> c = this;
            while (c != null) {
                sb.append(JBIterator.toShortString(c.impl));
                if (c.next != null) {
                    sb.append(", ");
                }
                c = c.next;
            }
            return sb.append("}").toString();
        }
    }

    private static class MappedTraversal<T, S>
    extends TreeTraversal {
        final TreeTraversal original;
        final Meta<T> meta;
        final Function<? super T, ? extends S> map;

        MappedTraversal(@NotNull TreeTraversal original, @NotNull Meta<T> meta, @NotNull Function<? super T, ? extends S> map) {
            if (original == null) {
                MappedTraversal.$$$reportNull$$$0(0);
            }
            if (meta == null) {
                MappedTraversal.$$$reportNull$$$0(1);
            }
            if (map == null) {
                MappedTraversal.$$$reportNull$$$0(2);
            }
            super(original + " (MAPPED by " + map + ")");
            this.original = original;
            this.meta = meta;
            this.map = map;
        }

        @NotNull
        public <SS> TreeTraversal.It<SS> createIterator(@NotNull Iterable<? extends SS> ignore1, @NotNull Function<? super SS, ? extends Iterable<? extends SS>> ignore2) {
            if (ignore1 == null) {
                MappedTraversal.$$$reportNull$$$0(3);
            }
            if (ignore2 == null) {
                MappedTraversal.$$$reportNull$$$0(4);
            }
            List<Meta> metas = ContainerUtil.reverse(JBIterable.generate(this.meta, o -> o.original).toList());
            Meta firstMeta = metas.get(0);
            Iterable roots = firstMeta.roots;
            Function<Object, Object> tree = firstMeta::children;
            Condition filter = firstMeta.filter.and();
            int count = metas.size();
            for (int i = 1; i <= count; ++i) {
                Meta meta = i < count ? metas.get(i) : null;
                MappedTraversal adjusted = meta == null ? this : meta.interceptor.fun(this.original);
                tree = new MappedTree<T, Object>(tree, adjusted.map, meta);
                Function<Object, Object> fn = ((MappedTree)tree)::map;
                roots = JBIterable.from(roots).map(fn);
                Function<Object, Object> tree0 = tree;
                Condition filter0 = filter;
                Condition prevFilter = filter == Conditions.alwaysTrue() ? Conditions.alwaysTrue() : o -> filter0.value(((MappedTree)tree0).reverse(o));
                filter = Conditions.and(prevFilter, meta == null ? Conditions.alwaysTrue() : meta.filter.and());
            }
            MappedTree mappedTree = (MappedTree)tree;
            TreeTraversal.It it = (TreeTraversal.It)this.original.createIterator(JBIterable.from(roots), mappedTree).filter(filter);
            if (it == null) {
                MappedTraversal.$$$reportNull$$$0(5);
            }
            return it;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignore1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignore2";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/FilteredTraverserBase$MappedTraversal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/FilteredTraverserBase$MappedTraversal";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MappedTree<T, S>
    implements Function<S, Iterable<? extends S>> {
        final Function<? super T, ? extends Iterable<? extends T>> tree;
        final Function<? super T, ? extends S> mapInner;
        final Meta<S> meta;
        Map<S, T> reverse;

        MappedTree(Function<? super T, ? extends Iterable<? extends T>> tree, Function<? super T, ? extends S> map, Meta<S> meta) {
            this.tree = tree;
            this.mapInner = map;
            this.meta = meta;
        }

        @Override
        public Iterable<? extends S> fun(S s) {
            return this.meta == null ? JBIterable.from(this.tree.fun(this.reverse(s))).map(this::map) : this.meta.childrenImpl(s, o -> JBIterable.from(this.tree.fun(this.reverse(o))).map(this::map));
        }

        S map(T t) {
            S s;
            if (this.reverse == null) {
                this.reverse = new WeakHashMap<S, T>();
            }
            if ((s = this.mapInner.fun(t)) != null && t != null) {
                this.reverse.put(s, t);
            }
            return s;
        }

        @NotNull
        T reverse(S s) {
            T t;
            T t2 = t = s == null ? null : (T)this.reverse.get(s);
            if (t == null) {
                throw new IllegalStateException("unable to reverse map for: " + s);
            }
            T t3 = t;
            if (t3 == null) {
                MappedTree.$$$reportNull$$$0(0);
            }
            return t3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase$MappedTree", "reverse"));
        }
    }

    public static abstract class EdgeFilter<T>
    extends JBIterable.SCond<T> {
        protected T edgeSource;
    }
}

