/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing.console;

import com.google.common.collect.ImmutableMap;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonIndentingLexer;
import com.jetbrains.python.lexer.PythonLexerKind;
import com.jetbrains.python.parsing.console.PyConsoleTokenTypes;
import com.jetbrains.python.psi.PyElementType;
import java.util.Map;

public class PythonConsoleLexer
extends PythonIndentingLexer {
    private static final Map<String, PyElementType> SPECIAL_IPYTHON_SYMBOLS = ImmutableMap.of((Object)"?", (Object)PyConsoleTokenTypes.QUESTION_MARK, (Object)"!", (Object)PyConsoleTokenTypes.PLING, (Object)"$", (Object)PyConsoleTokenTypes.DOLLAR);

    public PythonConsoleLexer() {
        super(PythonLexerKind.CONSOLE);
    }

    @Override
    public IElementType getTokenType() {
        IElementType type = super.getTokenType();
        if (type == PyTokenTypes.BAD_CHARACTER && PythonConsoleLexer.isSpecialSymbols(this.getTokenText())) {
            type = PythonConsoleLexer.getElementType(this.getTokenText());
        }
        return type;
    }

    public static PyElementType getElementType(String token) {
        return SPECIAL_IPYTHON_SYMBOLS.get(token);
    }

    public static boolean isSpecialSymbols(String token) {
        return SPECIAL_IPYTHON_SYMBOLS.containsKey(token);
    }
}

