/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Maps;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PythonVisitorFilter;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.LightNamedElement;
import com.jetbrains.python.psi.impl.PyFunctionImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.VariantsProcessor;
import com.jetbrains.python.psi.stubs.PyFileStub;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFileImpl
extends PsiFileBase
implements PyFile,
PyExpression {
    @Nullable
    protected volatile PyType myType;
    private final Map<FutureFeature, Boolean> myFutureFeatures;
    @Nullable
    private volatile List<String> myDunderAll;
    private volatile boolean myDunderAllCalculated;
    @NotNull
    private volatile SoftReference<ExportedNameCache> myExportedNameCache = new SoftReference<Object>(null);
    @NotNull
    private final PsiModificationTracker myModificationTracker;
    private final Key<Set<PyFile>> PROCESSED_FILES = Key.create("PyFileImpl.processDeclarations.processedFiles");

    public PyFileImpl(FileViewProvider viewProvider) {
        this(viewProvider, PythonLanguage.getInstance());
    }

    public PyFileImpl(FileViewProvider viewProvider, Language language) {
        super(viewProvider, language);
        this.myFutureFeatures = new HashMap<FutureFeature, Boolean>();
        this.myModificationTracker = PsiModificationTracker.getInstance(this.getProject());
    }

    @Override
    @NotNull
    public FileType getFileType() {
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        if (pythonFileType == null) {
            PyFileImpl.$$$reportNull$$$0(0);
        }
        return pythonFileType;
    }

    @Override
    public String toString() {
        return "PyFile:" + this.getName();
    }

    @Override
    public PyFunction findTopLevelFunction(@NotNull String name) {
        if (name == null) {
            PyFileImpl.$$$reportNull$$$0(1);
        }
        return PyFileImpl.findByName(name, this.getTopLevelFunctions());
    }

    @Override
    public PyClass findTopLevelClass(@NotNull String name) {
        if (name == null) {
            PyFileImpl.$$$reportNull$$$0(2);
        }
        return PyFileImpl.findByName(name, this.getTopLevelClasses());
    }

    @Override
    public PyTargetExpression findTopLevelAttribute(@NotNull String name) {
        if (name == null) {
            PyFileImpl.$$$reportNull$$$0(3);
        }
        return PyFileImpl.findByName(name, this.getTopLevelAttributes());
    }

    @Nullable
    private static <T extends PsiNamedElement> T findByName(@NotNull String name, @NotNull List<T> namedElements) {
        if (name == null) {
            PyFileImpl.$$$reportNull$$$0(4);
        }
        if (namedElements == null) {
            PyFileImpl.$$$reportNull$$$0(5);
        }
        for (PsiNamedElement namedElement : namedElements) {
            if (!name.equals(namedElement.getName())) continue;
            return (T)namedElement;
        }
        return null;
    }

    @Override
    public LanguageLevel getLanguageLevel() {
        VirtualFile virtualFile;
        if (this.myOriginalFile != null) {
            PsiFile originalPythonFile = this.myOriginalFile;
            if (this.myOriginalFile.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
                originalPythonFile = this.myOriginalFile.getViewProvider().getPsi(PythonLanguage.getInstance());
            }
            if (originalPythonFile instanceof PyFile) {
                return ((PyFile)originalPythonFile).getLanguageLevel();
            }
        }
        if ((virtualFile = this.getVirtualFile()) == null) {
            virtualFile = this.getViewProvider().getVirtualFile();
        }
        return PythonLanguageLevelPusher.getLanguageLevelForVirtualFile(this.getProject(), virtualFile);
    }

    @Override
    public Icon getIcon(int flags) {
        return PythonFileType.INSTANCE.getIcon();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PyFileImpl.$$$reportNull$$$0(6);
        }
        if (this.isAcceptedFor(visitor.getClass())) {
            if (visitor instanceof PyElementVisitor) {
                ((PyElementVisitor)visitor).visitPyFile(this);
            } else {
                super.accept(visitor);
            }
        }
    }

    public boolean isAcceptedFor(@NotNull Class visitorClass) {
        if (visitorClass == null) {
            PyFileImpl.$$$reportNull$$$0(7);
        }
        for (Language lang : this.getViewProvider().getLanguages()) {
            List<PythonVisitorFilter> filters = PythonVisitorFilter.INSTANCE.allForLanguage(lang);
            for (PythonVisitorFilter filter : filters) {
                if (filter.isSupported(visitorClass, this)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState resolveState, PsiElement lastParent, @NotNull PsiElement place) {
        List<String> dunderAll;
        if (processor == null) {
            PyFileImpl.$$$reportNull$$$0(8);
        }
        if (resolveState == null) {
            PyFileImpl.$$$reportNull$$$0(9);
        }
        if (place == null) {
            PyFileImpl.$$$reportNull$$$0(10);
        }
        final ArrayList<String> remainingDunderAll = (dunderAll = this.getDunderAll()) == null ? null : new ArrayList<String>(dunderAll);
        DelegatingScopeProcessor wrapper = new DelegatingScopeProcessor(processor){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!super.execute(element, state)) {
                    return false;
                }
                if (remainingDunderAll != null && element instanceof PyElement) {
                    remainingDunderAll.remove(((PyElement)element).getName());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/impl/PyFileImpl$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Set<PyFile> pyFiles = resolveState.get(this.PROCESSED_FILES);
        if (pyFiles == null) {
            pyFiles = new HashSet<PyFile>();
            resolveState = resolveState.put(this.PROCESSED_FILES, pyFiles);
        }
        if (pyFiles.contains(this)) {
            return true;
        }
        pyFiles.add(this);
        for (PyClass pyClass : this.getTopLevelClasses()) {
            if (pyClass == lastParent || wrapper.execute(pyClass, resolveState)) continue;
            return false;
        }
        for (PyFunction pyFunction : this.getTopLevelFunctions()) {
            if (pyFunction == lastParent || wrapper.execute(pyFunction, resolveState)) continue;
            return false;
        }
        for (PyTargetExpression pyTargetExpression : this.getTopLevelAttributes()) {
            if (pyTargetExpression == lastParent || wrapper.execute(pyTargetExpression, resolveState)) continue;
            return false;
        }
        for (PyImportElement pyImportElement : this.getImportTargets()) {
            if (pyImportElement == lastParent || wrapper.execute(pyImportElement, resolveState)) continue;
            return false;
        }
        for (PyFromImportStatement pyFromImportStatement : this.getFromImports()) {
            if (pyFromImportStatement == lastParent || pyFromImportStatement.processDeclarations((PsiScopeProcessor)wrapper, resolveState, null, this)) continue;
            return false;
        }
        if (remainingDunderAll != null) {
            for (String string : remainingDunderAll) {
                if (!PyNames.isIdentifier((String)string) || processor.execute(new LightNamedElement(this.myManager, PythonLanguage.getInstance(), string), resolveState)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<PyStatement> getStatements() {
        ArrayList<PyStatement> stmts = new ArrayList<PyStatement>();
        for (PsiElement child : this.getChildren()) {
            if (!(child instanceof PyStatement)) continue;
            PyStatement statement = (PyStatement)child;
            stmts.add(statement);
        }
        return stmts;
    }

    @Override
    @NotNull
    public List<PyClass> getTopLevelClasses() {
        List<PyClass> list = PyPsiUtils.collectStubChildren(this, this.getStub(), PyElementTypes.CLASS_DECLARATION);
        if (list == null) {
            PyFileImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PyFunction> getTopLevelFunctions() {
        List<PyFunction> list = PyPsiUtils.collectStubChildren(this, this.getStub(), PyElementTypes.FUNCTION_DECLARATION);
        if (list == null) {
            PyFileImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    public List<PyTargetExpression> getTopLevelAttributes() {
        return PyPsiUtils.collectStubChildren(this, this.getStub(), PyElementTypes.TARGET_EXPRESSION);
    }

    @Override
    @Nullable
    public PsiElement findExportedName(String name) {
        PsiElement element;
        List<RatedResolveResult> results = this.multiResolveName(name);
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (RatedResolveResult result : results) {
            PsiElement element2 = result.getElement();
            ImportedResolveResult importedResult = PyUtil.as(result, ImportedResolveResult.class);
            if (importedResult != null) {
                PyImportedNameDefiner definer = importedResult.getDefiner();
                if (definer == null) continue;
                elements.add(definer);
                continue;
            }
            if (element2 == null || element2.getContainingFile() != this) continue;
            elements.add(element2);
        }
        PsiElement psiElement = element = elements.isEmpty() ? null : (PsiElement)elements.get(elements.size() - 1);
        if (element != null && !element.isValid()) {
            throw new PsiInvalidElementAccessException(element);
        }
        return element;
    }

    @Override
    @NotNull
    public List<RatedResolveResult> multiResolveName(@NotNull String name) {
        if (name == null) {
            PyFileImpl.$$$reportNull$$$0(13);
        }
        List<RatedResolveResult> list = this.multiResolveName(name, true);
        if (list == null) {
            PyFileImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public List<RatedResolveResult> multiResolveName(@NotNull String name, boolean exported) {
        List results;
        if (name == null) {
            PyFileImpl.$$$reportNull$$$0(15);
        }
        if ((results = RecursionManager.doPreventingRecursion(this, false, () -> this.getExportedNameCache().multiResolve(name))) != null && !results.isEmpty()) {
            List list = results;
            if (list == null) {
                PyFileImpl.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<String> allNames = this.getDunderAll();
        if (allNames != null && !name.contains(".") && allNames.contains(name)) {
            ResolveResultList allFallbackResults = new ResolveResultList();
            PyResolveImportUtil.resolveModuleAt((QualifiedName)QualifiedName.fromComponents(name), (PsiFileSystemItem)this.getContainingDirectory(), (PyQualifiedNameResolveContext)PyResolveImportUtil.fromFoothold((PsiElement)this)).forEach(module -> allFallbackResults.poke((PsiElement)module, -1000));
            PsiElement allElement = this.findExportedName("__all__");
            allFallbackResults.poke(allElement, -1000);
            ResolveResultList resolveResultList = allFallbackResults;
            if (resolveResultList == null) {
                PyFileImpl.$$$reportNull$$$0(17);
            }
            return resolveResultList;
        }
        List<RatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            PyFileImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    private ExportedNameCache getExportedNameCache() {
        ExportedNameCache cache = (ExportedNameCache)this.myExportedNameCache.get();
        long modificationStamp = this.getModificationStamp();
        if (cache != null && modificationStamp != cache.getModificationStamp()) {
            this.myExportedNameCache.clear();
            cache = null;
        }
        if (cache == null) {
            cache = new ExportedNameCache(modificationStamp);
            this.myExportedNameCache = new SoftReference<ExportedNameCache>(cache);
        }
        return cache;
    }

    @Override
    @Nullable
    public PsiElement getElementNamed(String name) {
        PsiElement element;
        List<RatedResolveResult> results = this.multiResolveName(name);
        List<PsiElement> elements = PyUtil.filterTopPriorityResults(results.toArray(ResolveResult.EMPTY_ARRAY));
        PsiElement psiElement = element = elements.isEmpty() ? null : elements.get(elements.size() - 1);
        if (element != null) {
            if (!element.isValid()) {
                throw new PsiInvalidElementAccessException(element);
            }
            return element;
        }
        return null;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        final ArrayList<PyElement> result = new ArrayList<PyElement>();
        VariantsProcessor processor = new VariantsProcessor(this){

            @Override
            protected void addElement(@NotNull String name, @NotNull PsiElement element) {
                if (name == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((element = PyUtil.turnDirIntoInit(element)) instanceof PyElement) {
                    result.add((PyElement)element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/impl/PyFileImpl$2";
                objectArray[2] = "addElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor.setAllowedNames(this.getDunderAll());
        this.processDeclarations(processor, ResolveState.initial(), null, this);
        ArrayList<PyElement> arrayList = result;
        if (arrayList == null) {
            PyFileImpl.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<PyImportElement> getImportTargets() {
        ArrayList<PyImportElement> ret = new ArrayList<PyImportElement>();
        List<PyImportStatement> imports = PyPsiUtils.collectStubChildren(this, this.getStub(), PyElementTypes.IMPORT_STATEMENT);
        for (PyImportStatement one : imports) {
            ContainerUtil.addAll(ret, one.getImportElements());
        }
        ArrayList<PyImportElement> arrayList = ret;
        if (arrayList == null) {
            PyFileImpl.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<PyFromImportStatement> getFromImports() {
        List<PyFromImportStatement> list = PyPsiUtils.collectStubChildren(this, this.getStub(), PyElementTypes.FROM_IMPORT_STATEMENT);
        if (list == null) {
            PyFileImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Override
    @Nullable
    public List<String> getDunderAll() {
        StubElement stubElement = this.getStub();
        if (stubElement instanceof PyFileStub) {
            return ((PyFileStub)stubElement).getDunderAll();
        }
        if (!this.myDunderAllCalculated) {
            List<String> dunderAll = this.calculateDunderAll();
            this.myDunderAll = dunderAll == null ? null : Collections.unmodifiableList(dunderAll);
            this.myDunderAllCalculated = true;
        }
        return this.myDunderAll;
    }

    @Nullable
    public List<String> calculateDunderAll() {
        DunderAllBuilder builder = new DunderAllBuilder();
        this.accept(builder);
        return builder.result();
    }

    @Override
    public boolean hasImportFromFuture(FutureFeature feature) {
        StubElement stub = this.getStub();
        if (stub instanceof PyFileStub) {
            return ((PyFileStub)stub).getFutureFeatures().get(feature.ordinal());
        }
        Boolean enabled = this.myFutureFeatures.get((Object)feature);
        if (enabled == null) {
            enabled = this.calculateImportFromFuture(feature);
            this.myFutureFeatures.put(feature, enabled);
        }
        return enabled;
    }

    @Override
    public String getDeprecationMessage() {
        StubElement stub = this.getStub();
        if (stub instanceof PyFileStub) {
            return ((PyFileStub)stub).getDeprecationMessage();
        }
        return this.extractDeprecationMessage();
    }

    @Override
    public List<PyImportStatementBase> getImportBlock() {
        ArrayList<PyImportStatementBase> result = new ArrayList<PyImportStatementBase>();
        PsiElement firstChild = this.getFirstChild();
        PsiElement currentStatement = firstChild instanceof PyImportStatementBase ? firstChild : PsiTreeUtil.getNextSiblingOfType(firstChild, PyImportStatementBase.class);
        if (currentStatement != null) {
            ArrayList<PyImportStatementBase> fromFuture = new ArrayList<PyImportStatementBase>();
            while (currentStatement instanceof PyFromImportStatement && ((PyFromImportStatement)currentStatement).isFromFuture()) {
                fromFuture.add((PyImportStatementBase)currentStatement);
                currentStatement = PyPsiUtils.getNextNonCommentSibling(currentStatement, true);
            }
            boolean hasModuleLevelDunders = false;
            while (AddImportHelper.isAssignmentToModuleLevelDunderName(currentStatement)) {
                hasModuleLevelDunders = true;
                currentStatement = PyPsiUtils.getNextNonCommentSibling(currentStatement, true);
            }
            if (!hasModuleLevelDunders) {
                result.addAll(fromFuture);
            }
            while (currentStatement instanceof PyImportStatementBase) {
                result.add((PyImportStatementBase)currentStatement);
                currentStatement = PyPsiUtils.getNextNonCommentSibling(currentStatement, true);
            }
        }
        return result;
    }

    public String extractDeprecationMessage() {
        if (PyFileImpl.canHaveDeprecationMessage(this.getText())) {
            return PyFunctionImpl.extractDeprecationMessage(this.getStatements());
        }
        return null;
    }

    private static boolean canHaveDeprecationMessage(String text) {
        return text.contains("DeprecationWarning") || text.contains("PendingDeprecationWarning");
    }

    public boolean calculateImportFromFuture(FutureFeature feature) {
        if (this.getText().contains(feature.toString())) {
            List<PyFromImportStatement> fromImports = this.getFromImports();
            for (PyFromImportStatement fromImport : fromImports) {
                PyImportElement[] pyImportElements;
                if (!fromImport.isFromFuture()) continue;
                for (PyImportElement element : pyImportElements = fromImport.getImportElements()) {
                    QualifiedName qName = element.getImportedQName();
                    if (qName == null || !qName.matches(feature.toString())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyFileImpl.$$$reportNull$$$0(22);
        }
        if (key == null) {
            PyFileImpl.$$$reportNull$$$0(23);
        }
        if (this.myType == null) {
            this.myType = new PyModuleType(this);
        }
        return this.myType;
    }

    @Override
    @Nullable
    public String getDocStringValue() {
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return DocStringUtil.getStructuredDocString(this);
    }

    @Override
    @Nullable
    public PyStringLiteralExpression getDocStringExpression() {
        return DocStringUtil.findDocStringExpression(this);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        ControlFlowCache.clear(this);
        this.myDunderAllCalculated = false;
        this.myFutureFeatures.clear();
        this.myExportedNameCache.clear();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        String path = this.getVirtualFile().getPath();
        super.delete();
        PyUtil.deletePycFiles(path);
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PyFileImpl.$$$reportNull$$$0(24);
        }
        String path = this.getVirtualFile().getPath();
        PsiElement newElement = super.setName(name);
        PyUtil.deletePycFiles(path);
        return newElement;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Override
            public String getPresentableText() {
                return this.getModuleName(PyFileImpl.this);
            }

            @Override
            public String getLocationString() {
                String name = this.getLocationName();
                return name != null ? "(" + name + ")" : null;
            }

            @Override
            public Icon getIcon(boolean open) {
                if (PyUtil.isPackage(PyFileImpl.this)) {
                    return AllIcons.Nodes.Package;
                }
                return PyFileImpl.this.getIcon(0);
            }

            @NotNull
            private String getModuleName(@NotNull PyFile file) {
                PsiDirectory dir;
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (PyUtil.isPackage(file) && (dir = file.getContainingDirectory()) != null) {
                    String string = dir.getName();
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = FileUtilRt.getNameWithoutExtension(file.getName());
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Nullable
            private String getLocationName() {
                QualifiedName prefix;
                QualifiedName name = QualifiedNameFinder.findShortestImportableQName(PyFileImpl.this);
                if (name != null && (prefix = name.removeTail(1)).getComponentCount() > 0) {
                    return prefix.toString();
                }
                String relativePath = this.getRelativeContainerPath();
                if (relativePath != null) {
                    return relativePath;
                }
                PsiDirectory psiDirectory = PyFileImpl.this.getParent();
                if (psiDirectory != null) {
                    return psiDirectory.getVirtualFile().getPresentableUrl();
                }
                return null;
            }

            @Nullable
            private String getRelativeContainerPath() {
                VirtualFile root;
                VirtualFile virtualFile;
                PsiDirectory psiDirectory = PyFileImpl.this.getParent();
                if (psiDirectory != null && (virtualFile = PyFileImpl.this.getVirtualFile()) != null && (root = ProjectFileIndex.getInstance(PyFileImpl.this.getProject()).getContentRootForFile(virtualFile)) != null) {
                    VirtualFile parent = virtualFile.getParent();
                    VirtualFile rootParent = root.getParent();
                    if (rootParent != null && parent != null) {
                        return VfsUtilCore.getRelativePath((VirtualFile)parent, (VirtualFile)rootParent, (char)File.separatorChar);
                    }
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/psi/impl/PyFileImpl$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/psi/impl/PyFileImpl$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getModuleName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getModuleName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 15, 22, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyFileImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitorClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyFileImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelFunctions";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNames";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportTargets";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelFunction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelAttribute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedFor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 15, 22, 23, 24 -> new IllegalArgumentException(string);
        };
    }

    private final class ExportedNameCache {
        private final List<String> myNameDefinerNegativeCache = new ArrayList<String>();
        private long myNameDefinerOOCBModCount = -1L;
        private final long myModificationStamp;
        private final Map<String, List<PsiNamedElement>> myNamedElements = Maps.newHashMap();
        private final List<PyImportedNameDefiner> myImportedNameDefiners = new ArrayList<PyImportedNameDefiner>();

        private ExportedNameCache(long modificationStamp) {
            this.myModificationStamp = modificationStamp;
            StubElement stub = PyFileImpl.this.getStub();
            this.processDeclarations(PyPsiUtils.collectAllStubChildren(PyFileImpl.this, stub), element -> {
                if (!(!(element instanceof PsiNamedElement) || element instanceof PyKeywordArgument || stub == null && element.getParent() instanceof PyImportElement)) {
                    PsiNamedElement namedElement = (PsiNamedElement)element;
                    this.myNamedElements.computeIfAbsent(namedElement.getName(), __ -> new ArrayList()).add(namedElement);
                }
                if (element instanceof PyImportedNameDefiner) {
                    this.myImportedNameDefiners.add((PyImportedNameDefiner)element);
                }
                if (element instanceof PyFromImportStatement) {
                    PyFromImportStatement fromImportStatement = (PyFromImportStatement)element;
                    PyStarImportElement starImportElement = fromImportStatement.getStarImportElement();
                    if (starImportElement != null) {
                        this.myImportedNameDefiners.add(starImportElement);
                    } else {
                        Collections.addAll(this.myImportedNameDefiners, fromImportStatement.getImportElements());
                    }
                } else if (element instanceof PyImportStatement) {
                    PyImportStatement importStatement = (PyImportStatement)element;
                    Collections.addAll(this.myImportedNameDefiners, importStatement.getImportElements());
                }
                return true;
            });
            for (List<PsiNamedElement> elements : this.myNamedElements.values()) {
                Collections.reverse(elements);
            }
            Collections.reverse(this.myImportedNameDefiners);
        }

        private boolean processDeclarations(@NotNull List<PsiElement> elements, @NotNull Processor<? super PsiElement> processor) {
            if (elements == null) {
                ExportedNameCache.$$$reportNull$$$0(0);
            }
            if (processor == null) {
                ExportedNameCache.$$$reportNull$$$0(1);
            }
            for (PsiElement child : elements) {
                PyExceptPart part;
                if (!processor.process(child)) {
                    return false;
                }
                if (!(child instanceof PyExceptPart) || this.processDeclarations(PyPsiUtils.collectAllStubChildren(part = (PyExceptPart)child, part.getStub()), processor)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private List<RatedResolveResult> multiResolve(@NotNull String name) {
            Iterator<Map.Entry<PsiElement, PyImportedNameDefiner>> iterator2;
            TypeEvalContext typeEvalContext;
            ResolveResultList resultList;
            Map<PsiElement, PyImportedNameDefiner> results;
            if (name == null) {
                ExportedNameCache.$$$reportNull$$$0(2);
            }
            List<String> list = this.myNameDefinerNegativeCache;
            synchronized (list) {
                long modCount = PyFileImpl.this.myModificationTracker.getModificationCount();
                if (modCount != this.myNameDefinerOOCBModCount) {
                    this.myNameDefinerNegativeCache.clear();
                    this.myNameDefinerOOCBModCount = modCount;
                } else if (this.myNameDefinerNegativeCache.contains(name)) {
                    List<RatedResolveResult> list2 = Collections.emptyList();
                    // MONITOREXIT @DISABLED, blocks:[16, 17, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (list2 == null) {
                        ExportedNameCache.$$$reportNull$$$0(3);
                    }
                    return list2;
                }
            }
            PyResolveProcessor processor = new PyResolveProcessor(name);
            boolean stopped = false;
            if (this.myNamedElements.containsKey(name)) {
                for (PsiNamedElement element : this.myNamedElements.get(name)) {
                    if (processor.execute(element, ResolveState.initial())) continue;
                    stopped = true;
                    break;
                }
            }
            if (!stopped) {
                PyImportedNameDefiner definer;
                Iterator<PsiElement> iterator3 = this.myImportedNameDefiners.iterator();
                while (iterator3.hasNext() && processor.execute(definer = (PyImportedNameDefiner)iterator3.next(), ResolveState.initial())) {
                }
            }
            if (!(results = processor.getResults()).isEmpty()) {
                resultList = new ResolveResultList();
                typeEvalContext = TypeEvalContext.codeInsightFallback(PyFileImpl.this.getProject());
                iterator2 = results.entrySet().iterator();
            } else {
                List<String> list3 = this.myNameDefinerNegativeCache;
                synchronized (list3) {
                    this.myNameDefinerNegativeCache.add(name);
                }
                List<RatedResolveResult> list4 = Collections.emptyList();
                if (list4 == null) {
                    ExportedNameCache.$$$reportNull$$$0(5);
                }
                return list4;
            }
            while (iterator2.hasNext()) {
                Map.Entry<PsiElement, PyImportedNameDefiner> entry = iterator2.next();
                PsiElement element = entry.getKey();
                PyImportedNameDefiner definer = entry.getValue();
                if (element == null) continue;
                int elementRate = PyReferenceImpl.getRate(element, typeEvalContext);
                if (definer != null) {
                    resultList.add(new ImportedResolveResult(element, elementRate, definer));
                    continue;
                }
                resultList.poke(element, elementRate);
            }
            ResolveResultList resolveResultList = resultList;
            if (resolveResultList == null) {
                ExportedNameCache.$$$reportNull$$$0(4);
            }
            return resolveResultList;
        }

        public long getModificationStamp() {
            return this.myModificationStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/PyFileImpl$ExportedNameCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyFileImpl$ExportedNameCache";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processDeclarations";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "multiResolve";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class DunderAllBuilder
    extends PyRecursiveElementVisitor {
        @NotNull
        private final List<String> myResult = new ArrayList<String>();
        private boolean myDynamic = false;
        private boolean myFoundDunderAll = false;
        @NotNull
        private final Map<String, List<String>> myDunderLike = new HashMap<String, List<String>>();

        private DunderAllBuilder() {
        }

        @Override
        public void visitPyFile(@NotNull PyFile node) {
            if (node == null) {
                DunderAllBuilder.$$$reportNull$$$0(0);
            }
            if (node.getText().contains("__all__")) {
                super.visitPyFile(node);
            }
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            List<String> names;
            if (node == null) {
                DunderAllBuilder.$$$reportNull$$$0(1);
            }
            if (this.myDynamic) {
                return;
            }
            if ("__all__".equals(node.getName())) {
                this.myFoundDunderAll = true;
                PyExpression value = node.findAssignedValue();
                if (value instanceof PyBinaryExpression) {
                    PyBinaryExpression binaryExpression = (PyBinaryExpression)value;
                    if (binaryExpression.isOperator("+")) {
                        this.processSubList(this.getStringListFromValue(binaryExpression.getLeftExpression()));
                        this.processSubList(this.getStringListFromValue(binaryExpression.getRightExpression()));
                    } else {
                        this.myDynamic = true;
                    }
                } else {
                    this.processSubList(this.getStringListFromValue(value));
                }
            }
            if (!this.myFoundDunderAll && (names = this.getStringListFromValue(node.findAssignedValue())) != null) {
                this.myDunderLike.put(node.getName(), names);
            }
        }

        @Override
        public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
            if (node == null) {
                DunderAllBuilder.$$$reportNull$$$0(2);
            }
            if (this.myDynamic || !this.myFoundDunderAll) {
                return;
            }
            if ("__all__".equals(node.getTarget().getName())) {
                this.processSubList(this.getStringListFromValue(node.getValue()));
            }
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            PyExpression qualifier;
            if (node == null) {
                DunderAllBuilder.$$$reportNull$$$0(3);
            }
            if (this.myDynamic || !this.myFoundDunderAll) {
                return;
            }
            PyExpression callee = node.getCallee();
            if (callee instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)callee).getQualifier()) != null && "__all__".equals(qualifier.getText())) {
                String calleeName = callee.getName();
                if ("append".equals(calleeName)) {
                    PyStringLiteralExpression argument = node.getArgument(0, PyStringLiteralExpression.class);
                    if (argument != null) {
                        this.myResult.add(argument.getStringValue());
                        return;
                    }
                } else if ("extend".equals(calleeName)) {
                    PyExpression argument = node.getArgument(0, PyExpression.class);
                    this.processSubList(this.getStringListFromValue(argument));
                    return;
                }
                this.myDynamic = true;
            }
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                DunderAllBuilder.$$$reportNull$$$0(4);
            }
        }

        @Nullable
        List<String> result() {
            return this.myDynamic || !this.myFoundDunderAll ? null : this.myResult;
        }

        private void processSubList(@Nullable List<String> list) {
            if (list == null) {
                this.myDynamic = true;
            } else {
                this.myResult.addAll(list);
            }
        }

        @Nullable
        private List<String> getStringListFromValue(@Nullable PyExpression expression) {
            if (expression instanceof PyReferenceExpression && !((PyReferenceExpression)expression).isQualified()) {
                return this.myDunderLike.get(((PyReferenceExpression)expression).getReferencedName());
            }
            return PyUtil.strListValue(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/jetbrains/python/psi/impl/PyFileImpl$DunderAllBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAugAssignmentStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

