/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DataEnumerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SimpleStringPersistentEnumerator
implements DataEnumerator<String> {
    @NotNull
    private final Path myFile;
    @NotNull
    private final Object2IntMap<String> myInvertedState;
    @NotNull
    private final Int2ObjectMap<String> myForwardState;

    public SimpleStringPersistentEnumerator(@NotNull Path file) {
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        Pair<Object2IntMap<String>, Int2ObjectMap<String>> pair = SimpleStringPersistentEnumerator.readStorageFromDisk(file);
        this.myInvertedState = pair.getFirst();
        this.myForwardState = pair.getSecond();
    }

    @NotNull
    public Path getFile() {
        Path path = this.myFile;
        if (path == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(1);
        }
        return path;
    }

    @Override
    public synchronized int enumerate(@Nullable String value) {
        int id = this.myInvertedState.getInt((Object)value);
        if (id != this.myInvertedState.defaultReturnValue()) {
            return id;
        }
        if (value != null && StringUtil.containsLineBreak(value)) {
            throw new RuntimeException("SimpleStringPersistentEnumerator doesn't support multi-line strings");
        }
        int n = this.myForwardState.size() + 1;
        this.myInvertedState.put((Object)value, n);
        this.myForwardState.put(n, (Object)value);
        SimpleStringPersistentEnumerator.writeStorageToDisk(this.myForwardState, this.myFile);
        return n;
    }

    @NotNull
    public synchronized Collection<String> entries() {
        return new ArrayList<String>((Collection<String>)this.myInvertedState.keySet());
    }

    @NotNull
    public synchronized Map<String, Integer> getInvertedState() {
        Map<String, Integer> map = Collections.unmodifiableMap(this.myInvertedState);
        if (map == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(2);
        }
        return map;
    }

    @Override
    @Nullable
    public synchronized String valueOf(int idx) {
        return (String)this.myForwardState.get(idx);
    }

    public synchronized void forceDiskSync() {
        SimpleStringPersistentEnumerator.writeStorageToDisk(this.myForwardState, this.myFile);
    }

    public synchronized boolean isEmpty() {
        return this.myInvertedState.isEmpty();
    }

    public synchronized int getSize() {
        return this.myInvertedState.size();
    }

    @NotNull
    public String dumpToString() {
        String string = this.myInvertedState.object2IntEntrySet().stream().sorted(Comparator.comparing(e -> e.getIntValue())).map(e -> (String)e.getKey() + "->" + e.getIntValue()).collect(Collectors.joining("\n"));
        if (string == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static Pair<Object2IntMap<String>, Int2ObjectMap<String>> readStorageFromDisk(@NotNull Path file) {
        Pair<Object2IntOpenHashMap, Int2ObjectOpenHashMap> pair;
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(4);
        }
        try {
            Object2IntOpenHashMap nameToIdRegistry = new Object2IntOpenHashMap();
            Int2ObjectOpenHashMap idToNameRegistry = new Int2ObjectOpenHashMap();
            List<String> lines = Files.readAllLines(file, Charset.defaultCharset());
            for (int i = 0; i < lines.size(); ++i) {
                String name = lines.get(i);
                nameToIdRegistry.put((Object)name, i + 1);
                idToNameRegistry.put(i + 1, (Object)name);
            }
            pair = Pair.create(nameToIdRegistry, idToNameRegistry);
        }
        catch (IOException e) {
            SimpleStringPersistentEnumerator.writeStorageToDisk((Int2ObjectMap<String>)Int2ObjectMaps.emptyMap(), file);
            Pair<Object2IntOpenHashMap, Int2ObjectOpenHashMap> pair2 = Pair.create(new Object2IntOpenHashMap(), new Int2ObjectOpenHashMap());
            if (pair2 == null) {
                SimpleStringPersistentEnumerator.$$$reportNull$$$0(6);
            }
            return pair2;
        }
        if (pair == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(5);
        }
        return pair;
    }

    private static void writeStorageToDisk(@NotNull Int2ObjectMap<String> forwardIndex, @NotNull Path file) {
        if (forwardIndex == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(7);
        }
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(8);
        }
        try {
            String[] names = new String[forwardIndex.size()];
            ObjectIterator iterator2 = Int2ObjectMaps.fastIterator(forwardIndex);
            while (iterator2.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator2.next();
                names[entry.getIntKey() - 1] = (String)entry.getValue();
            }
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.write(file, Arrays.asList(names), Charset.defaultCharset(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/SimpleStringPersistentEnumerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/SimpleStringPersistentEnumerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvertedState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpToString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readStorageFromDisk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readStorageFromDisk";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeStorageToDisk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

