/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCodeStyleDocString
extends SectionBasedDocString {
    public static final Pattern SECTION_HEADER = Pattern.compile("^[ \t]*([\\w \t]+):[ \t]*$", 8);
    private static final Pattern FIELD_NAME_AND_TYPE = Pattern.compile("^[ \t]*(.+?)[ \t]*\\([ \t]*(.*?)[ \t]*\\)?[ \t]*$", 8);
    public static final List<String> PREFERRED_SECTION_HEADERS = ImmutableList.of((Object)"Args", (Object)"Keyword Args", (Object)"Returns", (Object)"Yields", (Object)"Raises", (Object)"Attributes", (Object)"See Also", (Object)"Methods", (Object)"References", (Object)"Examples", (Object)"Notes", (Object)"Warnings", (Object[])new String[0]);
    private static final ImmutableMap<String, SectionBasedDocString.FieldType> ourSectionFieldMapping = ImmutableMap.builder().put((Object)"returns", (Object)SectionBasedDocString.FieldType.OPTIONAL_TYPE).put((Object)"yields", (Object)SectionBasedDocString.FieldType.OPTIONAL_TYPE).put((Object)"raises", (Object)SectionBasedDocString.FieldType.ONLY_TYPE).put((Object)"methods", (Object)SectionBasedDocString.FieldType.ONLY_NAME).put((Object)"keyword arguments", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).put((Object)"parameters", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).put((Object)"attributes", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).put((Object)"other parameters", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).build();

    public GoogleCodeStyleDocString(@NotNull Substring text) {
        if (text == null) {
            GoogleCodeStyleDocString.$$$reportNull$$$0(0);
        }
        super(text);
    }

    @Override
    @Nullable
    protected SectionBasedDocString.FieldType getFieldType(@NotNull String title) {
        if (title == null) {
            GoogleCodeStyleDocString.$$$reportNull$$$0(1);
        }
        return (SectionBasedDocString.FieldType)((Object)ourSectionFieldMapping.get((Object)title));
    }

    @Override
    protected Pair<SectionBasedDocString.SectionField, Integer> parseSectionField(int lineNum, int sectionIndent, @NotNull SectionBasedDocString.FieldType fieldType) {
        Substring description;
        if (fieldType == null) {
            GoogleCodeStyleDocString.$$$reportNull$$$0(2);
        }
        Substring line = this.getLine(lineNum);
        Substring name = null;
        Substring type = null;
        List<Substring> colonSeparatedParts = GoogleCodeStyleDocString.splitByFirstColon(line);
        assert (colonSeparatedParts.size() <= 2);
        Substring textBeforeColon = colonSeparatedParts.get(0);
        if (colonSeparatedParts.size() == 2 || !fieldType.canHaveOnlyDescription) {
            Matcher matcher;
            description = colonSeparatedParts.size() == 2 ? colonSeparatedParts.get(1) : null;
            name = textBeforeColon.trim();
            if (fieldType.canHaveBothNameAndType && (matcher = FIELD_NAME_AND_TYPE.matcher((CharSequence)textBeforeColon)).matches()) {
                name = textBeforeColon.getMatcherGroup(matcher, 1).trim();
                type = textBeforeColon.getMatcherGroup(matcher, 2).trim();
            }
            if (fieldType.preferType && type == null) {
                type = name;
                name = null;
            }
            if (name != null) {
                name = GoogleCodeStyleDocString.cleanUpName(name);
            }
            if (name != null ? !this.isValidName(name.toString()) : !this.isValidType(type.toString())) {
                return Pair.create(null, lineNum);
            }
        } else {
            description = textBeforeColon;
        }
        if (description != null) {
            Pair<List<Substring>, Integer> pair = this.parseFieldContinuation(lineNum, fieldType);
            List<Substring> nestedBlock = pair.getFirst();
            if (!nestedBlock.isEmpty()) {
                description = description.union(ContainerUtil.getLastItem(nestedBlock));
            }
            description = description.trim();
            return Pair.create(new SectionBasedDocString.SectionField(name, type, description), pair.getSecond());
        }
        return Pair.create(new SectionBasedDocString.SectionField(name, type, null), lineNum + 1);
    }

    @Override
    @NotNull
    protected Pair<Substring, Integer> parseSectionHeader(int lineNum) {
        Substring title;
        Substring line = this.getLine(lineNum);
        Matcher matcher = SECTION_HEADER.matcher((CharSequence)line);
        if (matcher.matches() && GoogleCodeStyleDocString.isValidSectionTitle((title = line.getMatcherGroup(matcher, 1).trim()).toString())) {
            Pair<Substring, Integer> pair = Pair.create(title, lineNum + 1);
            if (pair == null) {
                GoogleCodeStyleDocString.$$$reportNull$$$0(3);
            }
            return pair;
        }
        Pair<Object, Integer> pair = Pair.create(null, lineNum);
        if (pair == null) {
            GoogleCodeStyleDocString.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/GoogleCodeStyleDocString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/GoogleCodeStyleDocString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSectionHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFieldType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseSectionField";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

