/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.trait;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.trait.Reference;
import org.openrewrite.yaml.tree.Yaml;

public abstract class YamlReference
implements Reference {
    public String getValue() {
        if (this.getTree() instanceof Yaml.Scalar) {
            return ((Yaml.Scalar)this.getTree()).getValue();
        }
        throw new IllegalArgumentException("getTree() must be an Yaml.Scalar: " + this.getTree().getClass());
    }

    public boolean supportsRename() {
        return true;
    }

    public Tree rename(Reference.Renamer renamer, Cursor cursor, ExecutionContext ctx) {
        Tree tree = (Tree)cursor.getValue();
        if (tree instanceof Yaml.Scalar) {
            return ((Yaml.Scalar)tree).withValue(renamer.rename((Reference)this));
        }
        throw new IllegalArgumentException("cursor.getValue() must be an Yaml.Scalar but is: " + tree.getClass());
    }

    public static abstract class YamlProvider
    extends Reference.AbstractProvider<YamlReference> {
        public boolean isAcceptable(SourceFile sourceFile) {
            return sourceFile instanceof Yaml.Documents;
        }
    }
}

