/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.opensearch._types.aggregations.MatrixStatsFields;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class MatrixStatsAggregate
extends AggregateBase
implements AggregateVariant {
    private final long docCount;
    private final List<MatrixStatsFields> fields;
    public static final JsonpDeserializer<MatrixStatsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatrixStatsAggregate::setupMatrixStatsAggregateDeserializer);

    private MatrixStatsAggregate(Builder builder) {
        super(builder);
        this.docCount = ApiTypeHelper.requireNonNull(builder.docCount, this, "docCount");
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
    }

    public static MatrixStatsAggregate of(Function<Builder, ObjectBuilder<MatrixStatsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.MatrixStats;
    }

    public final long docCount() {
        return this.docCount;
    }

    public final List<MatrixStatsFields> fields() {
        return this.fields;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("doc_count");
        generator.write(this.docCount);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (MatrixStatsFields item0 : this.fields) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupMatrixStatsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        MatrixStatsAggregate.setupAggregateBaseDeserializer(op);
        op.add(Builder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(MatrixStatsFields._DESERIALIZER), "fields");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MatrixStatsAggregate> {
        private Long docCount;
        private List<MatrixStatsFields> fields;

        public final Builder docCount(long value) {
            this.docCount = value;
            return this;
        }

        public final Builder fields(List<MatrixStatsFields> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(MatrixStatsFields value, MatrixStatsFields ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder fields(Function<MatrixStatsFields.Builder, ObjectBuilder<MatrixStatsFields>> fn) {
            return this.fields(fn.apply(new MatrixStatsFields.Builder()).build(), new MatrixStatsFields[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MatrixStatsAggregate build() {
            this._checkSingleUse();
            return new MatrixStatsAggregate(this);
        }
    }
}

