/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.clone;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.ops4j.pax.construct.util.StreamFactory;

public class ArchetypeModel {
    private Xpp3Dom m_dom = new Xpp3Dom("archetype");

    private static Xpp3Dom getNode(Xpp3Dom node, String name) {
        Xpp3Dom tag = node.getChild(name);
        if (null == tag) {
            tag = new Xpp3Dom(name);
            node.addChild(tag);
        }
        return tag;
    }

    public void setId(String id) {
        Xpp3Dom tag = ArchetypeModel.getNode(this.m_dom, "id");
        tag.setValue(id);
    }

    public void setAllowPartial(boolean allowPartial) {
        Xpp3Dom tag = ArchetypeModel.getNode(this.m_dom, "allowPartial");
        tag.setValue(Boolean.toString(allowPartial));
    }

    public void addSource(String entry) {
        Xpp3Dom sources = ArchetypeModel.getNode(this.m_dom, "sources");
        Xpp3Dom tag = new Xpp3Dom("source");
        tag.setValue(entry);
        sources.addChild(tag);
    }

    public void addTestSource(String entry) {
        Xpp3Dom testSources = ArchetypeModel.getNode(this.m_dom, "testSources");
        Xpp3Dom tag = new Xpp3Dom("source");
        tag.setValue(entry);
        testSources.addChild(tag);
    }

    public void addResource(String entry, boolean isFiltered) {
        Xpp3Dom resources = ArchetypeModel.getNode(this.m_dom, "resources");
        Xpp3Dom tag = new Xpp3Dom("resource");
        tag.setValue(entry);
        if (!isFiltered) {
            tag.setAttribute("filtered", "false");
        }
        resources.addChild(tag);
    }

    public void addTestResource(String entry, boolean isFiltered) {
        Xpp3Dom testResources = ArchetypeModel.getNode(this.m_dom, "testResources");
        Xpp3Dom tag = new Xpp3Dom("resource");
        tag.setValue(entry);
        if (!isFiltered) {
            tag.setAttribute("filtered", "false");
        }
        testResources.addChild(tag);
    }

    public void write(File file) throws IOException {
        file.getParentFile().mkdirs();
        Writer writer = StreamFactory.newXmlWriter(file);
        Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)this.m_dom);
        IOUtil.close((Writer)writer);
    }
}

