/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.clone;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.ops4j.pax.construct.clone.ArchetypeFragment;
import org.ops4j.pax.construct.clone.PaxCommandBuilder;
import org.ops4j.pax.construct.clone.PaxScript;
import org.ops4j.pax.construct.clone.PaxScriptImpl;
import org.ops4j.pax.construct.util.DirUtils;
import org.ops4j.pax.construct.util.PomUtils;

public class CloneMojo
extends AbstractMojo {
    private ArchiverManager m_archiverManager;
    private String m_rootGroupId;
    private String m_rootArtifactId;
    private File m_basedir;
    private File m_tempdir;
    private List m_reactorProjects;
    private boolean repair;
    private boolean unify;
    private List m_handledDirs;
    private Map m_majorProjectMap;
    private Map m_bundleNameMap;
    private List m_installCommands;

    public void execute() throws MojoExecutionException {
        PaxScriptImpl buildScript = new PaxScriptImpl();
        this.m_bundleNameMap = new HashMap();
        this.m_majorProjectMap = new HashMap();
        this.m_handledDirs = new ArrayList();
        this.m_installCommands = new ArrayList();
        this.getFragmentDir().mkdirs();
        Iterator i = this.m_reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject project = (MavenProject)i.next();
            String packaging = project.getPackaging();
            if (this.m_reactorProjects.size() == 1) {
                this.repair = true;
                if ("jar".equals(packaging)) {
                    packaging = "bundle";
                }
            }
            if ("bundle".equals(packaging)) {
                this.handleBundleProject(buildScript, project);
                continue;
            }
            if (!"pom".equals(packaging)) continue;
            if (this.isMajorProject(project)) {
                this.handleMajorProject(buildScript, project);
                continue;
            }
            this.handleBundleImport(buildScript, project);
        }
        this.archiveMajorProjects();
        this.writePlatformScripts(buildScript);
    }

    private void writePlatformScripts(PaxScript script) {
        String cloneId = PomUtils.getCompoundId(this.m_rootGroupId, this.m_rootArtifactId);
        String scriptName = "create-" + cloneId;
        File winScript = new File(this.m_tempdir, scriptName + ".bat");
        File nixScript = new File(this.m_tempdir, scriptName + ".sh");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("SUCCESSFULLY CLONED " + cloneId));
        this.getLog().info((CharSequence)"");
        String title = this.m_rootGroupId + ':' + this.m_rootArtifactId;
        try {
            this.getLog().info((CharSequence)("Saving UNIX shell script " + nixScript));
            script.write(title, nixScript, this.m_installCommands);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to write " + nixScript));
        }
        try {
            this.getLog().info((CharSequence)("Saving Windows batch file " + winScript));
            script.write(title, winScript, this.m_installCommands);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to write " + winScript));
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("CLONE DIRECTORY " + this.m_tempdir));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"(this directory can be zipped and shared with other team members)");
    }

    private void handleMajorProject(PaxScript script, MavenProject project) {
        if (this.unify && !project.isExecutionRoot()) {
            this.m_handledDirs.add(new File(project.getBasedir(), "poms"));
            return;
        }
        PaxCommandBuilder command = script.call("create-project");
        command.option('g', project.getGroupId());
        command.option('a', project.getArtifactId());
        command.option('v', project.getVersion());
        this.setTargetDirectory(command, project.getBasedir().getParentFile());
        this.registerProject(project);
        this.m_majorProjectMap.put(project, command);
    }

    private void handleBundleProject(PaxScript script, MavenProject project) throws MojoExecutionException {
        PaxCommandBuilder command;
        String bundleName;
        String namespace = this.findBundleNamespace(project);
        if (null != namespace) {
            bundleName = project.getArtifactId();
            command = script.call("create-bundle");
            command.option('p', namespace);
            if (!bundleName.equals(namespace)) {
                command.option('n', bundleName);
            }
            command.option('v', project.getVersion());
            command.maven().flag("noDeps");
        } else {
            Dependency wrappee = this.findWrappee(project);
            if (wrappee != null) {
                command = script.call("wrap-jar");
                command.option('g', wrappee.getGroupId());
                command.option('a', wrappee.getArtifactId());
                command.option('v', wrappee.getVersion());
                if (this.repair) {
                    bundleName = PomUtils.getCompoundId(wrappee.getGroupId(), wrappee.getArtifactId());
                    if (project.getArtifactId().endsWith(wrappee.getVersion())) {
                        command.maven().flag("addVersion");
                    }
                } else {
                    bundleName = project.getArtifactId();
                    command.maven().option("bundleName", bundleName);
                    command.maven().option("bundleVersion", project.getVersion());
                }
            } else {
                this.getLog().warn((CharSequence)("Unable to clone bundle project " + project.getId()));
                return;
            }
        }
        PomUtils.Pom customizedPom = null;
        if (this.repair) {
            customizedPom = this.repairBundleImports(script, project);
        } else {
            command.maven().option("bundleGroupId", project.getGroupId());
        }
        this.addFragmentToCommand(command, this.createBundleArchetype(project, namespace, customizedPom));
        this.setTargetDirectory(command, project.getBasedir().getParentFile());
        this.registerProject(project);
        this.registerBundleName(project, bundleName);
    }

    private void handleBundleImport(PaxScript script, MavenProject project) {
        Dependency importee = this.findImportee(project);
        if (importee != null) {
            PaxCommandBuilder command = script.call("import-bundle");
            command.option('g', importee.getGroupId());
            command.option('a', importee.getArtifactId());
            command.option('v', importee.getVersion());
            command.flag('o');
            this.setTargetDirectory(command, this.m_basedir);
            this.registerProject(project);
        }
    }

    private boolean isMajorProject(MavenProject project) {
        if (project.isExecutionRoot()) {
            return true;
        }
        return null == project.getParent() || new File(project.getBasedir(), "poms").isDirectory();
    }

    private Dependency findWrappee(MavenProject project) {
        Properties properties = project.getProperties();
        Dependency wrappee = new Dependency();
        wrappee.setGroupId(properties.getProperty("wrapped.groupId"));
        wrappee.setArtifactId(properties.getProperty("wrapped.artifactId"));
        wrappee.setVersion(properties.getProperty("wrapped.version"));
        if (null == wrappee.getArtifactId()) {
            wrappee.setGroupId(properties.getProperty("jar.groupId"));
            wrappee.setArtifactId(properties.getProperty("jar.artifactId"));
            wrappee.setVersion(properties.getProperty("jar.version"));
            if (null == wrappee.getArtifactId()) {
                return this.findCustomizedWrappee(project);
            }
        }
        return wrappee;
    }

    private Dependency findCustomizedWrappee(MavenProject project) {
        List dependencies = project.getDependencies();
        String sourcePath = project.getBuild().getSourceDirectory();
        if (dependencies.size() > 0 && !new File(sourcePath).exists()) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                Dependency dependency = (Dependency)i.next();
                if (project.getArtifactId().indexOf(dependency.getArtifactId()) < 0) continue;
                return dependency;
            }
            return (Dependency)dependencies.get(0);
        }
        return null;
    }

    private Dependency findImportee(MavenProject project) {
        Properties properties = project.getProperties();
        Dependency importee = new Dependency();
        importee.setGroupId(properties.getProperty("bundle.groupId"));
        importee.setArtifactId(properties.getProperty("bundle.artifactId"));
        importee.setVersion(properties.getProperty("bundle.version"));
        if (importee.getArtifactId() != null) {
            return importee;
        }
        return null;
    }

    private String findBundleNamespace(MavenProject project) {
        Properties properties = project.getProperties();
        String namespace = properties.getProperty("bundle.namespace");
        if (null == namespace) {
            namespace = properties.getProperty("bundle.package");
            String sourcePath = project.getBuild().getSourceDirectory();
            if (null == namespace && new File(sourcePath).exists()) {
                namespace = this.findPrimaryPackage(sourcePath);
            }
        }
        return namespace;
    }

    private String findPrimaryPackage(String dir) {
        String[] pathInclude = new String[]{"**/*.java"};
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(pathInclude);
        scanner.setFollowSymlinks(false);
        scanner.addDefaultExcludes();
        scanner.setBasedir(dir);
        scanner.scan();
        String path = null;
        String[] candidates = scanner.getIncludedFiles();
        for (int i = 0; i < scanner.getIncludedFiles().length; ++i) {
            String newPath = candidates[i];
            if (null != path && (!this.validCandidate(path, newPath) || path.length() <= newPath.length())) continue;
            path = newPath;
        }
        return this.getJavaNamespace(path);
    }

    private boolean validCandidate(String current, String candidate) {
        String candidateFolder = new File(candidate).getParentFile().getName();
        if ("internal".equalsIgnoreCase(candidateFolder) || "impl".equalsIgnoreCase(candidateFolder)) {
            return true;
        }
        String currentFolder = new File(current).getParentFile().getName();
        return !"internal".equalsIgnoreCase(currentFolder) && !"impl".equalsIgnoreCase(currentFolder);
    }

    private String getJavaNamespace(String javaFile) {
        if (null == javaFile) {
            return null;
        }
        File packageDir = new File(javaFile).getParentFile();
        if ("internal".equals(packageDir.getName()) || "impl".equals(packageDir.getName())) {
            packageDir = packageDir.getParentFile();
        }
        return packageDir.getPath().replaceAll("[/\\\\]+", ".");
    }

    private void setTargetDirectory(PaxCommandBuilder command, File targetDir) {
        String[] pivot = DirUtils.calculateRelativePath(this.m_basedir.getParentFile(), targetDir);
        if (pivot != null && pivot[0].length() == 0 && pivot[2].length() > 0) {
            String relativePath = StringUtils.replaceOnce((String)pivot[2], (String)this.m_basedir.getName(), (String)this.m_rootArtifactId);
            command.maven().option("targetDirectory", relativePath);
        }
    }

    private String createBundleArchetype(MavenProject project, String namespace, PomUtils.Pom customizedPom) throws MojoExecutionException {
        File baseDir = project.getBasedir();
        this.getLog().info((CharSequence)("Cloning bundle project " + project.getArtifactId()));
        ArchetypeFragment fragment = new ArchetypeFragment(this.getFragmentDir(), namespace, false);
        fragment.addPom(baseDir, customizedPom);
        if (null != namespace) {
            fragment.addSources(baseDir, project.getBuild().getSourceDirectory(), false);
            fragment.addSources(baseDir, project.getBuild().getTestSourceDirectory(), true);
        }
        Iterator i = project.getTestResources().iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            fragment.addResources(baseDir, r.getDirectory(), r.getIncludes(), r.getExcludes(), true);
        }
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(fragment.getIncludedFiles());
        excludes.add("target/");
        excludes.add("runner/");
        excludes.add("pom.xml");
        fragment.addResources(baseDir, baseDir.getPath(), null, excludes, false);
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId() + "-archetype";
        String version = project.getVersion();
        String fragmentId = groupId + ':' + artifactId + ':' + version;
        fragment.createArchive(fragmentId.replace(':', '_'), this.newJarArchiver());
        return fragmentId;
    }

    private PomUtils.Pom repairBundleImports(PaxScript script, MavenProject project) {
        PomUtils.Pom pom;
        try {
            File tempFile = File.createTempFile("pom", ".xml", this.m_tempdir);
            FileUtils.copyFile((File)project.getFile(), (File)tempFile);
            pom = PomUtils.readPom(tempFile);
            tempFile.deleteOnExit();
        }
        catch (IOException e) {
            pom = null;
        }
        Iterator i = project.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            String bundleId = dependency.getGroupId() + ':' + dependency.getArtifactId();
            String bundleName = (String)this.m_bundleNameMap.get(bundleId);
            if (null == bundleName) continue;
            PaxCommandBuilder command = script.call("import-bundle");
            command.option('a', bundleName);
            command.flag('o');
            this.setTargetDirectory(command, project.getBasedir());
            if (null == pom) continue;
            pom.removeDependency(dependency);
        }
        try {
            if (null != pom) {
                pom.write();
            }
            return pom;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void archiveMajorProjects() throws MojoExecutionException {
        Iterator i = this.m_majorProjectMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            MavenProject project = (MavenProject)entry.getKey();
            this.addFragmentToCommand((PaxCommandBuilder)entry.getValue(), this.createProjectArchetype(project));
        }
    }

    private String createProjectArchetype(MavenProject project) throws MojoExecutionException {
        File baseDir = project.getBasedir();
        this.getLog().info((CharSequence)("Cloning primary project " + project.getArtifactId()));
        ArchetypeFragment fragment = new ArchetypeFragment(this.getFragmentDir(), null, this.unify);
        fragment.addPom(baseDir, null);
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(this.getExcludedPaths(project));
        excludes.add("**/target/");
        excludes.add("runner/");
        excludes.add("pom.xml");
        fragment.addResources(baseDir, baseDir.getPath(), null, excludes, false);
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId() + "-archetype";
        String version = project.getVersion();
        String fragmentId = groupId + ':' + artifactId + ':' + version;
        fragment.createArchive(fragmentId.replace(':', '_'), this.newJarArchiver());
        return fragmentId;
    }

    private List getExcludedPaths(MavenProject project) {
        ArrayList<String> excludes = new ArrayList<String>();
        File baseDir = project.getBasedir();
        Iterator i = this.m_handledDirs.iterator();
        while (i.hasNext()) {
            File dir = (File)i.next();
            String[] pivot = DirUtils.calculateRelativePath(baseDir, dir);
            if (pivot == null || pivot[0].length() != 0 || pivot[2].length() <= 0) continue;
            excludes.add(pivot[2]);
        }
        return excludes;
    }

    private Archiver newJarArchiver() throws MojoExecutionException {
        try {
            return this.m_archiverManager.getArchiver("jar");
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unable to find Jar archiver", (Exception)((Object)e));
        }
    }

    private File getFragmentDir() {
        return new File(this.m_tempdir, "fragments");
    }

    private void registerProject(MavenProject project) {
        this.m_handledDirs.add(project.getBasedir());
    }

    private void registerBundleName(MavenProject project, String bundleName) {
        this.m_bundleNameMap.put(project.getGroupId() + ':' + project.getArtifactId(), bundleName);
    }

    private void addFragmentToCommand(PaxCommandBuilder command, String fragmentId) {
        if (null == fragmentId) {
            return;
        }
        command.maven().option("contents", fragmentId);
        StringBuffer buffer = new StringBuffer();
        String[] ids = fragmentId.split(":");
        buffer.append("mvn -N install:install-file \"-Dpackaging=jar\" \"-DgroupId=");
        buffer.append(ids[0]);
        buffer.append("\" \"-DartifactId=");
        buffer.append(ids[1]);
        buffer.append("\" \"-Dversion=");
        buffer.append(ids[2]);
        buffer.append("\" \"-Dfile=${_SCRIPTDIR_}/fragments/");
        buffer.append(fragmentId.replace(':', '_'));
        buffer.append(".jar\"");
        this.m_installCommands.add(buffer);
    }
}

