/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.IOUtil;
import org.ops4j.pax.construct.util.StreamFactory;

public final class CacheUtils {
    private CacheUtils() {
    }

    public static void pushFile(AbstractMojo mojo, String key, File file) {
        if (file.exists()) {
            try {
                Reader input = StreamFactory.newPlatformReader(file);
                mojo.getPluginContext().put(key, IOUtil.toString((Reader)input));
                IOUtil.close((Reader)input);
            }
            catch (IOException e) {
                mojo.getLog().warn((CharSequence)("Unable to read file into cache: " + file));
            }
        }
    }

    public static void pullFile(AbstractMojo mojo, String key, File file) {
        String input = (String)mojo.getPluginContext().get(key);
        if (input != null) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                Writer output = StreamFactory.newPlatformWriter(file);
                IOUtil.copy((String)input, (Writer)output);
                IOUtil.close((Writer)output);
            }
            catch (IOException e) {
                mojo.getLog().warn((CharSequence)("Unable to write file back from cache: " + file));
            }
        }
    }
}

