/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.ops4j.pax.construct.util.PomUtils;

public class PomIterator
implements Iterator {
    private PomUtils.Pom m_pom;
    private PomUtils.Pom m_nextPom;
    private Set m_visited = new HashSet();
    private PomUtils.Pom m_initialPom;

    public PomIterator(File here) {
        this(here, false);
    }

    public PomIterator(File here, boolean localSearch) {
        try {
            this.m_pom = PomUtils.readPom(here);
        }
        catch (IOException e) {
            this.m_pom = null;
        }
        if (localSearch) {
            this.m_initialPom = this.m_pom;
        }
    }

    public Object next() {
        if (null == this.m_nextPom && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.m_pom = this.m_nextPom;
        this.m_nextPom = null;
        return this.m_pom;
    }

    public boolean hasNext() {
        while (null == this.m_nextPom && null != this.m_pom) {
            if (this.m_visited.add(this.m_pom)) {
                this.m_nextPom = this.m_pom;
                this.m_pom = null;
                continue;
            }
            this.m_pom = this.nextModule();
        }
        return null != this.m_nextPom;
    }

    private PomUtils.Pom nextModule() {
        Iterator i = this.m_pom.getModuleNames().iterator();
        while (i.hasNext()) {
            PomUtils.Pom subPom = this.m_pom.getModulePom((String)i.next());
            if (subPom == null || this.m_visited.contains(subPom)) continue;
            return subPom;
        }
        if (this.m_pom.equals(this.m_initialPom)) {
            return null;
        }
        return this.m_pom.getContainingPom();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

