/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.intern;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class DuplicateAwareJarOutputStream
extends JarOutputStream {
    private Set<String> entrynames;
    private boolean writable;

    public DuplicateAwareJarOutputStream(OutputStream outputStream, Manifest manifest) throws IOException {
        super(outputStream, manifest);
    }

    public DuplicateAwareJarOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    @Override
    public void write(int i) throws IOException {
        if (this.writable) {
            super.write(i);
        }
    }

    @Override
    public synchronized void write(byte[] bytes, int i, int i1) throws IOException {
        if (this.writable) {
            super.write(bytes, i, i1);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (this.writable) {
            super.write(bytes);
        }
    }

    @Override
    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        if (this.entrynames == null) {
            this.entrynames = new HashSet<String>();
        }
        if (this.entrynames.add(zipEntry.getName())) {
            super.putNextEntry(zipEntry);
            this.writable = true;
        } else {
            this.writable = false;
        }
    }
}

