/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.solution.cloner.ConcurrentMemoization;
import org.optaplanner.core.impl.domain.solution.cloner.DeepCloningFieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.DeepCloningUtils;
import org.optaplanner.core.impl.domain.solution.cloner.FieldCloningUtils;
import org.optaplanner.core.impl.domain.solution.cloner.ShallowCloningFieldCloner;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

public final class FieldAccessingSolutionCloner<Solution_>
implements SolutionCloner<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final ConcurrentMap<Class<?>, Constructor<?>> constructorMemoization = new ConcurrentMemoization();
    private final ConcurrentMap<Class<?>, ClassMetadata> classMetadataMemoization = new ConcurrentMemoization();

    public FieldAccessingSolutionCloner(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    @Override
    public Solution_ cloneSolution(Solution_ originalSolution) {
        int entityCount = this.solutionDescriptor.getEntityCount(originalSolution);
        IdentityHashMap<Object, Object> originalToCloneMap = new IdentityHashMap<Object, Object>(entityCount + 1);
        ArrayDeque<Unprocessed> unprocessedQueue = new ArrayDeque<Unprocessed>(entityCount + 1);
        Solution_ cloneSolution = this.clone(originalSolution, originalToCloneMap, unprocessedQueue, this.retrieveClassMetadata(originalSolution.getClass()));
        while (!unprocessedQueue.isEmpty()) {
            Unprocessed unprocessed = (Unprocessed)unprocessedQueue.remove();
            Object cloneValue = this.process(unprocessed, originalToCloneMap, unprocessedQueue);
            FieldCloningUtils.setObjectFieldValue(unprocessed.bean, unprocessed.field, cloneValue);
        }
        this.validateCloneSolution(originalSolution, cloneSolution);
        return cloneSolution;
    }

    private Object process(Unprocessed unprocessed, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue) {
        Object originalValue = unprocessed.originalValue;
        Field field = unprocessed.field;
        Class<?> fieldType = field.getType();
        if (originalValue instanceof Collection) {
            return this.cloneCollection(fieldType, (Collection)originalValue, originalToCloneMap, unprocessedQueue);
        }
        if (originalValue instanceof Map) {
            return this.cloneMap(fieldType, (Map)originalValue, originalToCloneMap, unprocessedQueue);
        }
        if (originalValue.getClass().isArray()) {
            return this.cloneArray(fieldType, originalValue, originalToCloneMap, unprocessedQueue);
        }
        return this.clone(originalValue, originalToCloneMap, unprocessedQueue, this.retrieveClassMetadata(originalValue.getClass()));
    }

    private <C> C clone(C original, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue, ClassMetadata declaringClassMetadata) {
        if (original == null) {
            return null;
        }
        Object existingClone = originalToCloneMap.get(original);
        if (existingClone != null) {
            return (C)existingClone;
        }
        Class<?> declaringClass = original.getClass();
        Object clone = this.constructClone(declaringClass);
        originalToCloneMap.put(original, clone);
        this.copyFields(declaringClass, original, clone, unprocessedQueue, declaringClassMetadata);
        return (C)clone;
    }

    private <C> C constructClone(Class<C> clazz) {
        try {
            return (C)this.constructorMemoization.computeIfAbsent(clazz, key -> {
                try {
                    Constructor constructor = key.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return constructor;
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("The class (" + key + ") should have a no-arg constructor to create a planning clone.", e);
                }
            }).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a planning clone.", e);
        }
    }

    private <C> void copyFields(Class<C> clazz, C original, C clone, Queue<Unprocessed> unprocessedQueue, ClassMetadata declaringClassMetadata) {
        for (ShallowCloningFieldCloner shallowCloningFieldCloner : declaringClassMetadata.getCopiedFieldArray()) {
            shallowCloningFieldCloner.clone(original, clone);
        }
        for (DeepCloningFieldCloner deepCloningFieldCloner : declaringClassMetadata.getClonedFieldArray()) {
            Object unprocessedValue = deepCloningFieldCloner.clone(this.solutionDescriptor, original, clone);
            if (unprocessedValue == null) continue;
            unprocessedQueue.add(new Unprocessed(clone, deepCloningFieldCloner.getField(), unprocessedValue));
        }
        Class<C> superclass = clazz.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            this.copyFields(superclass, original, clone, unprocessedQueue, this.retrieveClassMetadata(superclass));
        }
    }

    private Object cloneArray(Class<?> expectedType, Object originalArray, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue) {
        int arrayLength = Array.getLength(originalArray);
        Object cloneArray = Array.newInstance(originalArray.getClass().getComponentType(), arrayLength);
        if (!expectedType.isInstance(cloneArray)) {
            throw new IllegalStateException("The cloneArrayClass (" + cloneArray.getClass() + ") created for originalArrayClass (" + originalArray.getClass() + ") is not assignable to the field's type (" + expectedType + ").\nMaybe consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
        }
        for (int i = 0; i < arrayLength; ++i) {
            Object cloneElement = this.cloneCollectionsElementIfNeeded(Array.get(originalArray, i), originalToCloneMap, unprocessedQueue);
            Array.set(cloneArray, i, cloneElement);
        }
        return cloneArray;
    }

    private <E> Collection<E> cloneCollection(Class<?> expectedType, Collection<E> originalCollection, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue) {
        Collection<E> cloneCollection = FieldAccessingSolutionCloner.constructCloneCollection(originalCollection);
        if (!expectedType.isInstance(cloneCollection)) {
            throw new IllegalStateException("The cloneCollectionClass (" + cloneCollection.getClass() + ") created for originalCollectionClass (" + originalCollection.getClass() + ") is not assignable to the field's type (" + expectedType + ").\nMaybe consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
        }
        for (E originalElement : originalCollection) {
            E cloneElement = this.cloneCollectionsElementIfNeeded(originalElement, originalToCloneMap, unprocessedQueue);
            cloneCollection.add(cloneElement);
        }
        return cloneCollection;
    }

    private static <E> Collection<E> constructCloneCollection(Collection<E> originalCollection) {
        if (originalCollection instanceof List) {
            if (originalCollection instanceof ArrayList) {
                return new ArrayList(originalCollection.size());
            }
            if (originalCollection instanceof LinkedList) {
                return new LinkedList();
            }
            return new ArrayList(originalCollection.size());
        }
        if (originalCollection instanceof Set) {
            if (originalCollection instanceof SortedSet) {
                Comparator setComparator = ((SortedSet)originalCollection).comparator();
                return new TreeSet(setComparator);
            }
            if (originalCollection instanceof LinkedHashSet) {
                return new LinkedHashSet(originalCollection.size());
            }
            if (originalCollection instanceof HashSet) {
                return new HashSet(originalCollection.size());
            }
            return new LinkedHashSet(originalCollection.size());
        }
        if (originalCollection instanceof Deque) {
            return new ArrayDeque(originalCollection.size());
        }
        return new ArrayList(originalCollection.size());
    }

    private <K, V> Map<K, V> cloneMap(Class<?> expectedType, Map<K, V> originalMap, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue) {
        Map<K, V> cloneMap = FieldAccessingSolutionCloner.constructCloneMap(originalMap);
        if (!expectedType.isInstance(cloneMap)) {
            throw new IllegalStateException("The cloneMapClass (" + cloneMap.getClass() + ") created for originalMapClass (" + originalMap.getClass() + ") is not assignable to the field's type (" + expectedType + ").\nMaybe consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
        }
        for (Map.Entry<K, V> originalEntry : originalMap.entrySet()) {
            K cloneKey = this.cloneCollectionsElementIfNeeded(originalEntry.getKey(), originalToCloneMap, unprocessedQueue);
            V cloneValue = this.cloneCollectionsElementIfNeeded(originalEntry.getValue(), originalToCloneMap, unprocessedQueue);
            cloneMap.put(cloneKey, cloneValue);
        }
        return cloneMap;
    }

    private static <K, V> Map<K, V> constructCloneMap(Map<K, V> originalMap) {
        if (originalMap instanceof SortedMap) {
            Comparator setComparator = ((SortedMap)originalMap).comparator();
            return new TreeMap(setComparator);
        }
        if (originalMap instanceof LinkedHashMap) {
            return new LinkedHashMap(originalMap.size());
        }
        if (originalMap instanceof HashMap) {
            return new HashMap(originalMap.size());
        }
        return new LinkedHashMap(originalMap.size());
    }

    private ClassMetadata retrieveClassMetadata(Class<?> declaringClass) {
        return this.classMetadataMemoization.computeIfAbsent(declaringClass, x$0 -> new ClassMetadata((Class<?>)x$0));
    }

    private <C> C cloneCollectionsElementIfNeeded(C original, Map<Object, Object> originalToCloneMap, Queue<Unprocessed> unprocessedQueue) {
        if (original == null) {
            return null;
        }
        if (original instanceof Collection) {
            return (C)this.cloneCollection(Collection.class, (Collection)original, originalToCloneMap, unprocessedQueue);
        }
        if (original instanceof Map) {
            return (C)this.cloneMap(Map.class, (Map)original, originalToCloneMap, unprocessedQueue);
        }
        if (original.getClass().isArray()) {
            return (C)this.cloneArray(original.getClass(), original, originalToCloneMap, unprocessedQueue);
        }
        ClassMetadata classMetadata = this.retrieveClassMetadata(original.getClass());
        if (classMetadata.isDeepCloned) {
            return this.clone(original, originalToCloneMap, unprocessedQueue, classMetadata);
        }
        return original;
    }

    private void validateCloneSolution(Solution_ originalSolution, Solution_ cloneSolution) {
        for (MemberAccessor memberAccessor : this.solutionDescriptor.getEntityMemberAccessorMap().values()) {
            FieldAccessingSolutionCloner.validateCloneProperty(originalSolution, cloneSolution, memberAccessor);
        }
        for (MemberAccessor memberAccessor : this.solutionDescriptor.getEntityCollectionMemberAccessorMap().values()) {
            FieldAccessingSolutionCloner.validateCloneProperty(originalSolution, cloneSolution, memberAccessor);
        }
    }

    private static <Solution_> void validateCloneProperty(Solution_ originalSolution, Solution_ cloneSolution, MemberAccessor memberAccessor) {
        Object cloneProperty;
        Object originalProperty = memberAccessor.executeGetter(originalSolution);
        if (originalProperty != null && originalProperty == (cloneProperty = memberAccessor.executeGetter(cloneSolution))) {
            throw new IllegalStateException("The solutionProperty (" + memberAccessor.getName() + ") was not cloned as expected. The " + FieldAccessingSolutionCloner.class.getSimpleName() + " failed to recognize that property's field, probably because its field name is different.");
        }
    }

    private final class ClassMetadata {
        private final Class<?> declaringClass;
        private final boolean isDeepCloned;
        private ShallowCloningFieldCloner[] copiedFieldArray;
        private DeepCloningFieldCloner[] clonedFieldArray;

        public ClassMetadata(Class<?> declaringClass) {
            this.declaringClass = declaringClass;
            this.isDeepCloned = DeepCloningUtils.isClassDeepCloned(FieldAccessingSolutionCloner.this.solutionDescriptor, declaringClass);
        }

        public ShallowCloningFieldCloner[] getCopiedFieldArray() {
            if (this.copiedFieldArray == null) {
                this.copiedFieldArray = (ShallowCloningFieldCloner[])Arrays.stream(this.declaringClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(field -> DeepCloningUtils.isImmutable(field.getType())).peek(f -> f.setAccessible(true)).map(ShallowCloningFieldCloner::of).toArray(ShallowCloningFieldCloner[]::new);
            }
            return this.copiedFieldArray;
        }

        public DeepCloningFieldCloner[] getClonedFieldArray() {
            if (this.clonedFieldArray == null) {
                this.clonedFieldArray = (DeepCloningFieldCloner[])Arrays.stream(this.declaringClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(field -> !DeepCloningUtils.isImmutable(field.getType())).peek(f -> f.setAccessible(true)).map(DeepCloningFieldCloner::new).toArray(DeepCloningFieldCloner[]::new);
            }
            return this.clonedFieldArray;
        }
    }

    private static final class Unprocessed {
        final Object bean;
        final Field field;
        final Object originalValue;

        public Unprocessed(Object bean, Field field, Object originalValue) {
            this.bean = bean;
            this.field = field;
            this.originalValue = originalValue;
        }
    }
}

