/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list.nearby;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableDemand;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbySelector;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.list.RandomSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.SubList;
import org.optaplanner.core.impl.heuristic.selector.list.SubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.mimic.MimicReplayingSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.nearby.SubListNearbySubListMatrixDemand;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public final class NearSubListNearbySubListSelector<Solution_>
extends AbstractNearbySelector<Solution_, RandomSubListSelector<Solution_>, MimicReplayingSubListSelector<Solution_>>
implements SubListSelector<Solution_> {
    private SingletonInverseVariableSupply inverseVariableSupply;
    private IndexVariableSupply indexVariableSupply;

    public NearSubListNearbySubListSelector(RandomSubListSelector<Solution_> childSubListSelector, SubListSelector<Solution_> originSubListSelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom) {
        super(childSubListSelector, originSubListSelector, nearbyDistanceMeter, nearbyRandom, true);
    }

    @Override
    protected MimicReplayingSubListSelector<Solution_> castReplayingSelector(Object uncastReplayingSelector) {
        if (!(uncastReplayingSelector instanceof MimicReplayingSubListSelector)) {
            throw new IllegalStateException("Impossible state: Nearby subList selector (" + this + ") did not receive a replaying subList selector (" + uncastReplayingSelector + ").");
        }
        return (MimicReplayingSubListSelector)uncastReplayingSelector;
    }

    @Override
    protected AbstractNearbyDistanceMatrixDemand<?, ?, ?, ?> createDemand() {
        return new SubListNearbySubListMatrixDemand(this.nearbyDistanceMeter, this.nearbyRandom, (RandomSubListSelector)this.childSelector, (MimicReplayingSubListSelector)this.replayingSelector, this::computeDestinationSize);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        ListVariableDescriptor listVariableDescriptor = ((RandomSubListSelector)this.childSelector).getVariableDescriptor();
        this.inverseVariableSupply = supplyManager.demand(new SingletonListInverseVariableDemand(listVariableDescriptor));
        this.indexVariableSupply = supplyManager.demand(new IndexVariableDemand(listVariableDescriptor));
    }

    private int computeDestinationSize(Object origin) {
        long valueCount = ((RandomSubListSelector)this.childSelector).getValueCount();
        if (valueCount > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childSubListSelector (" + this.childSelector + ") has a valueCount (" + valueCount + ") which is higher than Integer.MAX_VALUE.");
        }
        int destinationSize = (int)valueCount;
        int overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum();
        if (destinationSize > overallSizeMaximum) {
            destinationSize = overallSizeMaximum;
        }
        return destinationSize;
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.indexVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        return ((RandomSubListSelector)this.childSelector).isCountable();
    }

    @Override
    public long getSize() {
        return ((RandomSubListSelector)this.childSelector).getSize();
    }

    @Override
    public Iterator<SubList> iterator() {
        Iterator<SubList> replayingOriginSubListIterator = ((MimicReplayingSubListSelector)this.replayingSelector).iterator();
        return new RandomSubListNearbySubListIterator(replayingOriginSubListIterator, ((RandomSubListSelector)this.childSelector).getValueCount());
    }

    @Override
    public ListVariableDescriptor<Solution_> getVariableDescriptor() {
        return ((RandomSubListSelector)this.childSelector).getVariableDescriptor();
    }

    @Override
    public Iterator<Object> endingValueIterator() {
        throw new UnsupportedOperationException("Not used.");
    }

    @Override
    public long getValueCount() {
        throw new UnsupportedOperationException("Not used.");
    }

    private final class RandomSubListNearbySubListIterator
    extends SelectionIterator<SubList> {
        private final Iterator<SubList> replayingOriginSubListIterator;
        private final int nearbySize;

        public RandomSubListNearbySubListIterator(Iterator<SubList> replayingOriginSubListIterator, long childSize) {
            this.replayingOriginSubListIterator = replayingOriginSubListIterator;
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The destinationSelector (" + this + ") has a destinationSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            this.nearbySize = (int)childSize;
        }

        @Override
        public boolean hasNext() {
            return this.replayingOriginSubListIterator.hasNext() && this.nearbySize > 0 && ((RandomSubListSelector)NearSubListNearbySubListSelector.this.childSelector).getSize() > 0L;
        }

        @Override
        public SubList next() {
            SubList subList = this.replayingOriginSubListIterator.next();
            Object origin = this.firstElement(subList);
            Object nearbyElementEntity = null;
            Integer nearbyElementListIndex = -1;
            int availableListSize = -1;
            while (availableListSize < ((RandomSubListSelector)NearSubListNearbySubListSelector.this.childSelector).getMinimumSubListSize()) {
                int nearbyIndex = NearSubListNearbySubListSelector.this.nearbyRandom.nextInt(NearSubListNearbySubListSelector.this.workingRandom, this.nearbySize);
                Object nearbyElement = ((NearbyDistanceMatrix)NearSubListNearbySubListSelector.this.nearbyDistanceMatrixSupply.read()).getDestination(origin, nearbyIndex);
                nearbyElementEntity = NearSubListNearbySubListSelector.this.inverseVariableSupply.getInverseSingleton(nearbyElement);
                nearbyElementListIndex = NearSubListNearbySubListSelector.this.indexVariableSupply.getIndex(nearbyElement);
                availableListSize = this.listSize(nearbyElementEntity) - nearbyElementListIndex;
            }
            int maxSubListSize = Math.min(((RandomSubListSelector)NearSubListNearbySubListSelector.this.childSelector).getMaximumSubListSize(), availableListSize);
            int subListSizeRange = maxSubListSize - ((RandomSubListSelector)NearSubListNearbySubListSelector.this.childSelector).getMinimumSubListSize();
            int subListSize = (subListSizeRange == 0 ? 0 : NearSubListNearbySubListSelector.this.workingRandom.nextInt(subListSizeRange)) + ((RandomSubListSelector)NearSubListNearbySubListSelector.this.childSelector).getMinimumSubListSize();
            return new SubList(nearbyElementEntity, nearbyElementListIndex, subListSize);
        }

        private Object firstElement(SubList subList) {
            return ((MimicReplayingSubListSelector)NearSubListNearbySubListSelector.this.replayingSelector).getVariableDescriptor().getElement(subList.getEntity(), subList.getFromIndex());
        }

        private int listSize(Object entity) {
            return ((RandomSubListSelector)NearSubListNearbySubListSelector.this.childSelector).getVariableDescriptor().getListSize(entity);
        }
    }
}

