/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.optaplanner.core.api.domain.variable.PlanningListVariable;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.list.DestinationSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.list.ListChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.list.DestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.DestinationSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ListChangeMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelectorFactory;

public class ListChangeMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, ListChangeMoveSelectorConfig> {
    public ListChangeMoveSelectorFactory(ListChangeMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        ListChangeMoveSelectorFactory.checkUnfolded("valueSelectorConfig", ((ListChangeMoveSelectorConfig)this.config).getValueSelectorConfig());
        ListChangeMoveSelectorFactory.checkUnfolded("destinationSelectorConfig", ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig());
        ListChangeMoveSelectorFactory.checkUnfolded("destinationEntitySelectorConfig", ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getEntitySelectorConfig());
        ListChangeMoveSelectorFactory.checkUnfolded("destinationValueSelectorConfig", ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getValueSelectorConfig());
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntityDescriptor entityDescriptor = EntitySelectorFactory.create(((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getEntitySelectorConfig()).extractEntityDescriptor(configPolicy);
        ValueSelector sourceValueSelector = ValueSelectorFactory.create(((ListChangeMoveSelectorConfig)this.config).getValueSelectorConfig()).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, selectionOrder);
        if (!(sourceValueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("The listChangeMoveSelector (" + this.config + ") for a list variable needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + sourceValueSelector + "). Check your valueSelectorConfig.");
        }
        DestinationSelector destinationSelector = DestinationSelectorFactory.create(((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig()).buildDestinationSelector(configPolicy, minimumCacheType, randomSelection);
        return new ListChangeMoveSelector((EntityIndependentValueSelector)sourceValueSelector, destinationSelector, randomSelection);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        GenuineVariableDescriptor onlyDestinationVariableDescriptor;
        GenuineVariableDescriptor onlyVariableDescriptor;
        EntityDescriptor onlyEntityDescriptor = ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig() == null ? null : (((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getEntitySelectorConfig() == null ? null : EntitySelectorFactory.create(((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getEntitySelectorConfig()).extractEntityDescriptor(configPolicy));
        Collection<Object> entityDescriptors = onlyEntityDescriptor != null ? Collections.singletonList(onlyEntityDescriptor) : configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors();
        if (entityDescriptors.size() > 1) {
            throw new IllegalArgumentException("The listChangeMoveSelector (" + this.config + ") cannot unfold when there are multiple entities (" + entityDescriptors + "). Please use one listChangeMoveSelector per each planning list variable.");
        }
        EntityDescriptor entityDescriptor = (EntityDescriptor)entityDescriptors.iterator().next();
        ArrayList<ListVariableDescriptor> variableDescriptorList = new ArrayList<ListVariableDescriptor>();
        GenuineVariableDescriptor genuineVariableDescriptor = onlyVariableDescriptor = ((ListChangeMoveSelectorConfig)this.config).getValueSelectorConfig() == null ? null : ValueSelectorFactory.create(((ListChangeMoveSelectorConfig)this.config).getValueSelectorConfig()).extractVariableDescriptor(configPolicy, entityDescriptor);
        GenuineVariableDescriptor genuineVariableDescriptor2 = ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig() == null ? null : (onlyDestinationVariableDescriptor = ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getValueSelectorConfig() == null ? null : ValueSelectorFactory.create(((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getValueSelectorConfig()).extractVariableDescriptor(configPolicy, entityDescriptor));
        if (onlyVariableDescriptor != null && onlyDestinationVariableDescriptor != null) {
            if (!onlyVariableDescriptor.isListVariable()) {
                throw new IllegalArgumentException("The listChangeMoveSelector (" + this.config + ") is configured to use a planning variable (" + onlyVariableDescriptor + "), which is not a planning list variable. Either fix your annotations and use a @" + PlanningListVariable.class.getSimpleName() + " on the variable to make it work with listChangeMoveSelector or use a changeMoveSelector instead.");
            }
            if (!onlyDestinationVariableDescriptor.isListVariable()) {
                throw new IllegalArgumentException("The destinationSelector (" + ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig() + ") is configured to use a planning variable (" + onlyDestinationVariableDescriptor + "), which is not a planning list variable.");
            }
            if (onlyVariableDescriptor != onlyDestinationVariableDescriptor) {
                throw new IllegalArgumentException("The listChangeMoveSelector's valueSelector (" + ((ListChangeMoveSelectorConfig)this.config).getValueSelectorConfig() + ") and destinationSelector's valueSelector (" + ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig().getValueSelectorConfig() + ") must be configured for the same planning variable.");
            }
            if (onlyEntityDescriptor != null) {
                return null;
            }
            variableDescriptorList.add((ListVariableDescriptor)onlyVariableDescriptor);
        } else {
            variableDescriptorList.addAll(entityDescriptor.getGenuineVariableDescriptorList().stream().filter(GenuineVariableDescriptor::isListVariable).map(variableDescriptor -> (ListVariableDescriptor)variableDescriptor).collect(Collectors.toList()));
        }
        if (variableDescriptorList.isEmpty()) {
            throw new IllegalArgumentException("The listChangeMoveSelector (" + this.config + ") cannot unfold because there are no planning list variables.");
        }
        if (variableDescriptorList.size() > 1) {
            throw new IllegalArgumentException("The listChangeMoveSelector (" + this.config + ") cannot unfold because there are multiple planning list variables.");
        }
        ListChangeMoveSelectorConfig listChangeMoveSelectorConfig = ListChangeMoveSelectorFactory.buildChildMoveSelectorConfig((ListVariableDescriptor)variableDescriptorList.get(0), ((ListChangeMoveSelectorConfig)this.config).getValueSelectorConfig(), ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig());
        listChangeMoveSelectorConfig.inheritFolded((MoveSelectorConfig)this.config);
        return listChangeMoveSelectorConfig;
    }

    public static ListChangeMoveSelectorConfig buildChildMoveSelectorConfig(ListVariableDescriptor<?> variableDescriptor, ValueSelectorConfig inheritedValueSelectorConfig, DestinationSelectorConfig inheritedDestinationSelectorConfig) {
        ValueSelectorConfig childValueSelectorConfig = new ValueSelectorConfig(inheritedValueSelectorConfig);
        if (childValueSelectorConfig.getMimicSelectorRef() == null) {
            childValueSelectorConfig.setVariableName(variableDescriptor.getVariableName());
        }
        return new ListChangeMoveSelectorConfig().withValueSelectorConfig(childValueSelectorConfig).withDestinationSelectorConfig(new DestinationSelectorConfig(inheritedDestinationSelectorConfig).withEntitySelectorConfig(Optional.ofNullable(inheritedDestinationSelectorConfig).map(DestinationSelectorConfig::getEntitySelectorConfig).map(EntitySelectorConfig::new).orElseGet(EntitySelectorConfig::new).withEntityClass(variableDescriptor.getEntityDescriptor().getEntityClass())).withValueSelectorConfig(Optional.ofNullable(inheritedDestinationSelectorConfig).map(DestinationSelectorConfig::getValueSelectorConfig).map(ValueSelectorConfig::new).orElseGet(ValueSelectorConfig::new).withVariableName(variableDescriptor.getVariableName())));
    }
}

