/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.Iterator;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableDemand;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptListMoveIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptUtils;
import org.optaplanner.core.impl.solver.scope.SolverScope;

final class KOptListMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final EntitySelector<Solution_> entitySelector;
    private final int minK;
    private final int maxK;
    private SingletonInverseVariableSupply inverseVariableSupply;
    private IndexVariableSupply indexVariableSupply;

    public KOptListMoveSelector(ListVariableDescriptor<Solution_> listVariableDescriptor, EntitySelector<Solution_> entitySelector, int minK, int maxK) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.entitySelector = entitySelector;
        this.minK = minK;
        this.maxK = maxK;
        this.phaseLifecycleSupport.addEventListener(entitySelector);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.inverseVariableSupply = supplyManager.demand(new SingletonListInverseVariableDemand<Solution_>(this.listVariableDescriptor));
        this.indexVariableSupply = supplyManager.demand(new IndexVariableDemand<Solution_>(this.listVariableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.indexVariableSupply = null;
    }

    @Override
    public long getSize() {
        Iterator<Object> entityIterator = this.entitySelector.endingIterator();
        long total = 0L;
        while (entityIterator.hasNext()) {
            Object entity = entityIterator.next();
            int valueSelectorSize = this.listVariableDescriptor.getListSize(entity);
            for (int i = this.minK; i < Math.min(valueSelectorSize, this.maxK); ++i) {
                if (valueSelectorSize <= i) continue;
                long kOptMoveTypes = KOptUtils.getPureKOptMoveTypes(i);
                long edgeChoices = CombinatoricsUtils.binomialCoefficient((int)(valueSelectorSize - 1), (int)i);
                total += kOptMoveTypes * edgeChoices;
            }
        }
        return total;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new KOptListMoveIterator(this.workingRandom, this.listVariableDescriptor, this.inverseVariableSupply, this.indexVariableSupply, this.entitySelector, this.minK, this.maxK);
    }

    @Override
    public boolean isCountable() {
        return false;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }
}

