/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public final class MovableChainedTrailingValueFilter<Solution_>
implements SelectionFilter<Solution_, Object> {
    private final GenuineVariableDescriptor<Solution_> variableDescriptor;

    public MovableChainedTrailingValueFilter(GenuineVariableDescriptor<Solution_> variableDescriptor) {
        this.variableDescriptor = variableDescriptor;
    }

    @Override
    public boolean accept(ScoreDirector<Solution_> scoreDirector, Object value) {
        if (value == null) {
            return true;
        }
        SingletonInverseVariableSupply supply = this.retrieveSingletonInverseVariableSupply(scoreDirector);
        Object trailingEntity = supply.getInverseSingleton(value);
        EntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        if (trailingEntity == null || !entityDescriptor.matchesEntity(trailingEntity)) {
            return true;
        }
        return entityDescriptor.getEffectiveMovableEntitySelectionFilter().accept(scoreDirector, trailingEntity);
    }

    private SingletonInverseVariableSupply retrieveSingletonInverseVariableSupply(ScoreDirector<Solution_> scoreDirector) {
        SupplyManager supplyManager = ((InnerScoreDirector)scoreDirector).getSupplyManager();
        return supplyManager.demand(new SingletonInverseVariableDemand<Solution_>(this.variableDescriptor));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MovableChainedTrailingValueFilter that = (MovableChainedTrailingValueFilter)other;
        return Objects.equals(this.variableDescriptor, that.variableDescriptor);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor);
    }
}

