/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.constructionheuristic.placer;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.config.constructionheuristic.placer.EntityPlacerConfig;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.constructionheuristic.placer.QueuedEntityPlacer;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;

@XStreamAlias(value="queuedEntityPlacer")
public class QueuedEntityPlacerConfig
extends EntityPlacerConfig<QueuedEntityPlacerConfig> {
    @XStreamAlias(value="entitySelector")
    protected EntitySelectorConfig entitySelectorConfig = null;
    @XStreamImplicit
    protected List<MoveSelectorConfig> moveSelectorConfigList = null;

    public static QueuedEntityPlacerConfig unfoldNew(HeuristicConfigPolicy configPolicy, List<MoveSelectorConfig> templateMoveSelectorConfigList) {
        QueuedEntityPlacerConfig config = new QueuedEntityPlacerConfig();
        config.entitySelectorConfig = config.buildEntitySelectorConfig(configPolicy);
        config.moveSelectorConfigList = new ArrayList<MoveSelectorConfig>(templateMoveSelectorConfigList.size());
        ArrayList<MoveSelectorConfig> leafMoveSelectorConfigList = new ArrayList<MoveSelectorConfig>(templateMoveSelectorConfigList.size());
        for (MoveSelectorConfig moveSelectorConfig : templateMoveSelectorConfigList) {
            MoveSelectorConfig moveSelectorConfig2 = (MoveSelectorConfig)moveSelectorConfig.copyConfig();
            moveSelectorConfig2.extractLeafMoveSelectorConfigsIntoList(leafMoveSelectorConfigList);
            config.moveSelectorConfigList.add(moveSelectorConfig2);
        }
        for (MoveSelectorConfig<Object> moveSelectorConfig : leafMoveSelectorConfigList) {
            if (!(moveSelectorConfig instanceof ChangeMoveSelectorConfig)) {
                throw new IllegalStateException("The <constructionHeuristic> contains a moveSelector (" + moveSelectorConfig + ") that isn't a <changeMoveSelector>, a <unionMoveSelector> or a <cartesianProductMoveSelector>.\nMaybe you're using a moveSelector in <constructionHeuristic> that's only supported for <localSearch>.");
            }
            ChangeMoveSelectorConfig changeMoveSelectorConfig = (ChangeMoveSelectorConfig)moveSelectorConfig;
            if (changeMoveSelectorConfig.getEntitySelectorConfig() != null) {
                throw new IllegalStateException("The <constructionHeuristic> contains a changeMoveSelector (" + changeMoveSelectorConfig + ") that contains an entitySelector (" + changeMoveSelectorConfig.getEntitySelectorConfig() + ") without explicitly configuring the <queuedEntityPlacer>.");
            }
            changeMoveSelectorConfig.setEntitySelectorConfig(EntitySelectorConfig.newMimicSelectorConfig(config.entitySelectorConfig.getId()));
        }
        return config;
    }

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public List<MoveSelectorConfig> getMoveSelectorConfigList() {
        return this.moveSelectorConfigList;
    }

    public void setMoveSelectorConfigList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    @Override
    public QueuedEntityPlacer buildEntityPlacer(HeuristicConfigPolicy configPolicy) {
        List<MoveSelectorConfig> moveSelectorConfigList_;
        EntitySelectorConfig entitySelectorConfig_ = this.buildEntitySelectorConfig(configPolicy);
        EntitySelector entitySelector = entitySelectorConfig_.buildEntitySelector(configPolicy, SelectionCacheType.PHASE, SelectionOrder.ORIGINAL);
        if (ConfigUtils.isEmptyCollection(this.moveSelectorConfigList)) {
            EntityDescriptor entityDescriptor = entitySelector.getEntityDescriptor();
            Collection variableDescriptors = entityDescriptor.getGenuineVariableDescriptors();
            ArrayList<MoveSelectorConfig> subMoveSelectorConfigList = new ArrayList<MoveSelectorConfig>(variableDescriptors.size());
            for (GenuineVariableDescriptor variableDescriptor : variableDescriptors) {
                subMoveSelectorConfigList.add(this.buildChangeMoveSelectorConfig(configPolicy, entitySelectorConfig_.getId(), variableDescriptor));
            }
            MoveSelectorConfig subMoveSelectorConfig = subMoveSelectorConfigList.size() > 1 ? new CartesianProductMoveSelectorConfig(subMoveSelectorConfigList) : (MoveSelectorConfig)subMoveSelectorConfigList.get(0);
            moveSelectorConfigList_ = Collections.singletonList(subMoveSelectorConfig);
        } else {
            moveSelectorConfigList_ = this.moveSelectorConfigList;
        }
        ArrayList<MoveSelector> moveSelectorList = new ArrayList<MoveSelector>(moveSelectorConfigList_.size());
        for (MoveSelectorConfig moveSelectorConfig : moveSelectorConfigList_) {
            moveSelectorList.add(moveSelectorConfig.buildMoveSelector(configPolicy, SelectionCacheType.JUST_IN_TIME, SelectionOrder.ORIGINAL));
        }
        return new QueuedEntityPlacer(entitySelector, moveSelectorList);
    }

    private EntitySelectorConfig buildEntitySelectorConfig(HeuristicConfigPolicy configPolicy) {
        EntitySelectorConfig entitySelectorConfig_;
        if (this.entitySelectorConfig == null) {
            entitySelectorConfig_ = new EntitySelectorConfig();
            EntityDescriptor entityDescriptor = this.deduceEntityDescriptor(configPolicy.getSolutionDescriptor(), null);
            Class<?> entityClass = entityDescriptor.getEntityClass();
            entitySelectorConfig_.setId(entityClass.getName());
            entitySelectorConfig_.setEntityClass(entityClass);
            if (EntitySelectorConfig.hasSorter(configPolicy.getEntitySorterManner(), entityDescriptor)) {
                entitySelectorConfig_.setCacheType(SelectionCacheType.PHASE);
                entitySelectorConfig_.setSelectionOrder(SelectionOrder.SORTED);
                entitySelectorConfig_.setSorterManner(configPolicy.getEntitySorterManner());
            }
        } else {
            entitySelectorConfig_ = this.entitySelectorConfig;
        }
        if (entitySelectorConfig_.getCacheType() != null && entitySelectorConfig_.getCacheType().compareTo(SelectionCacheType.PHASE) < 0) {
            throw new IllegalArgumentException("The queuedEntityPlacer (" + this + ") cannot have an entitySelectorConfig (" + entitySelectorConfig_ + ") with a cacheType (" + (Object)((Object)entitySelectorConfig_.getCacheType()) + ") lower than " + (Object)((Object)SelectionCacheType.PHASE) + ".");
        }
        return entitySelectorConfig_;
    }

    private ChangeMoveSelectorConfig buildChangeMoveSelectorConfig(HeuristicConfigPolicy configPolicy, String entitySelectorConfigId, GenuineVariableDescriptor variableDescriptor) {
        ChangeMoveSelectorConfig changeMoveSelectorConfig = new ChangeMoveSelectorConfig();
        changeMoveSelectorConfig.setEntitySelectorConfig(EntitySelectorConfig.newMimicSelectorConfig(entitySelectorConfigId));
        ValueSelectorConfig changeValueSelectorConfig = new ValueSelectorConfig();
        changeValueSelectorConfig.setVariableName(variableDescriptor.getVariableName());
        if (ValueSelectorConfig.hasSorter(configPolicy.getValueSorterManner(), variableDescriptor)) {
            if (variableDescriptor.isValueRangeEntityIndependent()) {
                changeValueSelectorConfig.setCacheType(SelectionCacheType.PHASE);
            } else {
                changeValueSelectorConfig.setCacheType(SelectionCacheType.STEP);
            }
            changeValueSelectorConfig.setSelectionOrder(SelectionOrder.SORTED);
            changeValueSelectorConfig.setSorterManner(configPolicy.getValueSorterManner());
        }
        changeMoveSelectorConfig.setValueSelectorConfig(changeValueSelectorConfig);
        return changeMoveSelectorConfig;
    }

    @Override
    public QueuedEntityPlacerConfig inherit(QueuedEntityPlacerConfig inheritedConfig) {
        this.entitySelectorConfig = ConfigUtils.inheritConfig(this.entitySelectorConfig, inheritedConfig.getEntitySelectorConfig());
        this.moveSelectorConfigList = ConfigUtils.inheritMergeableListConfig(this.moveSelectorConfigList, inheritedConfig.getMoveSelectorConfigList());
        return this;
    }

    @Override
    public QueuedEntityPlacerConfig copyConfig() {
        return new QueuedEntityPlacerConfig().inherit(this);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ", " + this.moveSelectorConfigList + ")";
    }
}

