/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.core.api.domain.solution.cloner.DeepPlanningClone;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.impl.domain.common.ConcurrentMemoization;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

public class FieldAccessingSolutionCloner<Solution_>
implements SolutionCloner<Solution_> {
    protected final SolutionDescriptor<Solution_> solutionDescriptor;
    protected final ConcurrentMap<Class<?>, Constructor<?>> constructorMemoization = new ConcurrentMemoization();
    protected final ConcurrentMap<Class<?>, List<Field>> fieldListMemoization = new ConcurrentMemoization();
    protected final ConcurrentMap<Pair<Field, Class<?>>, Boolean> fieldDeepClonedMemoization = new ConcurrentMemoization();
    protected final ConcurrentMap<Class<?>, Boolean> actualValueClassDeepClonedMemoization = new ConcurrentMemoization();

    public FieldAccessingSolutionCloner(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    @Override
    public Solution_ cloneSolution(Solution_ originalSolution) {
        return new FieldAccessingSolutionClonerRun().cloneSolution(originalSolution);
    }

    protected <C> Constructor<C> retrieveCachedConstructor(Class<C> clazz) {
        return this.constructorMemoization.computeIfAbsent(clazz, key -> {
            Constructor constructor;
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a planning clone.", e);
            }
            constructor.setAccessible(true);
            return constructor;
        });
    }

    protected <C> List<Field> retrieveCachedFields(Class<C> clazz) {
        return this.fieldListMemoization.computeIfAbsent(clazz, key -> {
            Field[] fields = clazz.getDeclaredFields();
            ArrayList<Field> fieldList = new ArrayList<Field>(fields.length);
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                fieldList.add(field);
            }
            return fieldList;
        });
    }

    protected boolean retrieveDeepCloneDecision(Field field, Class<?> fieldInstanceClass, Class<?> actualValueClass) {
        Pair pair = Pair.of((Object)field, fieldInstanceClass);
        Boolean deepCloneDecision = this.fieldDeepClonedMemoization.computeIfAbsent(pair, key -> this.isFieldDeepCloned(field, fieldInstanceClass));
        return deepCloneDecision != false || this.retrieveDeepCloneDecisionForActualValueClass(actualValueClass);
    }

    private boolean isFieldDeepCloned(Field field, Class<?> fieldInstanceClass) {
        if (field.getType().isEnum()) {
            return false;
        }
        return this.isFieldAnEntityPropertyOnSolution(field, fieldInstanceClass) || this.isFieldAnEntityOrSolution(field, fieldInstanceClass) || this.isFieldADeepCloneProperty(field, fieldInstanceClass);
    }

    protected boolean isFieldAnEntityPropertyOnSolution(Field field, Class<?> fieldInstanceClass) {
        if (this.solutionDescriptor.getSolutionClass().isAssignableFrom(fieldInstanceClass)) {
            String fieldName = field.getName();
            if (this.solutionDescriptor.getEntityMemberAccessorMap().get(fieldName) != null) {
                return true;
            }
            if (this.solutionDescriptor.getEntityCollectionMemberAccessorMap().get(fieldName) != null) {
                return true;
            }
        }
        return false;
    }

    protected boolean isFieldAnEntityOrSolution(Field field, Class<?> fieldInstanceClass) {
        Class<?> type = field.getType();
        if (this.isClassDeepCloned(type)) {
            return true;
        }
        return Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) ? this.isTypeArgumentDeepCloned(field.getGenericType()) : type.isArray() && this.isClassDeepCloned(type.getComponentType());
    }

    private boolean isTypeArgumentDeepCloned(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                if (actualTypeArgument instanceof Class && this.isClassDeepCloned((Class)actualTypeArgument)) {
                    return true;
                }
                if (!this.isTypeArgumentDeepCloned(actualTypeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFieldADeepCloneProperty(Field field, Class<?> fieldInstanceClass) {
        if (field.isAnnotationPresent(DeepPlanningClone.class)) {
            return true;
        }
        Method getterMethod = ReflectionHelper.getGetterMethod(fieldInstanceClass, field.getName());
        return getterMethod != null && getterMethod.isAnnotationPresent(DeepPlanningClone.class);
    }

    protected boolean retrieveDeepCloneDecisionForActualValueClass(Class<?> actualValueClass) {
        return this.actualValueClassDeepClonedMemoization.computeIfAbsent(actualValueClass, key -> this.isClassDeepCloned(actualValueClass));
    }

    protected boolean isClassDeepCloned(Class<?> type) {
        return this.solutionDescriptor.hasEntityDescriptor(type) || this.solutionDescriptor.getSolutionClass().isAssignableFrom(type) || type.isAnnotationPresent(DeepPlanningClone.class);
    }

    protected static class Unprocessed {
        protected Object bean;
        protected Field field;
        protected Object originalValue;

        public Unprocessed(Object bean, Field field, Object originalValue) {
            this.bean = bean;
            this.field = field;
            this.originalValue = originalValue;
        }
    }

    protected class FieldAccessingSolutionClonerRun {
        protected Map<Object, Object> originalToCloneMap;
        protected Queue<Unprocessed> unprocessedQueue;

        protected FieldAccessingSolutionClonerRun() {
        }

        protected Solution_ cloneSolution(Solution_ originalSolution) {
            int entityCount = FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityCount(originalSolution);
            this.unprocessedQueue = new ArrayDeque<Unprocessed>(entityCount + 1);
            this.originalToCloneMap = new IdentityHashMap<Object, Object>(entityCount + 1);
            Object cloneSolution = this.clone(originalSolution);
            this.processQueue();
            this.validateCloneSolution(originalSolution, cloneSolution);
            return cloneSolution;
        }

        protected <C> C clone(C original) {
            if (original == null) {
                return null;
            }
            Object existingClone = this.originalToCloneMap.get(original);
            if (existingClone != null) {
                return (C)existingClone;
            }
            Class<?> instanceClass = original.getClass();
            Object clone = this.constructClone(instanceClass);
            this.originalToCloneMap.put(original, clone);
            this.copyFields(instanceClass, instanceClass, original, clone);
            return (C)clone;
        }

        protected <C> C constructClone(Class<C> clazz) {
            try {
                Constructor<C> constructor = FieldAccessingSolutionCloner.this.retrieveCachedConstructor(clazz);
                return constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a planning clone.", e);
            }
        }

        protected <C> void copyFields(Class<C> clazz, Class<? extends C> instanceClass, C original, C clone) {
            for (Field field : FieldAccessingSolutionCloner.this.retrieveCachedFields(clazz)) {
                Object originalValue;
                if (this.isDeepCloneField(field, instanceClass, originalValue = this.getFieldValue(original, field))) {
                    this.unprocessedQueue.add(new Unprocessed(clone, field, originalValue));
                    continue;
                }
                this.setFieldValue(clone, field, originalValue);
            }
            Class<C> superclass = clazz.getSuperclass();
            if (superclass != null) {
                this.copyFields(superclass, instanceClass, original, clone);
            }
        }

        protected boolean isDeepCloneField(Field field, Class<?> fieldInstanceClass, Object originalValue) {
            if (originalValue == null) {
                return false;
            }
            return FieldAccessingSolutionCloner.this.retrieveDeepCloneDecision(field, fieldInstanceClass, originalValue.getClass());
        }

        protected void processQueue() {
            while (!this.unprocessedQueue.isEmpty()) {
                Unprocessed unprocessed = this.unprocessedQueue.remove();
                this.process(unprocessed);
            }
        }

        protected void process(Unprocessed unprocessed) {
            Object cloneValue = unprocessed.originalValue instanceof Collection ? this.cloneCollection(unprocessed.field.getType(), (Collection)unprocessed.originalValue) : (unprocessed.originalValue instanceof Map ? this.cloneMap(unprocessed.field.getType(), (Map)unprocessed.originalValue) : (unprocessed.originalValue.getClass().isArray() ? this.cloneArray(unprocessed.field.getType(), unprocessed.originalValue) : this.clone(unprocessed.originalValue)));
            this.setFieldValue(unprocessed.bean, unprocessed.field, cloneValue);
        }

        protected Object cloneArray(Class<?> expectedType, Object originalArray) {
            int arrayLength = Array.getLength(originalArray);
            Object cloneArray = Array.newInstance(originalArray.getClass().getComponentType(), arrayLength);
            if (!expectedType.isInstance(cloneArray)) {
                throw new IllegalStateException("The cloneArrayClass (" + cloneArray.getClass() + ") created for originalArrayClass (" + originalArray.getClass() + ") is not assignable to the field's type (" + expectedType + ").\nMaybe consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
            }
            for (int i = 0; i < arrayLength; ++i) {
                Object cloneElement = this.cloneCollectionsElementIfNeeded(Array.get(originalArray, i));
                Array.set(cloneArray, i, cloneElement);
            }
            return cloneArray;
        }

        protected <E> Collection<E> cloneCollection(Class<?> expectedType, Collection<E> originalCollection) {
            Collection<E> cloneCollection = this.constructCloneCollection(originalCollection);
            if (!expectedType.isInstance(cloneCollection)) {
                throw new IllegalStateException("The cloneCollectionClass (" + cloneCollection.getClass() + ") created for originalCollectionClass (" + originalCollection.getClass() + ") is not assignable to the field's type (" + expectedType + ").\nMaybe consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
            }
            for (E originalElement : originalCollection) {
                E cloneElement = this.cloneCollectionsElementIfNeeded(originalElement);
                cloneCollection.add(cloneElement);
            }
            return cloneCollection;
        }

        protected <E> Collection<E> constructCloneCollection(Collection<E> originalCollection) {
            if (originalCollection instanceof List) {
                if (originalCollection instanceof ArrayList) {
                    return new ArrayList(originalCollection.size());
                }
                if (originalCollection instanceof LinkedList) {
                    return new LinkedList();
                }
                return new ArrayList(originalCollection.size());
            }
            if (originalCollection instanceof Set) {
                if (originalCollection instanceof SortedSet) {
                    Comparator setComparator = ((SortedSet)originalCollection).comparator();
                    return new TreeSet(setComparator);
                }
                if (originalCollection instanceof LinkedHashSet) {
                    return new LinkedHashSet(originalCollection.size());
                }
                if (originalCollection instanceof HashSet) {
                    return new HashSet(originalCollection.size());
                }
                return new LinkedHashSet(originalCollection.size());
            }
            if (originalCollection instanceof Deque) {
                return new ArrayDeque(originalCollection.size());
            }
            return new ArrayList(originalCollection.size());
        }

        protected <K, V> Map<K, V> cloneMap(Class<?> expectedType, Map<K, V> originalMap) {
            Map<K, V> cloneMap = this.constructCloneMap(originalMap);
            if (!expectedType.isInstance(cloneMap)) {
                throw new IllegalStateException("The cloneMapClass (" + cloneMap.getClass() + ") created for originalMapClass (" + originalMap.getClass() + ") is not assignable to the field's type (" + expectedType + ").\nMaybe consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
            }
            for (Map.Entry<K, V> originalEntry : originalMap.entrySet()) {
                K cloneKey = this.cloneCollectionsElementIfNeeded(originalEntry.getKey());
                V cloneValue = this.cloneCollectionsElementIfNeeded(originalEntry.getValue());
                cloneMap.put(cloneKey, cloneValue);
            }
            return cloneMap;
        }

        protected <K, V> Map<K, V> constructCloneMap(Map<K, V> originalMap) {
            if (originalMap instanceof SortedMap) {
                Comparator setComparator = ((SortedMap)originalMap).comparator();
                return new TreeMap(setComparator);
            }
            if (originalMap instanceof LinkedHashMap) {
                return new LinkedHashMap(originalMap.size());
            }
            if (originalMap instanceof HashMap) {
                return new HashMap(originalMap.size());
            }
            return new LinkedHashMap(originalMap.size());
        }

        protected <C> C cloneCollectionsElementIfNeeded(C original) {
            if (original instanceof Collection) {
                return (C)this.cloneCollection(Collection.class, (Collection)original);
            }
            if (original instanceof Map) {
                return (C)this.cloneMap(Map.class, (Map)original);
            }
            if (original.getClass().isArray()) {
                return (C)this.cloneArray(original.getClass(), original);
            }
            if (FieldAccessingSolutionCloner.this.retrieveDeepCloneDecisionForActualValueClass(original.getClass())) {
                return this.clone(original);
            }
            return original;
        }

        protected void validateCloneSolution(Solution_ originalSolution, Solution_ cloneSolution) {
            Object cloneProperty;
            Object originalProperty;
            for (MemberAccessor memberAccessor : FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityMemberAccessorMap().values()) {
                originalProperty = memberAccessor.executeGetter(originalSolution);
                if (originalProperty == null || originalProperty != (cloneProperty = memberAccessor.executeGetter(cloneSolution))) continue;
                throw new IllegalStateException("The solutionProperty (" + memberAccessor.getName() + ") was not cloned as expected. The " + FieldAccessingSolutionCloner.class.getSimpleName() + " failed to recognize that property's field, probably because its field name is different.");
            }
            for (MemberAccessor memberAccessor : FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityCollectionMemberAccessorMap().values()) {
                originalProperty = memberAccessor.executeGetter(originalSolution);
                if (originalProperty == null || originalProperty != (cloneProperty = memberAccessor.executeGetter(cloneSolution))) continue;
                throw new IllegalStateException("The solutionProperty (" + memberAccessor.getName() + ") was not cloned as expected. The " + FieldAccessingSolutionCloner.class.getSimpleName() + " failed to recognize that property's field, probably because its field name is different.");
            }
        }

        protected Object getFieldValue(Object bean, Field field) {
            try {
                return field.get(bean);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The class (" + bean.getClass() + ") has a field (" + field + ") which cannot be read to create a planning clone.", e);
            }
        }

        protected void setFieldValue(Object bean, Field field, Object value) {
            try {
                field.set(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The class (" + bean.getClass() + ") has a field (" + field + ") which cannot be written with the value (" + value + ") to create a planning clone.", e);
            }
        }
    }
}

