/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.rules;

import java.io.Serializable;
import java.util.Arrays;
import org.drools.model.DSL;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Predicate4;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelJoiningNode;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.Mutator;
import org.optaplanner.core.impl.score.stream.quad.AbstractQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.FilteringQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.NoneQuadJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

final class TriExistenceMutator<A, B, C, D>
implements Mutator {
    private final boolean shouldExist;
    private final Class<D> otherFactType;
    private final AbstractQuadJoiner<A, B, C, D>[] joiners;

    public TriExistenceMutator(AbstractConstraintModelJoiningNode<D, AbstractQuadJoiner<A, B, C, D>> node, boolean shouldExist) {
        this.shouldExist = shouldExist;
        this.otherFactType = node.getOtherFactType();
        this.joiners = (AbstractQuadJoiner[])node.get().stream().toArray(AbstractQuadJoiner[]::new);
    }

    private AbstractRuleAssembler applyJoiners(AbstractRuleAssembler ruleAssembler, AbstractQuadJoiner<A, B, C, D> joiner, QuadPredicate<A, B, C, D> predicate) {
        if (joiner == null) {
            return this.applyFilters(ruleAssembler, predicate);
        }
        QuadPredicate<Object, Object, Object, Object> joinFilter = joiner::matches;
        QuadPredicate<Object, Object, Object, Object> result = predicate == null ? joinFilter : joinFilter.and(predicate);
        return this.applyFilters(ruleAssembler, result);
    }

    private AbstractRuleAssembler applyFilters(AbstractRuleAssembler ruleAssembler, QuadPredicate<A, B, C, D> predicate) {
        Variable<D> toExist = ruleAssembler.createVariable(this.otherFactType, "triToExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, ruleAssembler.getVariable(0), ruleAssembler.getVariable(1), ruleAssembler.getVariable(2), (Predicate4 & Serializable)(d, a, b, c) -> predicate.test(a, b, c, d));
        ExprViewItem existenceExpression = DSL.exists((ViewItemBuilder)possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!this.shouldExist) {
            existenceExpression = DSL.not((ViewItemBuilder)possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        ruleAssembler.addDependentExpressionToLastPattern((ViewItem)existenceExpression);
        return ruleAssembler;
    }

    @Override
    public AbstractRuleAssembler apply(AbstractRuleAssembler ruleAssembler) {
        int indexOfFirstFilter = -1;
        AbstractQuadJoiner<A, B, C, D> finalJoiner = null;
        QuadPredicate<A, B, C, D> finalFilter = null;
        for (int i = 0; i < this.joiners.length; ++i) {
            boolean hasAFilter;
            AbstractQuadJoiner<A, B, C, D> joiner = this.joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NoneQuadJoiner && this.joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(this.joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringQuadJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + this.joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractQuadJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(ruleAssembler, finalJoiner, finalFilter);
    }
}

