/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.wrapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2gis.utilities.SpatialResultSet;
import org.h2gis.utilities.SpatialResultSetMetaData;
import org.h2gis.utilities.wrapper.ResultSetWrapper;
import org.h2gis.utilities.wrapper.StatementWrapper;
import org.locationtech.jts.geom.Geometry;

public class SpatialResultSetImpl
extends ResultSetWrapper
implements SpatialResultSet {
    private int firstGeometryFieldIndex = -1;

    public SpatialResultSetImpl(ResultSet resultSet, StatementWrapper statement) {
        super(resultSet, statement);
    }

    private int getFirstGeometryFieldIndex() throws SQLException {
        if (this.firstGeometryFieldIndex == -1) {
            this.firstGeometryFieldIndex = this.getMetaData().unwrap(SpatialResultSetMetaData.class).getFirstGeometryFieldIndex();
        }
        return this.firstGeometryFieldIndex;
    }

    @Override
    public Geometry getGeometry(int columnIndex) throws SQLException {
        Object field = this.getObject(columnIndex);
        if (field == null) {
            return (Geometry)field;
        }
        if (field instanceof Geometry) {
            return (Geometry)field;
        }
        throw new SQLException("The column " + this.getMetaData().getColumnName(columnIndex) + " is not a Geometry");
    }

    @Override
    public Geometry getGeometry(String columnLabel) throws SQLException {
        Object field = this.getObject(columnLabel);
        if (field == null) {
            return (Geometry)field;
        }
        if (field instanceof Geometry) {
            return (Geometry)field;
        }
        throw new SQLException("The column " + columnLabel + " is not a Geometry");
    }

    @Override
    public Geometry getGeometry() throws SQLException {
        return this.getGeometry(this.getFirstGeometryFieldIndex());
    }

    @Override
    public void updateGeometry(int columnIndex, Geometry geometry) throws SQLException {
        this.updateObject(columnIndex, (Object)geometry);
    }

    @Override
    public void updateGeometry(String columnLabel, Geometry geometry) throws SQLException {
        this.updateObject(columnLabel, (Object)geometry);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            try {
                return iface.cast(this);
            }
            catch (ClassCastException ex) {
                throw new SQLException(ex);
            }
        }
        return super.unwrap(iface);
    }
}

