/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.dbtypes;

import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.utilities.dbtypes.Constants;
import org.h2gis.utilities.dbtypes.DBTypes;

public class DBUtils {
    public static DBTypes getDBType(String url) {
        return DBUtils.getDBType(URI.create(url));
    }

    public static DBTypes getDBType(URI uri) {
        String scheme = uri.getScheme();
        if (scheme.equals("jdbc")) {
            String ssp = uri.getSchemeSpecificPart();
            scheme = ssp.substring(0, ssp.indexOf(":"));
        }
        if (scheme.startsWith("jdbc:")) {
            scheme = scheme.substring(5);
        }
        return Constants.SCHEME_DBTYPE_MAP.get(scheme.toLowerCase());
    }

    public static DBTypes getDBType(Connection connection) throws SQLException {
        DBTypes type = Constants.driverDBTypeMap.get(connection.getClass().getName());
        if (type == null) {
            type = Constants.DB_NAME_TYPE_MAP.get(connection.getMetaData().getDriverName());
        }
        return type;
    }
}

