/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.tools.Csv;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.utility.FileUtil;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;

public class CSVDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "CSV file (Comma Separated Values)";
    private static final int BATCH_MAX_SIZE = 100;
    private static final int AVERAGE_NODE_SIZE = 500;

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"csv"};
    }

    public String[] getExportFormats() {
        return new String[]{"csv"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("csv")) {
            return DESCRIPTION;
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return false;
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        this.exportTable(connection, tableReference, fileName, progress, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String csvOptions) throws SQLException, IOException {
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableReference);
        if (matcher.find()) {
            if (!tableReference.startsWith("(") || !tableReference.endsWith(")")) throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
            try (Statement st = connection.createStatement();){
                JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
                Csv csv = new Csv();
                if (csvOptions != null && csvOptions.indexOf(61) >= 0) {
                    csv.setOptions(csvOptions);
                }
                csv.write(fileName.getPath(), st.executeQuery(tableReference), null);
                return;
            }
        }
        if (!FileUtil.isExtensionWellFormated(fileName, "csv")) throw new SQLException("Only .csv extension is supported");
        boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
        TableLocation location = TableLocation.parse((String)tableReference, (Boolean)isH2);
        try (Statement st = connection.createStatement();){
            JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
            Csv csv = new Csv();
            if (csvOptions != null && csvOptions.indexOf(61) >= 0) {
                csv.setOptions(csvOptions);
            }
            csv.write(fileName.getPath(), st.executeQuery("SELECT * FROM " + location.toString()), null);
            return;
        }
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        this.importFile(connection, tableReference, fileName, progress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String csvOptions) throws SQLException, IOException {
        if (FileUtil.isFileImportable(fileName, "csv")) {
            boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
            TableLocation requestedTable = TableLocation.parse((String)tableReference, (Boolean)isH2);
            String table = requestedTable.getTable();
            FileInputStream fis = new FileInputStream(fileName);
            FileChannel fc = fis.getChannel();
            long fileSize = fc.size();
            long readFileSizeEachNode = Math.max(1L, fileSize / 500L / 100L);
            int average_row_size = 0;
            Csv csv = new Csv();
            if (csvOptions != null && csvOptions.indexOf(61) >= 0) {
                csv.setOptions(csvOptions);
            }
            ResultSet reader = csv.read((Reader)new BufferedReader(new InputStreamReader(fis)), null);
            ResultSetMetaData metadata = reader.getMetaData();
            int columnCount = metadata.getColumnCount();
            StringBuilder createTable = new StringBuilder("CREATE TABLE ");
            createTable.append(table).append("(");
            StringBuilder insertTable = new StringBuilder("INSERT INTO ");
            insertTable.append(table).append(" VALUES(");
            for (int i = 0; i < columnCount; ++i) {
                if (i > 0) {
                    createTable.append(",");
                    insertTable.append(",");
                }
                createTable.append(metadata.getColumnName(i + 1)).append(" VARCHAR");
                insertTable.append("?");
            }
            createTable.append(")");
            insertTable.append(")");
            try (Statement stmt = connection.createStatement();){
                stmt.execute(createTable.toString());
            }
            long batchSize = 0L;
            try (PreparedStatement pst = connection.prepareStatement(insertTable.toString());){
                while (reader.next()) {
                    if (progress.isCanceled()) {
                        throw new SQLException("Canceled by user");
                    }
                    for (int i = 0; i < columnCount; ++i) {
                        pst.setString(i + 1, reader.getString(i + 1));
                    }
                    pst.addBatch();
                    if (++batchSize >= 100L) {
                        pst.executeBatch();
                        pst.clearBatch();
                        batchSize = 0L;
                    }
                    if ((long)average_row_size++ % readFileSizeEachNode != 0L) continue;
                    try {
                        progress.setStep((int)((double)fc.position() / (double)fileSize * 100.0));
                    }
                    catch (IOException iOException) {}
                }
                if (batchSize > 0L) {
                    pst.executeBatch();
                }
            }
        }
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, boolean deleteTables) throws SQLException, IOException {
        if (deleteTables) {
            boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
            TableLocation requestedTable = TableLocation.parse((String)tableReference, (Boolean)isH2);
            String table = requestedTable.getTable();
            Statement stmt = connection.createStatement();
            stmt.execute("DROP TABLE IF EXISTS " + table);
            stmt.close();
        }
        this.importFile(connection, tableReference, fileName, progress);
    }
}

