/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.geojson.GeoJsonField;
import org.h2gis.functions.io.utility.FileUtil;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJsonReaderDriver {
    private static final ArrayList<String> geomTypes;
    private final File fileName;
    private final Connection connection;
    private static GeometryFactory GF;
    private PreparedStatement preparedStatement = null;
    private JsonFactory jsFactory;
    private int featureCounter = 1;
    private ProgressVisitor progress = new EmptyProgressVisitor();
    private FileChannel fc;
    private long fileSize = 0L;
    private long readFileSizeEachNode = 1L;
    private long nodeCountProgress = 0L;
    private static final int AVERAGE_NODE_SIZE = 500;
    boolean hasGeometryField = false;
    private static final Logger log;
    private int parsedSRID = 0;
    private boolean isH2;
    private TableLocation tableLocation;
    private Map<String, String> cachedColumnNames;
    private Map<String, Integer> cachedColumnIndex;
    private static final int BATCH_MAX_SIZE = 100;
    private Set finalGeometryTypes;

    public GeoJsonReaderDriver(Connection connection, File fileName) {
        this.connection = connection;
        this.fileName = fileName;
    }

    public void read(ProgressVisitor progress, String tableReference) throws SQLException, IOException {
        if (FileUtil.isFileImportable(this.fileName, "geojson")) {
            this.isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)this.connection.getMetaData());
            this.tableLocation = TableLocation.parse((String)tableReference, (Boolean)this.isH2);
            if (this.fileName.length() > 0L) {
                this.parseGeoJson(progress);
            } else {
                JDBCUtilities.createEmptyTable((Connection)this.connection, (String)this.tableLocation.toString());
            }
        }
    }

    private void parseGeoJson(ProgressVisitor progress) throws SQLException, IOException {
        this.progress = progress.subProcess(100);
        this.init();
        if (!this.parseMetadata()) {
            throw new SQLException("Cannot create the table " + this.tableLocation + " to import the GeoJSON data");
        }
        GF = new GeometryFactory(new PrecisionModel(), this.parsedSRID);
        this.parseData();
        this.setGeometryTypeConstraints();
    }

    private boolean parseMetadata() throws SQLException, IOException {
        block39: {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.fileName);
                this.fc = fis.getChannel();
                this.fileSize = this.fc.size();
                this.readFileSizeEachNode = Math.max(1L, this.fileSize / 500L / 100L);
                this.nodeCountProgress = 0L;
                this.cachedColumnNames = new LinkedHashMap<String, String>();
                this.finalGeometryTypes = new HashSet();
                try (JsonParser jp = this.jsFactory.createParser((InputStream)fis);){
                    jp.nextToken();
                    jp.nextToken();
                    jp.nextToken();
                    String geomType = jp.getText();
                    if (geomType.equalsIgnoreCase(GeoJsonField.FEATURECOLLECTION)) {
                        this.parseFeaturesMetadata(jp);
                        break block39;
                    }
                    throw new SQLException("Malformed GeoJSON file. Expected 'FeatureCollection', found '" + geomType + "'");
                }
            }
            catch (FileNotFoundException ex) {
                throw new SQLException(ex);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    throw new IOException(ex);
                }
            }
        }
        if (this.hasGeometryField) {
            StringBuilder createTable = new StringBuilder();
            createTable.append("CREATE TABLE ");
            createTable.append(this.tableLocation);
            createTable.append(" (");
            if (this.isH2) {
                createTable.append("THE_GEOM GEOMETRY");
            } else {
                createTable.append("THE_GEOM GEOMETRY(geometry,").append(this.parsedSRID).append(")");
            }
            this.cachedColumnIndex = new HashMap<String, Integer>();
            StringBuilder insertTable = new StringBuilder("INSERT INTO ");
            insertTable.append(this.tableLocation).append(" VALUES(?");
            int i = 1;
            for (Map.Entry<String, String> columns : this.cachedColumnNames.entrySet()) {
                String columnName = columns.getKey();
                this.cachedColumnIndex.put(columnName, i++);
                createTable.append(",").append(columns.getKey()).append(" ").append(columns.getValue());
                insertTable.append(",").append("?");
            }
            createTable.append(")");
            insertTable.append(")");
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute(createTable.toString());
            }
            this.preparedStatement = this.connection.prepareStatement(insertTable.toString());
            return true;
        }
        throw new SQLException("The geojson file  does not contain any geometry.");
    }

    private void parseFeaturesMetadata(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        while (!jp.getText().equalsIgnoreCase(GeoJsonField.FEATURES) && !jp.getText().equalsIgnoreCase(GeoJsonField.CRS)) {
            jp.nextToken();
            if (jp.getCurrentToken().equals((Object)JsonToken.START_ARRAY) || jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                jp.skipChildren();
            }
            jp.nextToken();
        }
        if (jp.getText().equalsIgnoreCase(GeoJsonField.CRS)) {
            this.parsedSRID = this.readCRS(jp);
        }
        if (jp.getText().equalsIgnoreCase(GeoJsonField.FEATURES)) {
            jp.nextToken();
            JsonToken token = jp.nextToken();
            while (token != JsonToken.END_ARRAY) {
                jp.nextToken();
                jp.nextToken();
                String geomType = jp.getText();
                if (geomType.equalsIgnoreCase(GeoJsonField.FEATURE)) {
                    if (this.progress.isCanceled()) {
                        throw new SQLException("Canceled by user");
                    }
                    this.parseFeatureMetadata(jp);
                    token = jp.nextToken();
                    ++this.featureCounter;
                    if (this.nodeCountProgress++ % this.readFileSizeEachNode != 0L) continue;
                    try {
                        this.progress.setStep((int)((double)this.fc.position() / (double)this.fileSize * 100.0));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                throw new SQLException("Malformed GeoJSON file. Expected 'Feature', found '" + geomType + "'");
            }
        } else {
            throw new SQLException("Malformed GeoJSON file. Expected 'features', found '" + jp.getText() + "'");
        }
    }

    private void parseFeatureMetadata(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String field = jp.getText();
        while (!(field.equalsIgnoreCase(GeoJsonField.GEOMETRY) || field.equalsIgnoreCase(GeoJsonField.PROPERTIES) || jp.getCurrentToken().equals((Object)JsonToken.END_OBJECT))) {
            jp.nextToken();
            if (jp.getCurrentToken().equals((Object)JsonToken.START_ARRAY) || jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                jp.skipChildren();
            }
            jp.nextToken();
            field = jp.getText();
        }
        if (field.equalsIgnoreCase(GeoJsonField.GEOMETRY)) {
            this.parseParentGeometryMetadata(jp);
            this.hasGeometryField = true;
            jp.nextToken();
        } else if (field.equalsIgnoreCase(GeoJsonField.PROPERTIES)) {
            this.parsePropertiesMetadata(jp);
            jp.nextToken();
        }
        field = jp.getText();
        while (!(field.equalsIgnoreCase(GeoJsonField.GEOMETRY) || field.equalsIgnoreCase(GeoJsonField.PROPERTIES) || jp.getCurrentToken().equals((Object)JsonToken.END_OBJECT))) {
            jp.nextToken();
            if (jp.getCurrentToken().equals((Object)JsonToken.START_ARRAY) || jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                jp.skipChildren();
            }
            jp.nextToken();
            field = jp.getText();
        }
        if (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            String secondParam = jp.getText();
            if (secondParam.equalsIgnoreCase(GeoJsonField.GEOMETRY)) {
                this.parseParentGeometryMetadata(jp);
                this.hasGeometryField = true;
            } else if (secondParam.equalsIgnoreCase(GeoJsonField.PROPERTIES)) {
                this.parsePropertiesMetadata(jp);
            }
            while (jp.nextToken() != JsonToken.END_OBJECT) {
            }
        }
    }

    private void parseParentGeometryMetadata(JsonParser jp) throws IOException, SQLException {
        if (jp.nextToken() != JsonToken.VALUE_NULL) {
            jp.nextToken();
            jp.nextToken();
            String geometryType = jp.getText();
            this.parseGeometryMetadata(jp, geometryType);
        }
    }

    private void parseGeometryMetadata(JsonParser jp, String geometryType) throws IOException, SQLException {
        if (geometryType.equalsIgnoreCase(GeoJsonField.POINT)) {
            this.parsePointMetadata(jp);
            this.finalGeometryTypes.add(GeoJsonField.POINT);
        } else if (geometryType.equalsIgnoreCase(GeoJsonField.MULTIPOINT)) {
            this.parseMultiPointMetadata(jp);
            this.finalGeometryTypes.add(GeoJsonField.MULTIPOINT);
        } else if (geometryType.equalsIgnoreCase(GeoJsonField.LINESTRING)) {
            this.parseLinestringMetadata(jp);
            this.finalGeometryTypes.add(GeoJsonField.LINESTRING);
        } else if (geometryType.equalsIgnoreCase(GeoJsonField.MULTILINESTRING)) {
            this.parseMultiLinestringMetadata(jp);
            this.finalGeometryTypes.add(GeoJsonField.MULTILINESTRING);
        } else if (geometryType.equalsIgnoreCase(GeoJsonField.POLYGON)) {
            this.parsePolygonMetadata(jp);
            this.finalGeometryTypes.add(GeoJsonField.POLYGON);
        } else if (geometryType.equalsIgnoreCase(GeoJsonField.MULTIPOLYGON)) {
            this.parseMultiPolygonMetadata(jp);
            this.finalGeometryTypes.add(GeoJsonField.MULTIPOLYGON);
        } else if (geometryType.equalsIgnoreCase(GeoJsonField.GEOMETRYCOLLECTION)) {
            this.parseGeometryCollectionMetadata(jp);
            this.finalGeometryTypes.add(GeoJsonField.GEOMETRYCOLLECTION);
        } else {
            throw new SQLException("Unsupported geometry : " + geometryType);
        }
    }

    private void parsePointMetadata(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (!coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
        }
        jp.nextToken();
        this.parseCoordinateMetadata(jp);
    }

    private void parseMultiPointMetadata(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (!coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
        }
        jp.nextToken();
        this.parseCoordinatesMetadata(jp);
        jp.nextToken();
    }

    private void parseLinestringMetadata(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (!coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
        }
        jp.nextToken();
        this.parseCoordinatesMetadata(jp);
        jp.nextToken();
    }

    private void parseMultiLinestringMetadata(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                this.parseCoordinatesMetadata(jp);
                jp.nextToken();
            }
        } else {
            throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
        }
        jp.nextToken();
    }

    private void parsePolygonMetadata(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            jp.nextToken();
            int linesIndex = 0;
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                if (linesIndex == 0) {
                    this.parseCoordinatesMetadata(jp);
                } else {
                    this.parseCoordinatesMetadata(jp);
                }
                jp.nextToken();
                ++linesIndex;
            }
            if (linesIndex > 1) {
                jp.nextToken();
            } else {
                jp.nextToken();
            }
        } else {
            throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
        }
    }

    private void parseMultiPolygonMetadata(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                jp.nextToken();
                while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                    this.parseCoordinatesMetadata(jp);
                    jp.nextToken();
                }
                jp.nextToken();
            }
        } else {
            throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
        }
        jp.nextToken();
    }

    private void parseGeometryCollectionMetadata(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.GEOMETRIES)) {
            jp.nextToken();
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                jp.nextToken();
                jp.nextToken();
                String geometryType = jp.getText();
                this.parseGeometryMetadata(jp, geometryType);
                jp.nextToken();
            }
        } else {
            throw new SQLException("Malformed GeoJSON file. Expected 'geometries', found '" + coordinatesField + "'");
        }
        jp.nextToken();
    }

    private void parseCoordinateMetadata(JsonParser jp) throws IOException {
        jp.nextToken();
        jp.nextToken();
        jp.nextToken();
        if (jp.getCurrentToken() != JsonToken.END_ARRAY) {
            jp.nextToken();
        }
        jp.nextToken();
    }

    private void parseCoordinatesMetadata(JsonParser jp) throws IOException {
        jp.nextToken();
        while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
            this.parseCoordinateMetadata(jp);
        }
    }

    private void parsePropertiesMetadata(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = TableLocation.quoteIdentifier((String)jp.getText().toUpperCase(), (boolean)this.isH2);
            JsonToken value = jp.nextToken();
            if (null == value) continue;
            switch (value) {
                case VALUE_STRING: {
                    this.cachedColumnNames.put(fieldName, "VARCHAR");
                    break;
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    this.cachedColumnNames.put(fieldName, "BOOLEAN");
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    this.cachedColumnNames.put(fieldName, "DOUBLE PRECISION");
                    break;
                }
                case VALUE_NUMBER_INT: {
                    this.cachedColumnNames.put(fieldName, "BIGINT");
                    break;
                }
                case START_ARRAY: {
                    this.cachedColumnNames.put(fieldName, "ARRAY");
                    this.parseArrayMetadata(jp);
                    break;
                }
                case START_OBJECT: {
                    this.cachedColumnNames.put(fieldName, "VARCHAR");
                    this.parseObjectMetadata(jp);
                    break;
                }
                case VALUE_NULL: {
                    this.cachedColumnNames.put(fieldName, "VARCHAR");
                }
            }
        }
    }

    private void init() {
        this.jsFactory = new JsonFactory();
        this.jsFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.jsFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.jsFactory.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    private Object[] parseFeature(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String field = jp.getText();
        while (!(field.equalsIgnoreCase(GeoJsonField.GEOMETRY) || field.equalsIgnoreCase(GeoJsonField.PROPERTIES) || jp.getCurrentToken().equals((Object)JsonToken.END_OBJECT))) {
            jp.nextToken();
            if (jp.getCurrentToken().equals((Object)JsonToken.START_ARRAY) || jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                jp.skipChildren();
            }
            jp.nextToken();
            field = jp.getText();
        }
        Object[] values = new Object[this.cachedColumnIndex.size() + 1];
        if (field.equalsIgnoreCase(GeoJsonField.GEOMETRY)) {
            this.setGeometry(jp, values);
            jp.nextToken();
        } else if (field.equalsIgnoreCase(GeoJsonField.PROPERTIES)) {
            this.parseProperties(jp, values);
            jp.nextToken();
        }
        field = jp.getText();
        while (!(field.equalsIgnoreCase(GeoJsonField.GEOMETRY) || field.equalsIgnoreCase(GeoJsonField.PROPERTIES) || jp.getCurrentToken().equals((Object)JsonToken.END_OBJECT))) {
            jp.nextToken();
            if (jp.getCurrentToken().equals((Object)JsonToken.START_ARRAY) || jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                jp.skipChildren();
            }
            jp.nextToken();
            field = jp.getText();
        }
        if (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            String secondParam = jp.getText();
            if (secondParam.equalsIgnoreCase(GeoJsonField.GEOMETRY)) {
                this.setGeometry(jp, values);
            } else if (secondParam.equalsIgnoreCase(GeoJsonField.PROPERTIES)) {
                this.parseProperties(jp, values);
            }
            while (jp.nextToken() != JsonToken.END_OBJECT) {
            }
        }
        return values;
    }

    private void setGeometry(JsonParser jp, Object[] values) throws IOException, SQLException {
        if (jp.nextToken() != JsonToken.VALUE_NULL) {
            jp.nextToken();
            jp.nextToken();
            String geometryType = jp.getText();
            values[0] = this.parseGeometry(jp, geometryType);
        }
    }

    private Geometry parseGeometry(JsonParser jp, String geometryType) throws IOException, SQLException {
        if (geometryType.equalsIgnoreCase(GeoJsonField.POINT)) {
            return this.parsePoint(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.MULTIPOINT)) {
            return this.parseMultiPoint(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.LINESTRING)) {
            return this.parseLinestring(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.MULTILINESTRING)) {
            return this.parseMultiLinestring(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.POLYGON)) {
            return this.parsePolygon(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.MULTIPOLYGON)) {
            return this.parseMultiPolygon(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.GEOMETRYCOLLECTION)) {
            return this.parseGeometryCollection(jp);
        }
        throw new SQLException("Unsupported geometry : " + geometryType);
    }

    private void parseProperties(JsonParser jp, Object[] values) throws IOException, SQLException {
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = TableLocation.quoteIdentifier((String)jp.getText().toUpperCase(), (boolean)this.isH2);
            JsonToken value = jp.nextToken();
            if (value == JsonToken.VALUE_STRING) {
                values[this.cachedColumnIndex.get((Object)fieldName).intValue()] = jp.getText();
                continue;
            }
            if (value == JsonToken.VALUE_TRUE) {
                values[this.cachedColumnIndex.get((Object)fieldName).intValue()] = jp.getValueAsBoolean();
                continue;
            }
            if (value == JsonToken.VALUE_FALSE) {
                values[this.cachedColumnIndex.get((Object)fieldName).intValue()] = jp.getValueAsBoolean();
                continue;
            }
            if (value == JsonToken.VALUE_NUMBER_FLOAT) {
                values[this.cachedColumnIndex.get((Object)fieldName).intValue()] = jp.getValueAsDouble();
                continue;
            }
            if (value == JsonToken.VALUE_NUMBER_INT) {
                values[this.cachedColumnIndex.get((Object)fieldName).intValue()] = jp.getBigIntegerValue();
                continue;
            }
            if (value == JsonToken.START_ARRAY) {
                ArrayList<Object> arrayList = this.parseArray(jp);
                values[this.cachedColumnIndex.get((Object)fieldName).intValue()] = arrayList.toArray();
                continue;
            }
            if (value == JsonToken.START_OBJECT) {
                String str = this.parseObject(jp);
                values[this.cachedColumnIndex.get((Object)fieldName).intValue()] = str;
                continue;
            }
            if (value != JsonToken.VALUE_NULL) continue;
            values[this.cachedColumnIndex.get((Object)fieldName).intValue()] = "null";
        }
    }

    private void parseFeatures(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        while (!jp.getText().equalsIgnoreCase(GeoJsonField.FEATURES) && !jp.getText().equalsIgnoreCase(GeoJsonField.CRS)) {
            jp.nextToken();
            if (jp.getCurrentToken().equals((Object)JsonToken.START_ARRAY) || jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                jp.skipChildren();
            }
            jp.nextToken();
        }
        String firstParam = jp.getText();
        if (firstParam.equalsIgnoreCase(GeoJsonField.CRS)) {
            firstParam = this.skipCRS(jp);
        }
        if (firstParam.equalsIgnoreCase(GeoJsonField.FEATURES)) {
            jp.nextToken();
            JsonToken token = jp.nextToken();
            long batchSize = 0L;
            while (token != JsonToken.END_ARRAY) {
                jp.nextToken();
                jp.nextToken();
                String geomType = jp.getText();
                if (geomType.equalsIgnoreCase(GeoJsonField.FEATURE)) {
                    if (this.progress.isCanceled()) {
                        throw new SQLException("Canceled by user");
                    }
                    Object[] values = this.parseFeature(jp);
                    for (int i = 0; i < values.length; ++i) {
                        this.preparedStatement.setObject(i + 1, values[i]);
                    }
                    this.preparedStatement.addBatch();
                    if (++batchSize >= 100L) {
                        this.preparedStatement.executeBatch();
                        this.preparedStatement.clearBatch();
                        batchSize = 0L;
                    }
                    token = jp.nextToken();
                    ++this.featureCounter;
                    if (this.nodeCountProgress++ % this.readFileSizeEachNode == 0L) {
                        try {
                            this.progress.setStep((int)((double)this.fc.position() / (double)this.fileSize * 100.0));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (batchSize <= 0L) continue;
                    this.preparedStatement.executeBatch();
                    continue;
                }
                throw new SQLException("Malformed GeoJSON file. Expected 'Feature', found '" + geomType + "'");
            }
        } else {
            throw new SQLException("Malformed GeoJSON file. Expected 'features', found '" + firstParam + "'");
        }
        log.info(this.featureCounter + " geojson features have been imported.");
    }

    private Point parsePoint(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            return GF.createPoint(this.parseCoordinate(jp));
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private MultiPoint parseMultiPoint(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            MultiPoint mPoint = GF.createMultiPoint(this.parseCoordinates(jp));
            jp.nextToken();
            return mPoint;
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private LineString parseLinestring(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            LineString line = GF.createLineString(this.parseCoordinates(jp));
            jp.nextToken();
            return line;
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private MultiLineString parseMultiLinestring(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            ArrayList<LineString> lineStrings = new ArrayList<LineString>();
            jp.nextToken();
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                lineStrings.add(GF.createLineString(this.parseCoordinates(jp)));
                jp.nextToken();
            }
            MultiLineString line = GF.createMultiLineString(lineStrings.toArray(new LineString[0]));
            jp.nextToken();
            return line;
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private Polygon parsePolygon(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            jp.nextToken();
            int linesIndex = 0;
            LinearRing linearRing = null;
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                if (linesIndex == 0) {
                    linearRing = GF.createLinearRing(this.parseCoordinates(jp));
                } else {
                    holes.add(GF.createLinearRing(this.parseCoordinates(jp)));
                }
                jp.nextToken();
                ++linesIndex;
            }
            if (linesIndex > 1) {
                jp.nextToken();
                return GF.createPolygon(linearRing, holes.toArray(new LinearRing[0]));
            }
            jp.nextToken();
            return GF.createPolygon(linearRing, null);
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private MultiPolygon parseMultiPolygon(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            jp.nextToken();
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                jp.nextToken();
                int linesIndex = 0;
                LinearRing linearRing = null;
                ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
                while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                    if (linesIndex == 0) {
                        linearRing = GF.createLinearRing(this.parseCoordinates(jp));
                    } else {
                        holes.add(GF.createLinearRing(this.parseCoordinates(jp)));
                    }
                    jp.nextToken();
                    ++linesIndex;
                }
                if (linesIndex > 1) {
                    jp.nextToken();
                    polygons.add(GF.createPolygon(linearRing, holes.toArray(new LinearRing[0])));
                    continue;
                }
                jp.nextToken();
                polygons.add(GF.createPolygon(linearRing, null));
            }
            jp.nextToken();
            return GF.createMultiPolygon(polygons.toArray(new Polygon[0]));
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private GeometryCollection parseGeometryCollection(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.GEOMETRIES)) {
            jp.nextToken();
            jp.nextToken();
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                jp.nextToken();
                jp.nextToken();
                String geometryType = jp.getText();
                geometries.add(this.parseGeometry(jp, geometryType));
                jp.nextToken();
            }
            jp.nextToken();
            return GF.createGeometryCollection(geometries.toArray(new Geometry[0]));
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'geometries', found '" + coordinatesField + "'");
    }

    private Coordinate[] parseCoordinates(JsonParser jp) throws IOException {
        jp.nextToken();
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
            coords.add(this.parseCoordinate(jp));
        }
        return coords.toArray(new Coordinate[0]);
    }

    private Coordinate parseCoordinate(JsonParser jp) throws IOException {
        Coordinate coord;
        jp.nextToken();
        double x = jp.getDoubleValue();
        jp.nextToken();
        double y = jp.getDoubleValue();
        jp.nextToken();
        if (jp.getCurrentToken() == JsonToken.END_ARRAY) {
            coord = new Coordinate(x, y);
        } else {
            double z = jp.getDoubleValue();
            jp.nextToken();
            coord = new Coordinate(x, y, z);
        }
        jp.nextToken();
        return coord;
    }

    private void parseData() throws IOException, SQLException {
        block23: {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.fileName);
                try (JsonParser jp = this.jsFactory.createParser((InputStream)fis);){
                    jp.nextToken();
                    jp.nextToken();
                    jp.nextToken();
                    String geomType = jp.getText();
                    if (geomType.equalsIgnoreCase(GeoJsonField.FEATURECOLLECTION)) {
                        this.parseFeatures(jp);
                        break block23;
                    }
                    throw new SQLException("Malformed GeoJSON file. Expected 'FeatureCollection', found '" + geomType + "'");
                }
            }
            catch (FileNotFoundException ex) {
                throw new SQLException(ex);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
    }

    private int readCRS(JsonParser jp) throws IOException, SQLException {
        int srid = 0;
        jp.nextToken();
        jp.nextToken();
        jp.nextToken();
        String firstField = jp.getText();
        if (firstField.equalsIgnoreCase(GeoJsonField.NAME)) {
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            String crsURI = jp.getText();
            String[] split = crsURI.toLowerCase().split(GeoJsonField.CRS_URN_EPSG);
            if (split != null) {
                srid = Integer.valueOf(split[1]);
            } else {
                log.warn("The CRS URN " + crsURI + " is not supported.");
            }
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
        } else if (firstField.equalsIgnoreCase(GeoJsonField.LINK)) {
            log.warn("Linked CRS is not supported.");
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
        } else {
            throw new SQLException("Malformed GeoJSON CRS element.");
        }
        return srid;
    }

    private String skipCRS(JsonParser jp) throws IOException {
        jp.nextToken();
        jp.skipChildren();
        jp.nextToken();
        return jp.getText();
    }

    private void setGeometryTypeConstraints() throws SQLException {
        String finalGeometryType = GeoJsonField.GEOMETRY;
        if (this.finalGeometryTypes.size() == 1) {
            finalGeometryType = (String)this.finalGeometryTypes.iterator().next();
        }
        if (this.isH2) {
            finalGeometryType = GeoJsonField.GEOMETRY;
            this.connection.createStatement().execute(String.format("ALTER TABLE %s ALTER COLUMN the_geom %s", this.tableLocation.toString(), finalGeometryType));
        } else {
            this.connection.createStatement().execute(String.format("ALTER TABLE %s ALTER COLUMN the_geom SET DATA TYPE geometry(%s,%d)", this.tableLocation.toString(), finalGeometryType, this.parsedSRID));
        }
    }

    private void parseArrayMetadata(JsonParser jp) throws IOException {
        JsonToken value = jp.nextToken();
        while (value != JsonToken.END_ARRAY) {
            if (value == JsonToken.START_OBJECT) {
                this.parseObjectMetadata(jp);
            } else if (value == JsonToken.START_ARRAY) {
                this.parseArrayMetadata(jp);
            }
            value = jp.nextToken();
        }
    }

    private void parseObjectMetadata(JsonParser jp) throws IOException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            JsonToken value = jp.nextToken();
            if (value == JsonToken.START_OBJECT) {
                this.parseObjectMetadata(jp);
                continue;
            }
            if (value != JsonToken.START_ARRAY) continue;
            this.parseArrayMetadata(jp);
        }
    }

    private ArrayList<Object> parseArray(JsonParser jp) throws IOException {
        JsonToken value = jp.nextToken();
        ArrayList<Object> ret = new ArrayList<Object>();
        while (value != JsonToken.END_ARRAY) {
            if (value == JsonToken.START_OBJECT) {
                String object = this.parseObject(jp);
                ret.add(object);
            } else if (value == JsonToken.START_ARRAY) {
                ArrayList<Object> arrayList = this.parseArray(jp);
                ret.add(arrayList.toArray());
            } else if (value == JsonToken.VALUE_NUMBER_INT) {
                ret.add(jp.getValueAsInt());
            } else if (value == JsonToken.VALUE_FALSE || value == JsonToken.VALUE_TRUE) {
                ret.add(jp.getValueAsBoolean());
            } else if (value == JsonToken.VALUE_NUMBER_FLOAT) {
                ret.add(jp.getValueAsDouble());
            } else if (value == JsonToken.VALUE_STRING) {
                ret.add(jp.getValueAsString());
            } else if (value == JsonToken.VALUE_NULL) {
                ret.add("null");
            }
            value = jp.nextToken();
        }
        return ret;
    }

    private String parseObject(JsonParser jp) throws IOException {
        String ret = "{";
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            JsonToken value = jp.nextToken();
            if (value == JsonToken.START_OBJECT) {
                this.parseObjectMetadata(jp);
                continue;
            }
            if (value != JsonToken.START_ARRAY) continue;
            this.parseArrayMetadata(jp);
        }
        ret = ret + "}";
        return ret;
    }

    static {
        log = LoggerFactory.getLogger(GeoJsonReaderDriver.class);
        geomTypes = new ArrayList();
        geomTypes.add(GeoJsonField.POINT);
        geomTypes.add(GeoJsonField.MULTIPOINT);
        geomTypes.add(GeoJsonField.LINESTRING);
        geomTypes.add(GeoJsonField.MULTILINESTRING);
        geomTypes.add(GeoJsonField.POLYGON);
        geomTypes.add(GeoJsonField.MULTIPOLYGON);
    }
}

