/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.gpx.model;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.h2gis.functions.io.gpx.model.AbstractGpxParser;
import org.h2gis.functions.io.gpx.model.AbstractGpxParserDefault;
import org.h2gis.functions.io.gpx.model.GPXCoordinate;
import org.h2gis.functions.io.gpx.model.GPXLine;
import org.h2gis.functions.io.gpx.model.GPXPoint;
import org.h2gis.functions.io.gpx.model.GPXTags;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractGpxParserTrk
extends AbstractGpxParser {
    private boolean point;
    private boolean segment;
    private AbstractGpxParserDefault parent;
    private List<Coordinate> trksegList;
    private List<LineString> trkList;
    private int trksegID = 1;
    private int trkptID = 1;

    public void initialise(XMLReader reader, AbstractGpxParserDefault parent) {
        this.setReader(reader);
        this.setParent(parent);
        this.setContentBuffer(parent.getContentBuffer());
        this.setTrkPreparedStmt(parent.getTrkPreparedStmt());
        this.setTrkSegmentsPreparedStmt(parent.getTrkSegmentsPreparedStmt());
        this.setTrkPointsPreparedStmt(parent.getTrkPointsPreparedStmt());
        this.setElementNames(parent.getElementNames());
        this.setCurrentLine(parent.getCurrentLine());
        this.setTrksegList(new ArrayList<Coordinate>());
        this.setTrkList(new ArrayList<LineString>());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equalsIgnoreCase(GPXTags.TRKSEG)) {
            this.segment = true;
            GPXLine trkSegment = new GPXLine(4);
            trkSegment.setValue(1, this.trksegID++);
            trkSegment.setValue(3, this.getCurrentLine().getValues()[1]);
            this.setCurrentSegment(trkSegment);
            this.trksegList.clear();
        } else if (localName.equalsIgnoreCase(GPXTags.TRKPT)) {
            this.point = true;
            GPXPoint trackPoint = new GPXPoint(25);
            Coordinate coordinate = GPXCoordinate.createCoordinate(attributes);
            Point geom = this.getGeometryFactory().createPoint(coordinate);
            geom.setSRID(4326);
            trackPoint.setValue(0, geom);
            trackPoint.setValue(2, coordinate.y);
            trackPoint.setValue(3, coordinate.x);
            trackPoint.setValue(4, coordinate.z);
            trackPoint.setValue(1, this.trkptID++);
            trackPoint.setValue(24, this.trksegID);
            this.trksegList.add(coordinate);
            this.setCurrentPoint(trackPoint);
        }
        this.getContentBuffer().delete(0, this.getContentBuffer().length());
        this.getElementNames().push(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.setCurrentElement(this.getElementNames().pop());
        if (this.getCurrentElement().equalsIgnoreCase(GPXTags.TRK)) {
            MultiLineString geometry = this.getGeometryFactory().createMultiLineString(this.trkList.toArray(new LineString[0]));
            geometry.setSRID(4326);
            this.getCurrentLine().setGeometry((Geometry)geometry);
            try {
                Object[] values;
                PreparedStatement pStm = this.getTrkPreparedStmt();
                int i = 1;
                for (Object object : values = this.getCurrentLine().getValues()) {
                    pStm.setObject(i, object);
                    ++i;
                }
                pStm.execute();
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot import the track line ", ex);
            }
            this.getReader().setContentHandler(this.parent);
        } else if (this.getCurrentElement().compareToIgnoreCase("trkseg") == 0) {
            Coordinate[] trksegArray = this.trksegList.toArray(new Coordinate[0]);
            if (this.trksegList.size() > 1) {
                LineString geometry = this.getGeometryFactory().createLineString(trksegArray);
                geometry.setSRID(4326);
                this.getCurrentSegment().setGeometry((Geometry)geometry);
                this.trkList.add(geometry);
            }
            try {
                Object[] values;
                PreparedStatement pStm = this.getTrkSegmentsPreparedStmt();
                int i = 1;
                for (Object object : values = this.getCurrentSegment().getValues()) {
                    pStm.setObject(i, object);
                    ++i;
                }
                pStm.execute();
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot import the track segment ", ex);
            }
        } else if (this.getCurrentElement().equalsIgnoreCase(GPXTags.TRKPT)) {
            this.point = false;
            try {
                Object[] values;
                PreparedStatement pStm = this.getTrkPointsPreparedStmt();
                int i = 1;
                for (Object object : values = this.getCurrentPoint().getValues()) {
                    pStm.setObject(i, object);
                    ++i;
                }
                pStm.execute();
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot import the track waypoints.", ex);
            }
        } else if (this.point) {
            this.getCurrentPoint().setAttribute(this.getCurrentElement(), this.getContentBuffer());
        } else if (this.segment) {
            this.getCurrentSegment().setExtensions();
        } else {
            this.getCurrentLine().setAttribute(this.getCurrentElement(), this.getContentBuffer());
        }
    }

    public void setParent(AbstractGpxParserDefault parent) {
        this.parent = parent;
    }

    public boolean isPoint() {
        return this.point;
    }

    public void setTrkList(List<LineString> trkList) {
        this.trkList = trkList;
    }

    public void setTrksegList(List<Coordinate> trksegList) {
        this.trksegList = trksegList;
    }
}

