/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;

public class OSMTablesFactory {
    public static final String TAG = "_tag";
    public static final String NODE = "_node";
    public static final String WAY = "_way";
    public static final String NODE_TAG = "_node_tag";
    public static final String WAY_TAG = "_way_tag";
    public static final String WAY_NODE = "_way_node";
    public static final String RELATION = "_relation";
    public static final String RELATION_TAG = "_relation_tag";
    public static final String NODE_MEMBER = "_node_member";
    public static final String WAY_MEMBER = "_way_member";
    public static final String RELATION_MEMBER = "_relation_member";

    private OSMTablesFactory() {
    }

    public static PreparedStatement createTagTable(Connection connection, String tagTableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("CREATE TABLE " + tagTableName + "(ID_TAG SERIAL PRIMARY KEY, TAG_KEY VARCHAR UNIQUE);");
        }
        return connection.prepareStatement("INSERT INTO " + tagTableName + " (TAG_KEY) VALUES (?)");
    }

    public static PreparedStatement createNodeTable(Connection connection, String nodeTableName, boolean isH2) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(nodeTableName);
            sb.append("(ID_NODE BIGINT PRIMARY KEY,  THE_GEOM ");
            if (isH2) {
                sb.append("POINT CHECK ST_SRID(THE_GEOM)=4326");
            } else {
                sb.append("GEOMETRY(POINT, 4326)");
            }
            sb.append(",ELE DOUBLE PRECISION,USER_NAME VARCHAR,UID BIGINT,VISIBLE BOOLEAN,VERSION INTEGER,CHANGESET INTEGER,LAST_UPDATE TIMESTAMP,NAME VARCHAR);");
            stmt.execute(sb.toString());
        }
        return connection.prepareStatement("INSERT INTO " + nodeTableName + " VALUES (?,?,?,?,?,?,?,?,?,?);");
    }

    public static PreparedStatement createNodeTagTable(Connection connection, String nodeTagTableName, String tagTableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(nodeTagTableName);
            sb.append("(ID_NODE BIGINT, ID_TAG BIGINT,TAG_VALUE VARCHAR); ");
            stmt.execute(sb.toString());
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ");
        insert.append(nodeTagTableName);
        insert.append("VALUES ( ?, ");
        insert.append("(SELECT ID_TAG FROM ").append(tagTableName).append(" WHERE TAG_KEY = ? LIMIT 1)");
        insert.append(", ?);");
        return connection.prepareStatement(insert.toString());
    }

    public static PreparedStatement createWayTable(Connection connection, String wayTableName, boolean isH2) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(wayTableName);
            sb.append("(ID_WAY BIGINT PRIMARY KEY, USER_NAME VARCHAR, UID BIGINT, VISIBLE BOOLEAN, VERSION INTEGER, CHANGESET INTEGER, LAST_UPDATE TIMESTAMP, NAME VARCHAR);");
            stmt.execute(sb.toString());
        }
        return connection.prepareStatement("INSERT INTO " + wayTableName + " VALUES (?,?,?,?,?,?,?,?);");
    }

    public static PreparedStatement createWayTagTable(Connection connection, String wayTagTableName, String tagTableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(wayTagTableName);
            sb.append("(ID_WAY BIGINT, ID_TAG BIGINT, VALUE VARCHAR);");
            stmt.execute(sb.toString());
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ");
        insert.append(wayTagTableName);
        insert.append("VALUES ( ?, ");
        insert.append("(SELECT ID_TAG FROM ").append(tagTableName).append(" WHERE TAG_KEY = ? LIMIT 1)");
        insert.append(", ?);");
        return connection.prepareStatement(insert.toString());
    }

    public static PreparedStatement createWayNodeTable(Connection connection, String wayNodeTableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(wayNodeTableName);
            sb.append("(ID_WAY BIGINT, ID_NODE BIGINT, NODE_ORDER INT);");
            stmt.execute(sb.toString());
        }
        return connection.prepareStatement("INSERT INTO " + wayNodeTableName + " VALUES ( ?, ?,?);");
    }

    public static PreparedStatement createRelationTable(Connection connection, String relationTable) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(relationTable);
            sb.append("(ID_RELATION BIGINT PRIMARY KEY,USER_NAME VARCHAR,UID BIGINT,VISIBLE BOOLEAN,VERSION INTEGER,CHANGESET INTEGER,LAST_UPDATE TIMESTAMP);");
            stmt.execute(sb.toString());
        }
        return connection.prepareStatement("INSERT INTO " + relationTable + " VALUES ( ?,?,?,?,?,?,?);");
    }

    public static PreparedStatement createRelationTagTable(Connection connection, String relationTagTable, String tagTableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(relationTagTable);
            sb.append("(ID_RELATION BIGINT, ID_TAG BIGINT, TAG_VALUE VARCHAR);");
            stmt.execute(sb.toString());
        }
        StringBuilder insert = new StringBuilder("INSERT INTO ");
        insert.append(relationTagTable);
        insert.append("VALUES ( ?, ");
        insert.append("(SELECT ID_TAG FROM ").append(tagTableName).append(" WHERE TAG_KEY = ? LIMIT 1)");
        insert.append(", ?);");
        return connection.prepareStatement(insert.toString());
    }

    public static PreparedStatement createNodeMemberTable(Connection connection, String nodeMemberTable) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(nodeMemberTable);
            sb.append("(ID_RELATION BIGINT,ID_NODE BIGINT, ROLE VARCHAR, NODE_ORDER INT);");
            stmt.execute(sb.toString());
        }
        return connection.prepareStatement("INSERT INTO " + nodeMemberTable + " VALUES ( ?,?,?,?);");
    }

    public static PreparedStatement createWayMemberTable(Connection connection, String wayMemberTable) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(wayMemberTable);
            sb.append("(ID_RELATION BIGINT, ID_WAY BIGINT, ROLE VARCHAR, WAY_ORDER INT);");
            stmt.execute(sb.toString());
        }
        return connection.prepareStatement("INSERT INTO " + wayMemberTable + " VALUES ( ?,?,?,?);");
    }

    public static PreparedStatement createRelationMemberTable(Connection connection, String relationMemberTable) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            StringBuilder sb = new StringBuilder("CREATE TABLE ");
            sb.append(relationMemberTable);
            sb.append("(ID_RELATION BIGINT, ID_SUB_RELATION BIGINT, ROLE VARCHAR, RELATION_ORDER INT);");
            stmt.execute(sb.toString());
        }
        return connection.prepareStatement("INSERT INTO " + relationMemberTable + " VALUES ( ?,?,?,?);");
    }

    public static void dropOSMTables(Connection connection, boolean isH2, String tablePrefix) throws SQLException {
        TableLocation requestedTable = TableLocation.parse((String)tablePrefix, (Boolean)isH2);
        String osmTableName = requestedTable.getTable();
        String[] omsTables = new String[]{TAG, NODE, NODE_TAG, WAY, WAY_NODE, WAY_TAG, RELATION, RELATION_TAG, NODE_MEMBER, WAY_MEMBER, RELATION_MEMBER};
        StringBuilder sb = new StringBuilder("drop table if exists ");
        String omsTableSuffix = omsTables[0];
        String osmTable = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + omsTableSuffix), (boolean)isH2);
        sb.append(osmTable);
        for (int i = 1; i < omsTables.length; ++i) {
            omsTableSuffix = omsTables[i];
            osmTable = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + omsTableSuffix), (boolean)isH2);
            sb.append(",").append(osmTable);
        }
        try (Statement stmt = connection.createStatement();){
            stmt.execute(sb.toString());
        }
    }
}

