/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.geom.util.LineStringExtracter;
import org.locationtech.jts.geom.util.PointExtracter;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.union.UnaryUnionOp;

public class MakeValidOp {
    private static final Coordinate[] EMPTY_COORD_ARRAY = new Coordinate[0];
    private static final LinearRing[] EMPTY_RING_ARRAY = new LinearRing[0];
    private boolean preserveGeomDim = true;
    private boolean preserveCoordDim = true;
    private boolean preserveDuplicateCoord = true;

    public MakeValidOp setPreserveGeomDim(boolean preserveGeomDim) {
        this.preserveGeomDim = preserveGeomDim;
        return this;
    }

    public MakeValidOp setPreserveCoordDim(boolean preserveCoordDim) {
        this.preserveCoordDim = preserveCoordDim;
        return this;
    }

    public MakeValidOp setPreserveDuplicateCoord(boolean preserveDuplicateCoord) {
        this.preserveDuplicateCoord = preserveDuplicateCoord;
        return this;
    }

    private static void decompose(Geometry geometry, Collection<Geometry> list) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry component = geometry.getGeometryN(i);
            if (component instanceof GeometryCollection) {
                MakeValidOp.decompose(component, list);
                continue;
            }
            list.add(component);
        }
    }

    public Geometry makeValid(Geometry geometry) {
        ArrayList<Geometry> list = new ArrayList<Geometry>(geometry.getNumGeometries());
        MakeValidOp.decompose(geometry, list);
        Collection<Object> list2 = new ArrayList();
        for (Geometry component : list) {
            int i;
            if (component instanceof Point) {
                Point point = this.makePointValid((Point)component);
                if (point.isEmpty()) continue;
                list2.add(point);
                continue;
            }
            if (component instanceof LineString) {
                Geometry geometry2 = this.makeLineStringValid((LineString)component);
                for (i = 0; i < geometry2.getNumGeometries(); ++i) {
                    if (geometry2.getGeometryN(i).isEmpty()) continue;
                    list2.add(geometry2.getGeometryN(i));
                }
                continue;
            }
            if (component instanceof Polygon) {
                Geometry geometry3 = this.makePolygonValid((Polygon)component);
                for (i = 0; i < geometry3.getNumGeometries(); ++i) {
                    if (geometry3.getGeometryN(i).isEmpty()) continue;
                    list2.add(geometry3.getGeometryN(i));
                }
                continue;
            }
            assert (false) : "Should never reach here";
        }
        list.clear();
        for (Object g : list2) {
            if (this.preserveGeomDim && !geometry.getClass().getSimpleName().equals("GeometryCollection")) {
                this.removeLowerDimension((Geometry)g, list, geometry.getDimension());
                continue;
            }
            MakeValidOp.decompose((Geometry)g, list);
        }
        list2 = list;
        if (list2.size() > 1) {
            boolean multiPolygon = true;
            for (Geometry geometry4 : list2) {
                if (geometry4.getDimension() >= 2) continue;
                multiPolygon = false;
            }
            if (multiPolygon) {
                list2 = this.unionAdjacentPolygons(list2);
            }
        }
        if (list2.isEmpty()) {
            GeometryFactory factory = geometry.getFactory();
            if (geometry instanceof Point) {
                return factory.createPoint((Coordinate)null);
            }
            if (geometry instanceof LinearRing) {
                return factory.createLinearRing(EMPTY_COORD_ARRAY);
            }
            if (geometry instanceof LineString) {
                return factory.createLineString(EMPTY_COORD_ARRAY);
            }
            if (geometry instanceof Polygon) {
                return factory.createPolygon(factory.createLinearRing(EMPTY_COORD_ARRAY), EMPTY_RING_ARRAY);
            }
            if (geometry instanceof MultiPoint) {
                return factory.createMultiPoint(new Point[0]);
            }
            if (geometry instanceof MultiLineString) {
                return factory.createMultiLineString(new LineString[0]);
            }
            if (geometry instanceof MultiPolygon) {
                return factory.createMultiPolygon(new Polygon[0]);
            }
            return factory.createGeometryCollection(new Geometry[0]);
        }
        CoordinateSequenceFactory csFactory = geometry.getFactory().getCoordinateSequenceFactory();
        if (this.preserveCoordDim && csFactory instanceof PackedCoordinateSequenceFactory && ((PackedCoordinateSequenceFactory)csFactory).getDimension() == 4) {
            HashMap<Coordinate, Double> map = new HashMap<Coordinate, Double>();
            this.gatherDim4(geometry, map);
            list2 = this.restoreDim4(list2, map);
        }
        Geometry result = geometry.getFactory().buildGeometry(list2);
        if (geometry instanceof GeometryCollection && !(result instanceof GeometryCollection)) {
            if (geometry instanceof MultiPoint && result instanceof Point) {
                result = geometry.getFactory().createMultiPoint(new Point[]{(Point)result});
            } else if (geometry instanceof MultiLineString && result instanceof LineString) {
                result = geometry.getFactory().createMultiLineString(new LineString[]{(LineString)result});
            } else if (geometry instanceof MultiPolygon && result instanceof Polygon) {
                result = geometry.getFactory().createMultiPolygon(new Polygon[]{(Polygon)result});
            }
        }
        return result;
    }

    private void removeLowerDimension(Geometry geometry, List<Geometry> result, int dimension) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry g = geometry.getGeometryN(i);
            if (g instanceof GeometryCollection) {
                this.removeLowerDimension(g, result, dimension);
                continue;
            }
            if (g.getDimension() < dimension) continue;
            result.add(g);
        }
    }

    private Collection<Geometry> unionAdjacentPolygons(Collection<Geometry> list) {
        UnaryUnionOp op = new UnaryUnionOp(list);
        Geometry result = op.union();
        if (result.getNumGeometries() < list.size()) {
            list.clear();
            for (int i = 0; i < result.getNumGeometries(); ++i) {
                list.add(result.getGeometryN(i));
            }
        }
        return list;
    }

    private Point makePointValid(Point point) {
        CoordinateSequence sequence = point.getCoordinateSequence();
        GeometryFactory factory = point.getFactory();
        CoordinateSequenceFactory csFactory = factory.getCoordinateSequenceFactory();
        if (sequence.size() == 0) {
            return point;
        }
        if (Double.isNaN(sequence.getOrdinate(0, 0)) || Double.isNaN(sequence.getOrdinate(0, 1))) {
            return factory.createPoint(csFactory.create(0, sequence.getDimension()));
        }
        if (sequence.size() == 1) {
            return point;
        }
        throw new RuntimeException("JTS cannot create a point from a CoordinateSequence containing several points");
    }

    private static CoordinateSequence makeSequenceValid(CoordinateSequence sequence, boolean preserveDuplicateCoord, boolean close) {
        int dim = sequence.getDimension();
        double[] array = new double[(sequence.size() + 1) * sequence.getDimension()];
        boolean modified = false;
        int count = 0;
        for (int i = 0; i < sequence.size(); ++i) {
            if (Double.isNaN(sequence.getOrdinate(i, 0)) || Double.isNaN(sequence.getOrdinate(i, 1))) {
                modified = true;
                continue;
            }
            if (!preserveDuplicateCoord && count > 0 && sequence.getCoordinate(i).equals((Object)sequence.getCoordinate(i - 1))) {
                modified = true;
                continue;
            }
            for (int j = 0; j < dim; ++j) {
                array[count * dim + j] = sequence.getOrdinate(i, j);
                if (j != dim - 1) continue;
                ++count;
            }
        }
        if (close && count > 2 && (array[0] != array[(count - 1) * dim] || array[1] != array[(count - 1) * dim + 1])) {
            System.arraycopy(array, 0, array, count * dim, dim);
            modified = true;
            ++count;
        }
        if (close && count > 3 && dim > 2) {
            for (int d = 2; d < dim; ++d) {
                if (array[(count - 1) * dim + d] != array[d]) {
                    modified = true;
                }
                array[(count - 1) * dim + d] = array[d];
            }
        }
        if (modified) {
            double[] shrinkedArray = new double[count * dim];
            System.arraycopy(array, 0, shrinkedArray, 0, count * dim);
            return PackedCoordinateSequenceFactory.DOUBLE_FACTORY.create(shrinkedArray, dim);
        }
        return sequence;
    }

    private Geometry makeLineStringValid(LineString lineString) {
        CoordinateSequence sequence = lineString.getCoordinateSequence();
        CoordinateSequence sequenceWithoutDuplicates = MakeValidOp.makeSequenceValid(sequence, false, false);
        GeometryFactory factory = lineString.getFactory();
        if (sequenceWithoutDuplicates.size() == 0) {
            return factory.createLineString(factory.getCoordinateSequenceFactory().create(0, sequence.getDimension()));
        }
        if (sequenceWithoutDuplicates.size() == 1) {
            if (this.preserveGeomDim) {
                return factory.createLineString(factory.getCoordinateSequenceFactory().create(0, sequence.getDimension()));
            }
            return factory.createPoint(sequenceWithoutDuplicates);
        }
        if (this.preserveDuplicateCoord) {
            return factory.createLineString(MakeValidOp.makeSequenceValid(sequence, true, false));
        }
        return factory.createLineString(sequenceWithoutDuplicates);
    }

    private Geometry makePolygonValid(Polygon polygon) {
        Geometry geom = this.makePolygonComponentsValid(polygon);
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry component = geom.getGeometryN(i);
            if (component instanceof Polygon) {
                Geometry nodedPolygon = this.nodePolygon((Polygon)component);
                for (int j = 0; j < nodedPolygon.getNumGeometries(); ++j) {
                    list.add(nodedPolygon.getGeometryN(j));
                }
                continue;
            }
            list.add(component);
        }
        return polygon.getFactory().buildGeometry(list);
    }

    private Geometry makePolygonComponentsValid(Polygon polygon) {
        GeometryFactory factory = polygon.getFactory();
        CoordinateSequence outerRingSeq = MakeValidOp.makeSequenceValid(polygon.getExteriorRing().getCoordinateSequence(), false, true);
        if (outerRingSeq.size() == 0 || outerRingSeq.size() < 4) {
            ArrayList<Geometry> list = new ArrayList<Geometry>();
            if (outerRingSeq.size() > 0) {
                list.add(this.makeLineStringValid(polygon.getExteriorRing()));
            }
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                Geometry g = this.makeLineStringValid(polygon.getInteriorRingN(i));
                if (g.isEmpty()) continue;
                list.add(g);
            }
            if (list.isEmpty()) {
                return factory.createPolygon(outerRingSeq);
            }
            return factory.buildGeometry(list);
        }
        ArrayList<LinearRing> innerRings = new ArrayList<LinearRing>();
        ArrayList<Object> degeneratedRings = new ArrayList<Object>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            CoordinateSequence seq = MakeValidOp.makeSequenceValid(polygon.getInteriorRingN(i).getCoordinateSequence(), false, true);
            if (seq.size() > 3) {
                innerRings.add(factory.createLinearRing(seq));
                continue;
            }
            if (seq.size() > 1) {
                degeneratedRings.add(factory.createLineString(seq));
                continue;
            }
            if (seq.size() != 1) continue;
            degeneratedRings.add(factory.createPoint(seq));
        }
        Polygon poly = factory.createPolygon(factory.createLinearRing(outerRingSeq), innerRings.toArray(new LinearRing[0]));
        if (degeneratedRings.isEmpty()) {
            return poly;
        }
        degeneratedRings.add(0, poly);
        return factory.buildGeometry(degeneratedRings);
    }

    private Geometry nodePolygon(Polygon polygon) {
        LinearRing exteriorRing = (LinearRing)polygon.getExteriorRing();
        Geometry geom = this.getArealGeometryFromLinearRing(exteriorRing);
        ArrayList polys = new ArrayList();
        ArrayList lines = new ArrayList();
        ArrayList points = new ArrayList();
        geom.apply((GeometryFilter)new PolygonExtracter(polys));
        geom.apply((GeometryFilter)new LineStringExtracter(lines));
        geom.apply((GeometryFilter)new PointExtracter(points));
        geom = geom.getFactory().buildGeometry(polys);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing interiorRing = (LinearRing)polygon.getInteriorRingN(i);
            polys.clear();
            this.getArealGeometryFromLinearRing(interiorRing).apply((GeometryFilter)new PolygonExtracter(polys));
            geom = geom.symDifference(geom.getFactory().buildGeometry(polys));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(geom);
        result.addAll(lines);
        result.addAll(points);
        return geom.getFactory().buildGeometry(result);
    }

    private Geometry getArealGeometryFromLinearRing(LinearRing ring) {
        if (ring.isSimple()) {
            return ring.getFactory().createMultiPolygon(new Polygon[]{ring.getFactory().createPolygon(ring, EMPTY_RING_ARRAY)});
        }
        Set<LineString> lines = this.nodeLineString(ring.getCoordinates(), ring.getFactory());
        lines = this.getSegments(lines);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(lines);
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (Object object : polygonizer.getPolygons()) {
            Polygon polygon = (Polygon)object;
            Coordinate p = polygon.getInteriorPoint().getCoordinate();
            int location = RayCrossingCounter.locatePointInRing((Coordinate)p, (CoordinateSequence)ring.getCoordinateSequence());
            if (location != 0) continue;
            geoms.add((Geometry)polygon);
        }
        Geometry unionPoly = UnaryUnionOp.union(geoms);
        Geometry unionLines = UnaryUnionOp.union(lines).difference(unionPoly.getBoundary());
        geoms.clear();
        MakeValidOp.decompose(unionPoly, geoms);
        MakeValidOp.decompose(unionLines, geoms);
        return ring.getFactory().buildGeometry(geoms);
    }

    private Set<LineString> getSegments(Collection<LineString> lines) {
        HashSet<LineString> set = new HashSet<LineString>();
        for (LineString line : lines) {
            Coordinate[] cc = line.getCoordinates();
            for (int i = 1; i < cc.length; ++i) {
                if (cc[i - 1].equals((Object)cc[i])) continue;
                LineString segment = line.getFactory().createLineString(new Coordinate[]{new Coordinate(cc[i - 1]), new Coordinate(cc[i])});
                set.add(segment);
            }
        }
        return set;
    }

    private Collection<Geometry> restoreDim4(Collection<Geometry> geoms, Map<Coordinate, Double> map) {
        GeometryFactory factory = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory(0, 4));
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        for (Geometry geom : geoms) {
            if (geom instanceof Point) {
                result.add((Geometry)factory.createPoint(this.restoreDim4(((Point)geom).getCoordinateSequence(), map)));
                continue;
            }
            if (geom instanceof LineString) {
                result.add((Geometry)factory.createLineString(this.restoreDim4(((LineString)geom).getCoordinateSequence(), map)));
                continue;
            }
            if (geom instanceof Polygon) {
                LinearRing outer = factory.createLinearRing(this.restoreDim4(((Polygon)geom).getExteriorRing().getCoordinateSequence(), map));
                LinearRing[] inner = new LinearRing[((Polygon)geom).getNumInteriorRing()];
                for (int i = 0; i < ((Polygon)geom).getNumInteriorRing(); ++i) {
                    inner[i] = factory.createLinearRing(this.restoreDim4(((Polygon)geom).getInteriorRingN(i).getCoordinateSequence(), map));
                }
                result.add((Geometry)factory.createPolygon(outer, inner));
                continue;
            }
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                result.addAll(this.restoreDim4(Collections.singleton(geom.getGeometryN(i)), map));
            }
        }
        return result;
    }

    private void gatherDim4(Geometry geometry, Map<Coordinate, Double> map) {
        if (geometry instanceof Point) {
            this.gatherDim4(((Point)geometry).getCoordinateSequence(), map);
        } else if (geometry instanceof LineString) {
            this.gatherDim4(((LineString)geometry).getCoordinateSequence(), map);
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            this.gatherDim4(polygon.getExteriorRing().getCoordinateSequence(), map);
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                this.gatherDim4(polygon.getInteriorRingN(i).getCoordinateSequence(), map);
            }
        } else {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                this.gatherDim4(geometry.getGeometryN(i), map);
            }
        }
    }

    private void gatherDim4(CoordinateSequence cs, Map<Coordinate, Double> map) {
        if (cs.getDimension() == 4) {
            for (int i = 0; i < cs.size(); ++i) {
                map.put(cs.getCoordinate(i), cs.getOrdinate(i, 3));
            }
        }
    }

    private CoordinateSequence restoreDim4(CoordinateSequence cs, Map<Coordinate, Double> map) {
        CoordinateSequence seq = new PackedCoordinateSequenceFactory(0, 4).create(cs.size(), 4);
        for (int i = 0; i < cs.size(); ++i) {
            seq.setOrdinate(i, 0, cs.getOrdinate(i, 0));
            seq.setOrdinate(i, 1, cs.getOrdinate(i, 1));
            seq.setOrdinate(i, 2, cs.getOrdinate(i, 2));
            Double d = map.get(cs.getCoordinate(i));
            seq.setOrdinate(i, 3, d == null ? Double.NaN : d);
        }
        return seq;
    }

    private Set<LineString> nodeLineString(Coordinate[] coords, GeometryFactory gf) {
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector((SegmentIntersector)new IntersectionAdder((LineIntersector)new RobustLineIntersector()));
        ArrayList<NodedSegmentString> list = new ArrayList<NodedSegmentString>();
        list.add(new NodedSegmentString(coords, null));
        noder.computeNodes(list);
        List lineStringList = new ArrayList<LineString>();
        for (Object segmentString : noder.getNodedSubstrings()) {
            lineStringList.add(gf.createLineString(((NodedSegmentString)segmentString).getCoordinates()));
        }
        LineMerger merger = new LineMerger();
        merger.add(lineStringList);
        lineStringList = (List)merger.getMergedLineStrings();
        HashSet<LineString> lineStringSet = new HashSet<LineString>();
        for (LineString line : lineStringList) {
            if (lineStringSet.contains(line) || lineStringSet.contains(line.reverse())) continue;
            lineStringSet.add(line);
        }
        return lineStringSet;
    }
}

