/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class GeometryCoordinateDimension {
    static final GeometryFactory gf = new GeometryFactory();

    public static Geometry force(Geometry geom, int dimension) {
        if (geom instanceof Point) {
            return gf.createPoint((CoordinateSequence)GeometryCoordinateDimension.convertSequence(geom.getCoordinates(), dimension));
        }
        if (geom instanceof LineString) {
            return gf.createLineString((CoordinateSequence)GeometryCoordinateDimension.convertSequence(geom.getCoordinates(), dimension));
        }
        if (geom instanceof Polygon) {
            return GeometryCoordinateDimension.convert((Polygon)geom, dimension);
        }
        if (geom instanceof MultiPoint) {
            return gf.createMultiPoint((CoordinateSequence)GeometryCoordinateDimension.convertSequence(geom.getCoordinates(), dimension));
        }
        if (geom instanceof MultiLineString) {
            return GeometryCoordinateDimension.convert((MultiLineString)geom, dimension);
        }
        if (geom instanceof MultiPolygon) {
            return GeometryCoordinateDimension.convert((MultiPolygon)geom, dimension);
        }
        if (geom instanceof GeometryCollection) {
            return GeometryCoordinateDimension.convert((GeometryCollection)geom, dimension);
        }
        return geom;
    }

    public static GeometryCollection convert(GeometryCollection gc, int dimension) {
        int nb = gc.getNumGeometries();
        Geometry[] geometries = new Geometry[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = GeometryCoordinateDimension.force(gc.getGeometryN(i), dimension);
        }
        return gf.createGeometryCollection(geometries);
    }

    public static MultiPolygon convert(MultiPolygon multiPolygon, int dimension) {
        int nb = multiPolygon.getNumGeometries();
        Polygon[] pl = new Polygon[nb];
        for (int i = 0; i < nb; ++i) {
            pl[i] = GeometryCoordinateDimension.convert((Polygon)multiPolygon.getGeometryN(i), dimension);
        }
        return gf.createMultiPolygon(pl);
    }

    public static MultiLineString convert(MultiLineString multiLineString, int dimension) {
        int nb = multiLineString.getNumGeometries();
        LineString[] ls = new LineString[nb];
        for (int i = 0; i < nb; ++i) {
            ls[i] = GeometryCoordinateDimension.convert((LineString)multiLineString.getGeometryN(i), dimension);
        }
        return gf.createMultiLineString(ls);
    }

    public static Polygon convert(Polygon polygon, int dimension) {
        LinearRing shell = GeometryCoordinateDimension.convert(polygon.getExteriorRing(), dimension);
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = GeometryCoordinateDimension.convert(polygon.getInteriorRingN(i), dimension);
        }
        return gf.createPolygon(shell, holes);
    }

    public static LinearRing convert(LineString lineString, int dimension) {
        return gf.createLinearRing((CoordinateSequence)GeometryCoordinateDimension.convertSequence(lineString.getCoordinates(), dimension));
    }

    public static LinearRing convert(LinearRing linearRing, int dimension) {
        return gf.createLinearRing((CoordinateSequence)GeometryCoordinateDimension.convertSequence(linearRing.getCoordinates(), dimension));
    }

    private static CoordinateArraySequence convertSequence(Coordinate[] cs, int dimension) {
        block4: for (int i = 0; i < cs.length; ++i) {
            Coordinate coord = cs[i];
            switch (dimension) {
                case 2: {
                    coord.z = Double.NaN;
                    cs[i] = coord;
                    continue block4;
                }
                case 3: {
                    double z = coord.z;
                    if (!Double.isNaN(z)) continue block4;
                    coord.z = 0.0;
                    cs[i] = coord;
                    continue block4;
                }
            }
        }
        return new CoordinateArraySequence(cs, dimension);
    }
}

