/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeoJsonWriteDriver {
    private final Connection connection;
    private Map<String, String> cachedSpecificColumns;
    private LinkedHashMap<String, Integer> cachedColumnIndex;
    private int columnCountProperties = -1;

    public GeoJsonWriteDriver(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ProgressVisitor progress, ResultSet rs, File fileName, String encoding, boolean deleteFile) throws SQLException, IOException {
        if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"geojson")) {
            if (deleteFile) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The geojson file already exist.");
            }
            this.geojsonWriter(progress, rs, (OutputStream)new FileOutputStream(fileName), encoding);
        } else {
            if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"gz")) {
                if (deleteFile) {
                    Files.deleteIfExists(fileName.toPath());
                } else if (fileName.exists()) {
                    throw new IOException("The gz file already exist.");
                }
                DeflaterOutputStream gzos = null;
                try {
                    FileOutputStream fos = new FileOutputStream(fileName);
                    gzos = new GZIPOutputStream(fos);
                    this.geojsonWriter(progress, rs, (OutputStream)gzos, encoding);
                }
                finally {
                    try {
                        if (gzos != null) {
                            gzos.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new SQLException(ex);
                    }
                }
            }
            if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"zip")) {
                if (deleteFile) {
                    Files.deleteIfExists(fileName.toPath());
                } else if (fileName.exists()) {
                    throw new IOException("The zip file already exist.");
                }
                ZipOutputStream zip = null;
                try {
                    FileOutputStream fos = new FileOutputStream(fileName);
                    zip = new ZipOutputStream(fos);
                    this.geojsonWriter(progress, rs, (OutputStream)zip, encoding);
                }
                finally {
                    try {
                        if (zip != null) {
                            zip.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new SQLException(ex);
                    }
                }
            }
            throw new SQLException("Only .geojson , .gz or .zip extensions are supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void geojsonWriter(ProgressVisitor progress, ResultSet rs, OutputStream fos, String encoding) throws SQLException, IOException {
        JsonEncoding jsonEncoding = JsonEncoding.UTF8;
        if (encoding != null && !encoding.isEmpty()) {
            try {
                jsonEncoding = JsonEncoding.valueOf((String)encoding);
            }
            catch (IllegalArgumentException ex) {
                throw new SQLException("Only UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, UTF-32LE encoding is supported");
            }
        }
        try {
            int srid = 0;
            int rowCount = 0;
            int type = rs.getType();
            if (type == 1004 || type == 1005) {
                rs.last();
                rowCount = rs.getRow();
                rs.beforeFirst();
            }
            ProgressVisitor copyProgress = progress.subProcess(rowCount);
            Tuple geometryInfo = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((ResultSetMetaData)rs.getMetaData());
            JsonFactory jsonFactory = new JsonFactory();
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)new BufferedOutputStream(fos), jsonEncoding);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("type", "FeatureCollection");
            try {
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                this.cacheMetadata(resultSetMetaData);
                rs.next();
                Geometry firstGeom = (Geometry)rs.getObject((Integer)geometryInfo.second());
                String[] authAndSrid = GeometryTableUtilities.getAuthorityAndSRID((Connection)this.connection, (int)firstGeom.getSRID());
                if (authAndSrid != null) {
                    this.writeCRS(jsonGenerator, authAndSrid);
                    srid = Integer.parseInt(authAndSrid[1]);
                }
                jsonGenerator.writeArrayFieldStart("features");
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("type", "Feature");
                this.writeGeometry((Geometry)rs.getObject((Integer)geometryInfo.second()), jsonGenerator);
                this.writeProperties(jsonGenerator, rs);
                jsonGenerator.writeEndObject();
                copyProgress.endStep();
                while (rs.next()) {
                    this.writeFeatureCheckSRID(jsonGenerator, rs, (Integer)geometryInfo.second(), srid);
                    copyProgress.endStep();
                }
                copyProgress.endOfProgress();
                jsonGenerator.writeEndArray();
                jsonGenerator.writeEndObject();
                jsonGenerator.flush();
                jsonGenerator.close();
            }
            finally {
                rs.close();
            }
        }
        catch (FileNotFoundException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void geojsonWriter(ProgressVisitor progress, String tableName, OutputStream fos, String encoding) throws SQLException, IOException {
        block21: {
            DBTypes dbTypes = DBUtils.getDBType((Connection)this.connection);
            JsonEncoding jsonEncoding = JsonEncoding.UTF8;
            if (encoding != null) {
                try {
                    jsonEncoding = JsonEncoding.valueOf((String)encoding);
                }
                catch (IllegalArgumentException ex) {
                    throw new SQLException("Only UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, UTF-32LE encoding is supported");
                }
            }
            try {
                TableLocation parse = TableLocation.parse((String)tableName, (DBTypes)dbTypes);
                int recordCount = JDBCUtilities.getRowCount((Connection)this.connection, (String)parse.toString());
                if (recordCount <= 0) break block21;
                ProgressVisitor copyProgress = progress.subProcess(recordCount);
                Tuple geometryTableInfo = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((Connection)this.connection, (TableLocation)parse);
                try (Statement st = this.connection.createStatement();){
                    JsonFactory jsonFactory = new JsonFactory();
                    JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)new BufferedOutputStream(fos), jsonEncoding);
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeStringField("type", "FeatureCollection");
                    this.writeCRS(jsonGenerator, GeometryTableUtilities.getAuthorityAndSRID((Connection)this.connection, (TableLocation)parse, (String)((String)geometryTableInfo.first())));
                    jsonGenerator.writeArrayFieldStart("features");
                    try (ResultSet rs = st.executeQuery(String.format("select * from %s", tableName));){
                        ResultSetMetaData resultSetMetaData = rs.getMetaData();
                        this.cacheMetadata(resultSetMetaData);
                        while (rs.next()) {
                            this.writeFeature(jsonGenerator, rs, (Integer)geometryTableInfo.second());
                            copyProgress.endStep();
                        }
                        copyProgress.endOfProgress();
                        jsonGenerator.writeEndArray();
                        jsonGenerator.writeEndObject();
                        jsonGenerator.flush();
                        jsonGenerator.close();
                    }
                }
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(ProgressVisitor progress, String tableName, File fileName, String encoding, boolean deleteFile) throws SQLException, IOException {
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableName);
        if (matcher.find()) {
            if (!tableName.startsWith("(") || !tableName.endsWith(")")) throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
            if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"geojson")) {
                if (deleteFile) {
                    Files.deleteIfExists(fileName.toPath());
                } else if (fileName.exists()) {
                    throw new IOException("The geojson file already exist.");
                }
                PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
                ResultSet rs = ps.executeQuery();
                this.geojsonWriter(progress, rs, (OutputStream)new FileOutputStream(fileName), encoding);
                return;
            }
            if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"gz")) {
                if (deleteFile) {
                    Files.deleteIfExists(fileName.toPath());
                } else if (fileName.exists()) {
                    throw new IOException("The gz file already exist.");
                }
                DeflaterOutputStream gzos = null;
                try {
                    FileOutputStream fos = new FileOutputStream(fileName);
                    gzos = new GZIPOutputStream(fos);
                    PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
                    ResultSet rs = ps.executeQuery();
                    this.geojsonWriter(progress, rs, (OutputStream)gzos, encoding);
                    return;
                }
                finally {
                    try {
                        if (gzos != null) {
                            gzos.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new SQLException(ex);
                    }
                }
            }
            if (!FileUtilities.isExtensionWellFormated((File)fileName, (String)"zip")) throw new SQLException("Only .geojson , .gz or .zip extensions are supported");
            if (deleteFile) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The zip file already exist.");
            }
            ZipOutputStream zip = null;
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                zip = new ZipOutputStream(fos);
                zip.putNextEntry(new ZipEntry(fileName.getName().substring(0, fileName.getName().length() - 4)));
                PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
                ResultSet rs = ps.executeQuery();
                this.geojsonWriter(progress, rs, (OutputStream)zip, encoding);
                return;
            }
            finally {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
        if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"geojson")) {
            if (deleteFile) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The geojson file already exist.");
            }
            this.geojsonWriter(progress, tableName, (OutputStream)new FileOutputStream(fileName), encoding);
            return;
        }
        if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"gz")) {
            if (deleteFile) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The gz file already exist.");
            }
            DeflaterOutputStream gzos = null;
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                gzos = new GZIPOutputStream(fos);
                this.geojsonWriter(progress, tableName, (OutputStream)gzos, encoding);
                return;
            }
            finally {
                try {
                    if (gzos != null) {
                        gzos.close();
                    }
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
        if (!FileUtilities.isExtensionWellFormated((File)fileName, (String)"zip")) throw new SQLException("Only .geojson , .gz or .zip extensions are supported");
        if (deleteFile) {
            Files.deleteIfExists(fileName.toPath());
        } else if (fileName.exists()) {
            throw new IOException("The zip file already exist.");
        }
        ZipOutputStream zip = null;
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            zip = new ZipOutputStream(fos);
            zip.putNextEntry(new ZipEntry(fileName.getName().substring(0, fileName.getName().length() - 4)));
            this.geojsonWriter(progress, tableName, (OutputStream)zip, encoding);
            return;
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
    }

    private void writeFeatureCheckSRID(JsonGenerator jsonGenerator, ResultSet rs, int geoFieldIndex, int srid) throws IOException, SQLException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", "Feature");
        Geometry geom = (Geometry)rs.getObject(geoFieldIndex);
        int geomSRID = geom.getSRID();
        if (geomSRID != srid) {
            throw new SQLException("Geojson file doesn't support mixed srid. \n" + srid + " != " + geomSRID);
        }
        this.writeGeometry(geom, jsonGenerator);
        this.writeProperties(jsonGenerator, rs);
        jsonGenerator.writeEndObject();
    }

    private void writeFeature(JsonGenerator jsonGenerator, ResultSet rs, int geoFieldIndex) throws IOException, SQLException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", "Feature");
        this.writeGeometry((Geometry)rs.getObject(geoFieldIndex), jsonGenerator);
        this.writeProperties(jsonGenerator, rs);
        jsonGenerator.writeEndObject();
    }

    private void cacheMetadata(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.cachedColumnIndex = new LinkedHashMap();
        this.cachedSpecificColumns = new LinkedHashMap<String, String>();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String fieldTypeName = resultSetMetaData.getColumnTypeName(i);
            String columnName = resultSetMetaData.getColumnName(i);
            if (fieldTypeName.toLowerCase().startsWith("geometry") || !this.isSupportedPropertyType(columnName, resultSetMetaData.getColumnType(i), fieldTypeName)) continue;
            this.cachedColumnIndex.put(columnName, i);
            ++this.columnCountProperties;
        }
    }

    private void writeGeometry(Geometry geom, JsonGenerator gen) throws IOException {
        if (geom != null) {
            gen.writeObjectFieldStart("geometry");
            if (geom instanceof Point) {
                this.write((Point)geom, gen);
            } else if (geom instanceof MultiPoint) {
                this.write((MultiPoint)geom, gen);
            } else if (geom instanceof LineString) {
                this.write((LineString)geom, gen);
            } else if (geom instanceof MultiLineString) {
                this.write((MultiLineString)geom, gen);
            } else if (geom instanceof Polygon) {
                this.write((Polygon)geom, gen);
            } else if (geom instanceof MultiPolygon) {
                this.write((MultiPolygon)geom, gen);
            } else if (geom instanceof GeometryCollection) {
                this.write((GeometryCollection)geom, gen);
            } else {
                throw new RuntimeException("Unsupported Geomery type");
            }
            gen.writeEndObject();
        } else {
            gen.writeNullField("geometry");
        }
    }

    private void write(Point point, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "Point");
        gen.writeFieldName("coordinates");
        this.writeCoordinate(point.getCoordinate(), gen);
    }

    private void write(MultiPoint points, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "MultiPoint");
        gen.writeFieldName("coordinates");
        this.writeCoordinates(points.getCoordinates(), gen);
    }

    private void write(LineString geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "LineString");
        gen.writeFieldName("coordinates");
        this.writeCoordinates(geom.getCoordinates(), gen);
    }

    private void write(MultiLineString geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "MultiLineString");
        gen.writeFieldName("coordinates");
        gen.writeStartArray();
        int size = geom.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            this.writeCoordinates(geom.getGeometryN(i).getCoordinates(), gen);
        }
        gen.writeEndArray();
    }

    private void write(GeometryCollection coll, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "GeometryCollection");
        gen.writeArrayFieldStart("geometries");
        int size = coll.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry geom = coll.getGeometryN(i);
            gen.writeStartObject();
            if (geom instanceof Point) {
                this.write((Point)geom, gen);
            } else if (geom instanceof MultiPoint) {
                this.write((MultiPoint)geom, gen);
            } else if (geom instanceof LineString) {
                this.write((LineString)geom, gen);
            } else if (geom instanceof MultiLineString) {
                this.write((MultiLineString)geom, gen);
            } else if (geom instanceof Polygon) {
                this.write((Polygon)geom, gen);
            } else if (geom instanceof MultiPolygon) {
                this.write((MultiPolygon)geom, gen);
            } else if (geom instanceof GeometryCollection) {
                this.write((GeometryCollection)geom, gen);
            } else {
                throw new RuntimeException("Unsupported Geomery type");
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    private void write(Polygon geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "Polygon");
        gen.writeFieldName("coordinates");
        gen.writeStartArray();
        this.writeCoordinates(geom.getExteriorRing().getCoordinates(), gen);
        for (int i = 0; i < geom.getNumInteriorRing(); ++i) {
            this.writeCoordinates(geom.getInteriorRingN(i).getCoordinates(), gen);
        }
        gen.writeEndArray();
    }

    private void write(MultiPolygon geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "MultiPolygon");
        gen.writeFieldName("coordinates");
        gen.writeStartArray();
        int size = geom.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Polygon p = (Polygon)geom.getGeometryN(i);
            gen.writeStartArray();
            this.writeCoordinates(p.getExteriorRing().getCoordinates(), gen);
            for (int j = 0; j < p.getNumInteriorRing(); ++j) {
                this.writeCoordinates(p.getInteriorRingN(j).getCoordinates(), gen);
            }
            gen.writeEndArray();
        }
        gen.writeEndArray();
    }

    private void writeCoordinate(Coordinate coordinate, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        gen.writeNumber(coordinate.x);
        gen.writeNumber(coordinate.y);
        if (!Double.isNaN(coordinate.getZ())) {
            gen.writeNumber(coordinate.getZ());
        }
        gen.writeEndArray();
    }

    private void writeCoordinates(Coordinate[] coordinates, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        for (Coordinate coord : coordinates) {
            this.writeCoordinate(coord, gen);
        }
        gen.writeEndArray();
    }

    private void writeProperties(JsonGenerator jsonGenerator, ResultSet rs) throws IOException, SQLException {
        if (this.columnCountProperties != -1) {
            jsonGenerator.writeObjectFieldStart("properties");
            for (Map.Entry<String, Integer> entry : this.cachedColumnIndex.entrySet()) {
                String columnName = entry.getKey();
                Integer fieldId = entry.getValue();
                if (this.cachedSpecificColumns.containsKey(columnName)) {
                    String specificType = this.cachedSpecificColumns.get(columnName);
                    if (specificType.equalsIgnoreCase("JSON")) {
                        jsonGenerator.writeFieldName(columnName);
                        jsonGenerator.writeString(rs.getString(fieldId));
                        continue;
                    }
                    if (!specificType.equalsIgnoreCase("TIME")) continue;
                    Object obj = rs.getObject(fieldId);
                    jsonGenerator.writeStringField(columnName, obj == null ? "null" : obj.toString());
                    continue;
                }
                if (rs.getObject(fieldId) instanceof Object[]) {
                    Object[] array = (Object[])rs.getObject(fieldId);
                    jsonGenerator.writeArrayFieldStart(columnName);
                    this.writeArray(jsonGenerator, array, true);
                    jsonGenerator.writeEndArray();
                    continue;
                }
                if (rs.getObject(fieldId) != null && rs.getObject(fieldId).equals("{}")) {
                    jsonGenerator.writeObjectFieldStart(columnName);
                    jsonGenerator.writeEndObject();
                    continue;
                }
                if (rs.getObject(fieldId) == "null") {
                    jsonGenerator.writeFieldName(columnName);
                    jsonGenerator.writeNull();
                    continue;
                }
                jsonGenerator.writeObjectField(columnName, rs.getObject(fieldId));
            }
            jsonGenerator.writeEndObject();
        }
    }

    public boolean isSupportedPropertyType(String columnName, int sqlTypeId, String sqlTypeName) throws SQLException {
        switch (sqlTypeId) {
            case -15: 
            case -5: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 1111: 
            case 2003: {
                if (sqlTypeName.equalsIgnoreCase("JSON")) {
                    this.cachedSpecificColumns.put(columnName, "JSON");
                    return true;
                }
            }
            case -6: 
            case 0: 
            case 2: 
            case 3: 
            case 7: {
                return true;
            }
            case 92: 
            case 93: {
                this.cachedSpecificColumns.put(columnName, "TIME");
                return true;
            }
        }
        throw new SQLException("Field type not supported by GeoJSON driver: " + sqlTypeName);
    }

    private void writeCRS(JsonGenerator jsonGenerator, String[] authorityAndSRID) throws IOException {
        if (authorityAndSRID[1] != null) {
            jsonGenerator.writeObjectFieldStart("crs");
            jsonGenerator.writeStringField("type", "name");
            jsonGenerator.writeObjectFieldStart("properties");
            jsonGenerator.writeStringField("name", "urn:ogc:def:crs:" + authorityAndSRID[0] + "::" + authorityAndSRID[1]);
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }

    private void writeArray(JsonGenerator jsonGenerator, Object[] array, boolean firstInHierarchy) throws IOException, SQLException {
        if (!firstInHierarchy) {
            jsonGenerator.writeStartArray();
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] instanceof Integer) {
                jsonGenerator.writeNumber(((Integer)array[i]).intValue());
                continue;
            }
            if (array[i] instanceof String) {
                if (array[i].equals("{}")) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeEndObject();
                    continue;
                }
                jsonGenerator.writeString((String)array[i]);
                continue;
            }
            if (array[i] instanceof Double) {
                jsonGenerator.writeNumber(((Double)array[i]).doubleValue());
                continue;
            }
            if (array[i] instanceof Boolean) {
                jsonGenerator.writeBoolean(((Boolean)array[i]).booleanValue());
                continue;
            }
            if (!(array[i] instanceof Object[])) continue;
            this.writeArray(jsonGenerator, (Object[])array[i], false);
        }
        if (!firstInHierarchy) {
            jsonGenerator.writeEndArray();
        }
    }
}

