/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.gpx.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.gpx.model.AbstractGpxParser;
import org.h2gis.functions.io.gpx.model.AbstractGpxParserRte;
import org.h2gis.functions.io.gpx.model.AbstractGpxParserTrk;
import org.h2gis.functions.io.gpx.model.AbstractGpxParserWpt;
import org.h2gis.functions.io.gpx.model.GPXTablesFactory;
import org.h2gis.functions.io.gpx.model.GPXTags;
import org.h2gis.functions.io.gpx.model.GpxPreparser;
import org.h2gis.functions.io.gpx.model.StringStack;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractGpxParserDefault
extends AbstractGpxParser {
    private final Connection connection;
    private final File fileName;
    private final String encoding;
    private final boolean deleteTable;
    private AbstractGpxParserWpt wptParser;
    private AbstractGpxParserRte rteParser;
    private AbstractGpxParserTrk trkParser;
    private double minLat;
    private double maxLat;
    private double minLon;
    private double maxLon;
    private String creator;
    private String version;
    private String name;
    private String desc;
    private String link;
    private String linkText;
    private String time;
    private String authorName;
    private String email;
    private String authorLink;
    private String authorLinkText;
    private String keywords;
    public static final int STRINGSTACK_SIZE = 50;

    public AbstractGpxParserDefault(Connection connection, File fileName, String encoding, boolean deleteTable) {
        this.connection = connection;
        this.fileName = fileName;
        this.encoding = encoding;
        this.deleteTable = deleteTable;
    }

    public void clear() {
        this.setElementNames(new StringStack(50));
        this.setContentBuffer(new StringBuilder());
        this.setSpecificElement(false);
        this.minLat = 0.0;
        this.maxLat = 0.0;
        this.minLon = 0.0;
        this.maxLon = 0.0;
        this.creator = null;
        this.version = null;
        this.name = null;
        this.desc = null;
        this.link = null;
        this.linkText = null;
        this.time = null;
        this.authorName = null;
        this.email = null;
        this.authorLink = null;
        this.authorLinkText = null;
        this.keywords = null;
    }

    abstract String getCopyright();

    public String[] read(String tableName, ProgressVisitor progress) throws SQLException, FileNotFoundException {
        if (FileUtilities.isFileImportable((File)this.fileName, (String)"gpx")) {
            DBTypes dbType = DBUtils.getDBType((Connection)this.connection);
            ArrayList<Object> tableNames = new ArrayList<Object>();
            TableLocation requestedTable = TableLocation.parse((String)tableName, (DBTypes)dbType);
            if (this.deleteTable) {
                GPXTablesFactory.dropOSMTables(this.connection, requestedTable);
            }
            if (this.fileName.length() == 0L) {
                String outputEmptyTable = requestedTable.toString();
                JDBCUtilities.createEmptyTable((Connection)this.connection, (String)outputEmptyTable);
                tableNames.add(outputEmptyTable);
            } else {
                String[] trackTableName;
                String table = requestedTable.getTable();
                this.clear();
                GpxPreparser gpxPreparser = new GpxPreparser();
                try {
                    gpxPreparser.read(this.fileName, this.encoding);
                }
                catch (SAXException ex) {
                    throw new SQLException(ex);
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
                if (gpxPreparser.getTotalWpt() > 0) {
                    String wptTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(table + "_waypoint"), (DBTypes)dbType);
                    if (JDBCUtilities.tableExists((Connection)this.connection, (TableLocation)TableLocation.parse((String)wptTableName, (DBTypes)dbType))) {
                        throw new SQLException("The table " + wptTableName + " already exists.");
                    }
                    this.setWptPreparedStmt(GPXTablesFactory.createWayPointsTable(this.connection, wptTableName));
                    tableNames.add(wptTableName);
                }
                if (gpxPreparser.getTotalRte() > 0 && gpxPreparser.getTotalRtept() > 0) {
                    String routeTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(table + "_route"), (DBTypes)dbType);
                    if (JDBCUtilities.tableExists((Connection)this.connection, (TableLocation)TableLocation.parse((String)routeTableName, (DBTypes)dbType))) {
                        throw new SQLException("The table " + routeTableName + " already exists.");
                    }
                    String routePointsTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(table + "_routepoint"), (DBTypes)dbType);
                    if (JDBCUtilities.tableExists((Connection)this.connection, (TableLocation)TableLocation.parse((String)routePointsTableName, (DBTypes)dbType))) {
                        throw new SQLException("The table " + routePointsTableName + " already exists.");
                    }
                    this.setRtePreparedStmt(GPXTablesFactory.createRouteTable(this.connection, routeTableName));
                    this.setRteptPreparedStmt(GPXTablesFactory.createRoutePointsTable(this.connection, routePointsTableName));
                    tableNames.add(routeTableName);
                    tableNames.add(routePointsTableName);
                }
                if (gpxPreparser.getTotalTrk() > 0 && gpxPreparser.getTotalTrkseg() > 0 && gpxPreparser.getTotalTrkpt() > 0) {
                    trackTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(table + "_track"), (DBTypes)dbType);
                    if (JDBCUtilities.tableExists((Connection)this.connection, (TableLocation)TableLocation.parse((String)trackTableName, (DBTypes)dbType))) {
                        throw new SQLException("The table " + (String)trackTableName + " already exists.");
                    }
                    String trackSegmentsTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(table + "_tracksegment"), (DBTypes)dbType);
                    if (JDBCUtilities.tableExists((Connection)this.connection, (TableLocation)TableLocation.parse((String)trackSegmentsTableName, (DBTypes)dbType))) {
                        throw new SQLException("The table " + trackSegmentsTableName + " already exists.");
                    }
                    String trackPointsTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(table + "_trackpoint"), (DBTypes)dbType);
                    if (JDBCUtilities.tableExists((Connection)this.connection, (TableLocation)TableLocation.parse((String)trackPointsTableName, (DBTypes)dbType))) {
                        throw new SQLException("The table " + trackPointsTableName + " already exists.");
                    }
                    this.setTrkPreparedStmt(GPXTablesFactory.createTrackTable(this.connection, (String)trackTableName));
                    this.setTrkSegmentsPreparedStmt(GPXTablesFactory.createTrackSegmentsTable(this.connection, trackSegmentsTableName));
                    this.setTrkPointsPreparedStmt(GPXTablesFactory.createTrackPointsTable(this.connection, trackPointsTableName));
                    tableNames.add(trackTableName);
                    tableNames.add(trackSegmentsTableName);
                    tableNames.add(trackPointsTableName);
                }
                try {
                    this.setReader(XMLReaderFactory.createXMLReader());
                    this.getReader().setErrorHandler(this);
                    this.getReader().setContentHandler(this);
                    this.getReader().parse(new InputSource(new FileInputStream(this.fileName)));
                    trackTableName = tableNames.toArray(new String[0]);
                    return trackTableName;
                }
                catch (SAXException ex) {
                    throw new SQLException(ex);
                }
                catch (IOException ex) {
                    throw new SQLException("Cannot parse the file " + this.fileName.getAbsolutePath(), ex);
                }
                finally {
                    if (this.getWptPreparedStmt() != null) {
                        this.getWptPreparedStmt().close();
                    }
                    if (this.getRteptPreparedStmt() != null) {
                        this.getRtePreparedStmt().close();
                        this.getRteptPreparedStmt().close();
                    }
                    if (this.getTrkPointsPreparedStmt() != null) {
                        this.getTrkPreparedStmt().close();
                        this.getTrkSegmentsPreparedStmt().close();
                        this.getTrkPointsPreparedStmt().close();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.compareToIgnoreCase(GPXTags.GPX) == 0) {
            this.version = attributes.getValue(GPXTags.VERSION);
            this.creator = attributes.getValue(GPXTags.CREATOR);
        } else if (localName.compareToIgnoreCase(GPXTags.BOUNDS) == 0) {
            this.minLat = Double.parseDouble(attributes.getValue(GPXTags.MINLAT));
            this.maxLat = Double.parseDouble(attributes.getValue(GPXTags.MAXLAT));
            this.minLon = Double.parseDouble(attributes.getValue(GPXTags.MINLON));
            this.maxLon = Double.parseDouble(attributes.getValue(GPXTags.MAXLON));
        }
        this.getContentBuffer().delete(0, this.getContentBuffer().length());
        this.getElementNames().push(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.setCurrentElement(this.getElementNames().pop());
        if (this.getCurrentElement().equalsIgnoreCase(GPXTags.WPT)) {
            this.setSpecificElement(false);
        } else if (this.getCurrentElement().equalsIgnoreCase(GPXTags.RTE)) {
            this.setSpecificElement(false);
        } else if (this.getCurrentElement().equalsIgnoreCase(GPXTags.TRK)) {
            this.setSpecificElement(false);
        } else if (this.getCurrentElement().equalsIgnoreCase(GPXTags.TIME) && !this.isSpecificElement()) {
            this.time = this.getContentBuffer().toString();
        } else if (this.getCurrentElement().equalsIgnoreCase(GPXTags.DESC) && !this.isSpecificElement()) {
            this.desc = this.getContentBuffer().toString();
        } else if (localName.equalsIgnoreCase(GPXTags.KEYWORDS)) {
            this.keywords = this.getContentBuffer().toString();
        }
    }

    public String getTime() {
        return this.time;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCreator() {
        return this.creator;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getFullLink() {
        return "Link : " + this.link + "\nText of hyperlink : " + this.linkText;
    }

    public String getFullAuthor() {
        return "Author : " + this.authorName + "\nEmail : " + this.email + "\nLink : " + this.authorLink + "\nText : " + this.authorLinkText;
    }

    public void setAuthorLink(String authorLink) {
        this.authorLink = authorLink;
    }

    public void setAuthorLinkText(String authorLinkText) {
        this.authorLinkText = authorLinkText;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractGpxParserWpt getWptParser() {
        return this.wptParser;
    }

    public void setWptParser(AbstractGpxParserWpt wptParser) {
        this.wptParser = wptParser;
    }

    public void setRteParser(AbstractGpxParserRte rteParser) {
        this.rteParser = rteParser;
    }

    public AbstractGpxParserRte getRteParser() {
        return this.rteParser;
    }

    public void setTrkParser(AbstractGpxParserTrk trkParser) {
        this.trkParser = trkParser;
    }

    public AbstractGpxParserTrk getTrkParser() {
        return this.trkParser;
    }
}

