/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueNull;
import org.h2gis.api.FileDriver;
import org.h2gis.functions.io.dbf.internal.DBFDriver;
import org.h2gis.functions.io.dbf.internal.DbaseFileHeader;
import org.h2gis.functions.io.shp.internal.IndexFile;
import org.h2gis.functions.io.shp.internal.ShapeType;
import org.h2gis.functions.io.shp.internal.ShapefileHeader;
import org.h2gis.functions.io.shp.internal.ShapefileReader;
import org.h2gis.functions.io.shp.internal.ShapefileWriter;
import org.locationtech.jts.geom.Geometry;

public class SHPDriver
implements FileDriver {
    private DBFDriver dbfDriver = new DBFDriver();
    public File shpFile;
    public File shxFile;
    public File dbfFile;
    private ShapefileReader shapefileReader;
    private ShapefileWriter shapefileWriter;
    private IndexFile shxFileReader;
    private int geometryFieldIndex = 0;
    private ShapeType shapeType;
    public File prjFile;
    private int srid = 0;

    public void setGeometryFieldIndex(int geometryFieldIndex) {
        this.geometryFieldIndex = geometryFieldIndex;
    }

    public void insertRow(Object[] values) throws IOException {
        Object geomValue = values[this.geometryFieldIndex];
        if (!(geomValue instanceof Geometry)) {
            if (geomValue == null) {
                throw new IOException("Shape files do not support NULL Geometry values.");
            }
            throw new IllegalArgumentException("Field at " + this.geometryFieldIndex + " should be an instance of Geometry, found " + geomValue.getClass() + " instead.");
        }
        this.shapefileWriter.writeGeometry((Geometry)geomValue);
        Object[] dbfValues = new Object[values.length - 1];
        if (this.geometryFieldIndex > 0) {
            System.arraycopy(values, 0, dbfValues, 0, this.geometryFieldIndex);
        }
        if (this.geometryFieldIndex + 1 < values.length) {
            System.arraycopy(values, this.geometryFieldIndex + 1, dbfValues, this.geometryFieldIndex, dbfValues.length - this.geometryFieldIndex);
        }
        this.dbfDriver.insertRow(dbfValues);
    }

    public int getGeometryFieldIndex() {
        return this.geometryFieldIndex;
    }

    public void initDriver(File shpFile, ShapeType shapeType, DbaseFileHeader dbaseHeader) throws IOException {
        String path = shpFile.getAbsolutePath();
        String nameWithoutExt = path.substring(0, path.lastIndexOf(46));
        this.shpFile = new File(nameWithoutExt + ".shp");
        this.shxFile = new File(nameWithoutExt + ".shx");
        this.dbfFile = new File(nameWithoutExt + ".dbf");
        FileOutputStream shpFos = new FileOutputStream(shpFile);
        FileOutputStream shxFos = new FileOutputStream(this.shxFile);
        this.shapefileWriter = new ShapefileWriter(shpFos.getChannel(), shxFos.getChannel());
        this.shapeType = shapeType;
        this.shapefileWriter.writeHeaders(shapeType);
        this.dbfDriver.initDriver(this.dbfFile, dbaseHeader);
    }

    public void initDriverFromFile(File shpFile) throws IOException {
        this.initDriverFromFile(shpFile, null);
    }

    public void initDriverFromFile(File shpFile, String forceEncoding) throws IOException {
        this.shpFile = shpFile;
        if (!shpFile.exists()) {
            throw new FileNotFoundException("The following file does not exists: " + shpFile.getPath());
        }
        String fileName = shpFile.getAbsolutePath();
        int dotIndex = fileName.lastIndexOf(46);
        final String fileNamePrefix = fileName.substring(0, dotIndex).toLowerCase();
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String path = entry.toAbsolutePath().toString().toLowerCase();
                if (path.equals(fileNamePrefix + ".shx")) {
                    SHPDriver.this.shxFile = entry.toFile();
                    return true;
                }
                if (path.equals(fileNamePrefix + ".dbf")) {
                    SHPDriver.this.dbfFile = entry.toFile();
                    return true;
                }
                if (path.equals(fileNamePrefix + ".prj")) {
                    SHPDriver.this.prjFile = entry.toFile();
                    return true;
                }
                return false;
            }
        };
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(shpFile.getParentFile().toPath(), (DirectoryStream.Filter<? super Path>)filter);){
            for (Path path : stream) {
            }
        }
        if (this.dbfFile == null) {
            throw new IllegalArgumentException("DBF File not found");
        }
        this.dbfDriver.initDriverFromFile(this.dbfFile, forceEncoding);
        if (this.shxFile == null) {
            throw new IllegalArgumentException("SHX File not found");
        }
        FileInputStream shpFis = new FileInputStream(shpFile);
        this.shapefileReader = new ShapefileReader(shpFis.getChannel());
        FileInputStream shxFis = new FileInputStream(this.shxFile);
        this.shxFileReader = new IndexFile(shxFis.getChannel());
    }

    public DbaseFileHeader getDbaseFileHeader() {
        return this.dbfDriver.getDbaseFileHeader();
    }

    public long getRowCount() {
        return this.dbfDriver.getRowCount();
    }

    public ShapefileHeader getShapeFileHeader() {
        return this.shapefileReader.getHeader();
    }

    public void close() throws IOException {
        this.dbfDriver.close();
        if (this.shapefileReader != null) {
            this.shapefileReader.close();
            this.shxFileReader.close();
        } else if (this.shapefileWriter != null) {
            this.shapefileWriter.writeHeaders(this.shapeType);
            this.shapefileWriter.close();
        }
    }

    public int getFieldCount() {
        return this.dbfDriver.getFieldCount() + 1;
    }

    public int getEstimatedRowSize(long rowId) {
        int totalSize = 0;
        totalSize += this.dbfDriver.getEstimatedRowSize(rowId);
        try {
            totalSize += this.shxFileReader.getContentLength((int)rowId);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return totalSize;
    }

    public Value getField(long rowId, int column) throws IOException {
        if (column == this.geometryFieldIndex) {
            Geometry geom = this.shapefileReader.geomAt(this.shxFileReader.getOffset((int)rowId));
            if (geom != null) {
                geom.setSRID(this.getSrid());
                return ValueGeometry.getFromGeometry((Object)geom);
            }
            return ValueNull.INSTANCE;
        }
        if (this.geometryFieldIndex < column) {
            return this.dbfDriver.getDbaseFileReader().getFieldValue((int)rowId, column - 1);
        }
        return this.dbfDriver.getDbaseFileReader().getFieldValue((int)rowId, column);
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    public int getSrid() {
        return this.srid;
    }
}

