/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.tsv;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.tsv.TSVDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class TSVWrite
extends AbstractFunction
implements ScalarFunction {
    public TSVWrite() {
        this.addProperty("remarks", "Write a Tab-separated values file.\n TSVWrite(...\n Supported arguments :\n path of the file, table name\n path of the file, table name, true to delete the file if exists\n path of the file, table name, encoding chartset\n path of the file, table name, encoding chartset, true to delete the file if exists");
    }

    public String getJavaStaticMethod() {
        return "exportTable";
    }

    public static void exportTable(Connection connection, String fileName, String tableReference) throws SQLException, IOException {
        TSVWrite.exportTable(connection, fileName, tableReference, null, false);
    }

    public static void exportTable(Connection connection, String fileName, String tableReference, Value option) throws IOException, SQLException {
        String encoding = null;
        boolean deleteFiles = false;
        if (option instanceof ValueBoolean) {
            deleteFiles = option.getBoolean();
        } else if (option instanceof ValueVarchar) {
            encoding = option.toString();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
        TSVWrite.exportTable(connection, fileName, tableReference, encoding, deleteFiles);
    }

    public static void exportTable(Connection connection, String fileName, String tableReference, String encoding, boolean deleteFile) throws SQLException, IOException {
        TSVDriverFunction tSVDriverFunction = new TSVDriverFunction();
        tSVDriverFunction.exportTable(connection, tableReference, URIUtilities.fileFromString((String)fileName), encoding, deleteFile, (ProgressVisitor)new EmptyProgressVisitor());
    }
}

