/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.aggregate;

import java.sql.SQLException;
import java.util.Collection;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.linemerge.LineMerger;

public class ST_LineMerge
extends DeterministicScalarFunction {
    public ST_LineMerge() {
        this.addProperty("remarks", "Merges a collection of LineString elements in order to make create a new collection of maximal-length linestrings. If you provide something else than (multi)linestrings it returns an empty multilinestring");
    }

    public String getJavaStaticMethod() {
        return "merge";
    }

    public static Geometry merge(Geometry geometry) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (geometry.getDimension() != 1) {
            return geometry.getFactory().createMultiLineString(new LineString[0]);
        }
        LineMerger lineMerger = new LineMerger();
        lineMerger.add(geometry);
        Collection coll = lineMerger.getMergedLineStrings();
        return geometry.getFactory().createMultiLineString(coll.toArray(new LineString[0]));
    }
}

