/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;

public class ST_AddZ
extends DeterministicScalarFunction {
    public ST_AddZ() {
        this.addProperty("remarks", "This function do a sum with the z value of (each vertex of) the\n geometric parameter to the corresponding value given by a field.");
    }

    public String getJavaStaticMethod() {
        return "addZ";
    }

    public static Geometry addZ(Geometry geometry, double z) throws SQLException {
        if (geometry == null) {
            return null;
        }
        geometry.apply((CoordinateSequenceFilter)new AddZCoordinateSequenceFilter(z));
        return geometry;
    }

    public static class AddZCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private boolean done = false;
        private final double z;

        public AddZCoordinateSequenceFilter(double z) {
            this.z = z;
        }

        public boolean isGeometryChanged() {
            return true;
        }

        public boolean isDone() {
            return this.done;
        }

        public void filter(CoordinateSequence seq, int i) {
            Coordinate coord = seq.getCoordinate(i);
            double currentZ = coord.z;
            if (!Double.isNaN(currentZ)) {
                seq.setOrdinate(i, 2, currentZ + this.z);
            }
            if (i == seq.size()) {
                this.done = true;
            }
        }
    }
}

