/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;

public class ST_CollectionExtract
extends DeterministicScalarFunction {
    public ST_CollectionExtract() {
        this.addProperty("remarks", "Given a (multi)geometry, returns a (multi)geometry consisting only of elements of the specified dimension.\nDimension numbers are 1 == POINT, 2 == LINESTRING, 3 == POLYGON");
    }

    public String getJavaStaticMethod() {
        return "collectionExtract";
    }

    public static Geometry collectionExtract(Geometry geometry, int dimension) throws ParseException {
        if (geometry == null) {
            return null;
        }
        if (dimension < 1 || dimension > 3) {
            throw new IllegalArgumentException("Dimension out of range (1..3)");
        }
        if (dimension == 1) {
            ArrayList<Point> points = new ArrayList<Point>();
            ST_CollectionExtract.getPunctualGeometry(points, geometry);
            if (points.isEmpty()) {
                return geometry.getFactory().buildGeometry(points);
            }
            if (points.size() == 1) {
                return (Geometry)points.get(0);
            }
            return geometry.getFactory().createMultiPoint(points.toArray(new Point[0]));
        }
        if (dimension == 2) {
            ArrayList<LineString> lines = new ArrayList<LineString>();
            ST_CollectionExtract.getLinealGeometry(lines, geometry);
            if (lines.isEmpty()) {
                return geometry.getFactory().buildGeometry(lines);
            }
            if (lines.size() == 1) {
                return (Geometry)lines.get(0);
            }
            return geometry.getFactory().createMultiLineString(lines.toArray(new LineString[0]));
        }
        if (dimension == 3) {
            ArrayList<Polygon> polygones = new ArrayList<Polygon>();
            ST_CollectionExtract.getArealGeometry(polygones, geometry);
            if (polygones.isEmpty()) {
                return geometry.getFactory().buildGeometry(polygones);
            }
            if (polygones.size() == 1) {
                return (Geometry)polygones.get(0);
            }
            return geometry.getFactory().createMultiPolygon(polygones.toArray(new Polygon[0]));
        }
        return null;
    }

    private static void getPunctualGeometry(ArrayList<Point> points, Geometry geometry) {
        int size = geometry.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry subGeom = geometry.getGeometryN(i);
            if (subGeom instanceof Point) {
                points.add((Point)subGeom);
                continue;
            }
            if (!(subGeom instanceof GeometryCollection)) continue;
            ST_CollectionExtract.getPunctualGeometry(points, subGeom);
        }
    }

    private static void getLinealGeometry(ArrayList<LineString> lines, Geometry geometry) {
        int size = geometry.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry subGeom = geometry.getGeometryN(i);
            if (subGeom instanceof LineString) {
                lines.add((LineString)subGeom);
                continue;
            }
            if (!(subGeom instanceof GeometryCollection)) continue;
            ST_CollectionExtract.getLinealGeometry(lines, subGeom);
        }
    }

    private static void getArealGeometry(ArrayList<Polygon> polygones, Geometry geometry) {
        int size = geometry.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry subGeom = geometry.getGeometryN(i);
            if (subGeom instanceof Polygon) {
                polygones.add((Polygon)subGeom);
                continue;
            }
            if (!(subGeom instanceof GeometryCollection)) continue;
            ST_CollectionExtract.getArealGeometry(polygones, subGeom);
        }
    }
}

