/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;

public class ST_Reverse
extends DeterministicScalarFunction {
    public ST_Reverse() {
        this.addProperty("remarks", "Returns the geometry with vertex order reversed.");
    }

    public String getJavaStaticMethod() {
        return "reverse";
    }

    public static Geometry reverse(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof MultiPoint) {
            return ST_Reverse.reverseMultiPoint((MultiPoint)geometry);
        }
        return geometry.reverse();
    }

    public static Geometry reverseMultiPoint(MultiPoint mp) {
        int nPoints = mp.getNumGeometries();
        Point[] revPoints = new Point[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            revPoints[nPoints - 1 - i] = (Point)mp.getGeometryN(i).reverse();
        }
        return mp.getFactory().createMultiPoint(revPoints);
    }
}

