/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import java.sql.Connection;
import java.sql.SQLException;
import org.cts.CRSFactory;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.registry.Registry;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.crs.SpatialRefRegistry;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ST_DistanceSphere
extends DeterministicScalarFunction {
    private static CRSFactory crsf;
    private static SpatialRefRegistry srr;

    public ST_DistanceSphere() {
        this.addProperty("remarks", "Returns minimum distance in meters between two lon/lat points. Uses a spherical earth and radius derived from the spheroid defined by the SRID");
    }

    public String getJavaStaticMethod() {
        return "distanceSphere";
    }

    public static Double distanceSphere(Connection connection, Geometry a, Geometry b) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        if (a.getSRID() != b.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        if (crsf == null) {
            crsf = new CRSFactory();
            crsf.getRegistryManager().addRegistry((Registry)srr);
        }
        srr.setConnection(connection);
        try {
            CoordinateReferenceSystem crs;
            int srid = a.getSRID();
            if (srid <= 0) {
                srid = 4326;
            }
            if (!CoordinateReferenceSystem.Type.GEOGRAPHIC2D.equals((Object)(crs = crsf.getCRS(srr.getRegistryName() + ":" + srid)).getType())) {
                throw new SQLException("ERROR: only lon/lag coordinate system are supported in geography");
            }
            Double radius = (2.0 * crs.getDatum().getEllipsoid().getSemiMajorAxis() + crs.getDatum().getEllipsoid().getSemiMinorAxis()) / 3.0;
            Double distance = ST_DistanceSphere.distanceBetweenTwoGeometries(a, b);
            if (distance < 0.0) {
                Double d = null;
                return d;
            }
            Double d = distance * radius;
            return d;
        }
        catch (CRSException e) {
            throw new SQLException("Cannot find SRID", e);
        }
        finally {
            srr.setConnection(null);
        }
    }

    private static Double distanceBetweenTwoGeometries(Geometry g1, Geometry g2) {
        if (g1 instanceof Point && g2 instanceof Point) {
            return ST_DistanceSphere.distancePointToPoint((Point)g1, (Point)g2);
        }
        if (g1 instanceof Point && g2 instanceof LineString || g2 instanceof Point && g1 instanceof LineString) {
            return ST_DistanceSphere.distancePointLine(g1, g2);
        }
        if (g1 instanceof LineString && g2 instanceof LineString) {
            return ST_DistanceSphere.distanceLineLine(g1, g2);
        }
        if (g1 instanceof Point && g2 instanceof Polygon || g2 instanceof Point && g1 instanceof Polygon) {
            return ST_DistanceSphere.distancePointPolygon(g1, g2);
        }
        if (g1 instanceof Polygon && g2 instanceof LineString || g2 instanceof Polygon && g1 instanceof LineString) {
            return ST_DistanceSphere.distancePolygonLineString(g1, g2);
        }
        if (g1 instanceof Polygon && g2 instanceof Polygon) {
            return ST_DistanceSphere.distancePolygonPolygon(g1, g2);
        }
        if (g1 instanceof GeometryCollection) {
            return ST_DistanceSphere.distanceGeometryCollection(g1, g2);
        }
        if (g2 instanceof GeometryCollection) {
            return ST_DistanceSphere.distanceGeometryCollection(g1, g2);
        }
        return -1.0;
    }

    private static Double distanceLineLine(Geometry g1, Geometry g2) {
        Double distance = Double.MAX_VALUE;
        for (int i = 0; i < g1.getNumPoints(); ++i) {
            for (int j = 0; j < g2.getNumPoints(); ++j) {
                Double distancePoint = ST_DistanceSphere.distancePointToPoint(((LineString)g1).getPointN(i), ((LineString)g2).getPointN(j));
                if (!(distancePoint < distance)) continue;
                distance = distancePoint;
            }
        }
        return distance;
    }

    private static Double distancePointPolygon(Geometry g1, Geometry g2) {
        Polygon polygon;
        Point point;
        Double distance = Double.MAX_VALUE;
        if (g1 instanceof Polygon) {
            point = (Point)g2;
            polygon = (Polygon)g1;
        } else {
            point = (Point)g1;
            polygon = (Polygon)g2;
        }
        if (polygon.covers((Geometry)point)) {
            return 0.0;
        }
        for (int i = 0; i < polygon.getExteriorRing().getNumPoints(); ++i) {
            Double ringDistance = ST_DistanceSphere.distancePointToPoint(polygon.getExteriorRing().getPointN(i), point);
            if (!(ringDistance < distance)) continue;
            distance = ringDistance;
        }
        return distance;
    }

    private static Double distancePolygonPolygon(Geometry g1, Geometry g2) {
        Double distance = Double.MAX_VALUE;
        if (g1.covers(g2) || g2.covers(g1)) {
            return 0.0;
        }
        for (int i = 0; i < ((Polygon)g1).getExteriorRing().getNumPoints(); ++i) {
            for (int j = 0; j < ((Polygon)g2).getExteriorRing().getNumPoints(); ++j) {
                Double ringDistance = ST_DistanceSphere.distancePointToPoint(((Polygon)g1).getExteriorRing().getPointN(i), ((Polygon)g2).getExteriorRing().getPointN(j));
                if (!(ringDistance < distance)) continue;
                distance = ringDistance;
            }
        }
        return distance;
    }

    private static Double distanceGeometryCollection(Geometry g1, Geometry g2) {
        Double distance = Double.MAX_VALUE;
        for (int i = 0; i < g2.getNumGeometries(); ++i) {
            Double geomDistance = ST_DistanceSphere.distanceBetweenTwoGeometries(g1, g2.getGeometryN(i));
            if (!(geomDistance < distance)) continue;
            distance = geomDistance;
        }
        return distance;
    }

    private static Double distancePolygonLineString(Geometry g1, Geometry g2) {
        Polygon polygon;
        LineString lineString;
        Double distance = Double.MAX_VALUE;
        if (g1 instanceof Polygon) {
            lineString = (LineString)g2;
            polygon = (Polygon)g1;
        } else {
            lineString = (LineString)g1;
            polygon = (Polygon)g2;
        }
        for (int i = 0; i < polygon.getExteriorRing().getNumPoints(); ++i) {
            Double ringDistance = ST_DistanceSphere.distancePointLine((Geometry)polygon.getExteriorRing().getPointN(i), (Geometry)lineString);
            if (!(ringDistance < distance)) continue;
            distance = ringDistance;
        }
        return distance;
    }

    private static Double distancePointLine(Geometry g1, Geometry g2) {
        LineString lineString;
        Point point;
        Double distance = Double.MAX_VALUE;
        if (g1 instanceof Point) {
            point = (Point)g1;
            lineString = (LineString)g2;
        } else {
            point = (Point)g2;
            lineString = (LineString)g1;
        }
        for (int i = 0; i < lineString.getNumPoints(); ++i) {
            Double distancePoint = ST_DistanceSphere.distancePointToPoint(point, lineString.getPointN(i));
            if (!(distancePoint < distance)) continue;
            distance = distancePoint;
        }
        return distance;
    }

    private static Double distancePointToPoint(Point p1, Point p2) {
        Double p1X = ST_DistanceSphere.longitudeRadiansNormalize(Math.toRadians(p1.getX()));
        Double p1Y = ST_DistanceSphere.latitudeRadiansNormalize(Math.toRadians(p1.getY()));
        Double p2X = ST_DistanceSphere.longitudeRadiansNormalize(Math.toRadians(p2.getX()));
        Double p2Y = ST_DistanceSphere.latitudeRadiansNormalize(Math.toRadians(p2.getY()));
        Double dLon = p2X - p1X;
        Double cosDLon = Math.cos(dLon);
        Double cosLatP2 = Math.cos(p2Y);
        Double sinLatP2 = Math.sin(p2Y);
        Double cosLatP1 = Math.cos(p1Y);
        Double sinLatP1 = Math.sin(p1Y);
        Double a1 = Math.pow(cosLatP2 * Math.sin(dLon), 2.0);
        Double a2 = Math.pow(cosLatP1 * sinLatP2 - sinLatP1 * cosLatP2 * cosDLon, 2.0);
        Double a = Math.sqrt(a1 + a2);
        Double b = sinLatP1 * sinLatP2 + cosLatP1 * cosLatP2 * cosDLon;
        return Math.atan2(a, b);
    }

    private static double longitudeRadiansNormalize(Double lon) {
        if (lon == -Math.PI) {
            lon = Math.PI;
        }
        if (lon == Math.PI * -2) {
            lon = 0.0;
        }
        if (lon > Math.PI * 2) {
            lon = lon % (Math.PI * 2);
        }
        if (lon < Math.PI * -2) {
            lon = lon % (Math.PI * -2);
        }
        if (lon > Math.PI) {
            lon = Math.PI * -2 + lon;
        }
        if (lon < -Math.PI) {
            lon = Math.PI * 2 + lon;
        }
        if (lon == Math.PI * -2) {
            lon = lon * -1.0;
        }
        return lon;
    }

    private static double latitudeRadiansNormalize(double lat) {
        if (lat > Math.PI * 2) {
            lat %= Math.PI * 2;
        }
        if (lat < Math.PI * -2) {
            lat %= Math.PI * -2;
        }
        if (lat > Math.PI) {
            lat = Math.PI - lat;
        }
        if (lat < -Math.PI) {
            lat = -Math.PI - lat;
        }
        if (lat > 1.5707963267948966) {
            lat = Math.PI - lat;
        }
        if (lat < -1.5707963267948966) {
            lat = -Math.PI - lat;
        }
        return lat;
    }

    static {
        srr = new SpatialRefRegistry();
    }
}

