/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.topography;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.topography.TINFeatureFactory;
import org.h2gis.utilities.jts_utils.TriMarkers;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.linemerge.LineMerger;

public class ST_Drape
extends DeterministicScalarFunction {
    public ST_Drape() {
        this.addProperty("remarks", "This function drapes an input geometry to a set of triangles.\nNotes : The supported input geometry types are POINT, MULTIPOINT, LINESTRING, MULTILINESTRING, POLYGON and MULTIPOLYGON \nIn case of 1 or 2 dimension, the input geometry is intersected with the triangles to perform a full draping.\nIf a point lies on two triangles the z value of the first triangle is kept.\nA zero value is set to the z ordinate when the point is outside a triangle.\nInput triangles must be passed using a POLYGON Z form.");
    }

    public String getJavaStaticMethod() {
        return "drape";
    }

    public static Geometry drape(Geometry geomToDrape, Geometry triangles) throws SQLException {
        if (geomToDrape == null) {
            return null;
        }
        if (triangles == null) {
            return geomToDrape;
        }
        if (geomToDrape.getSRID() != triangles.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        int nb = triangles.getNumGeometries();
        STRtree sTRtree = new STRtree();
        for (int i = 0; i < nb; ++i) {
            Geometry geom = triangles.getGeometryN(i);
            sTRtree.insert(geom.getEnvelopeInternal(), (Object)TINFeatureFactory.createTriangle(geom));
        }
        if (geomToDrape instanceof Point) {
            return ST_Drape.drapePoint(geomToDrape, triangles, sTRtree);
        }
        if (geomToDrape instanceof MultiPoint) {
            return ST_Drape.drapePoints(geomToDrape, triangles, sTRtree);
        }
        if (geomToDrape instanceof MultiLineString) {
            return ST_Drape.drapeMultiLineString((MultiLineString)geomToDrape, triangles, sTRtree);
        }
        if (geomToDrape instanceof MultiPolygon) {
            return ST_Drape.drapeMultiPolygon((MultiPolygon)geomToDrape, triangles, sTRtree);
        }
        if (geomToDrape instanceof Polygon) {
            return ST_Drape.drapePolygon((Polygon)geomToDrape, triangles, sTRtree);
        }
        if (geomToDrape instanceof LineString) {
            return ST_Drape.drapeLineString((LineString)geomToDrape, triangles, sTRtree);
        }
        throw new SQLException("Drape " + geomToDrape.getGeometryType() + " is not supported.");
    }

    public static Geometry drapePoints(Geometry pts, Geometry triangles, STRtree sTRtree) {
        GeometryFactory factory = pts.getFactory();
        int nbPts = pts.getNumGeometries();
        Point[] points = new Point[nbPts];
        for (int i = 0; i < nbPts; ++i) {
            points[i] = factory.createPoint((CoordinateSequence)ST_Drape.updateCoordinates(((Point)pts.getGeometryN(i)).getCoordinateSequence(), sTRtree));
        }
        return factory.createMultiPoint(points);
    }

    public static Geometry drapePoint(Geometry pts, Geometry triangles, STRtree sTRtree) {
        GeometryFactory factory = pts.getFactory();
        return factory.createPoint((CoordinateSequence)ST_Drape.updateCoordinates(((Point)pts).getCoordinateSequence(), sTRtree));
    }

    public static Geometry drapeMultiPolygon(MultiPolygon polygons, Geometry triangles, STRtree sTRtree) {
        GeometryFactory factory = polygons.getFactory();
        Geometry triangleLines = LinearComponentExtracter.getGeometry((Geometry)triangles, (boolean)true);
        int nbPolygons = polygons.getNumGeometries();
        Polygon[] polygonsDiff = new Polygon[nbPolygons];
        for (int i = 0; i < nbPolygons; ++i) {
            polygonsDiff[i] = ST_Drape.processPolygon((Polygon)polygons.getGeometryN(i), triangleLines, factory, sTRtree);
        }
        return factory.createMultiPolygon(polygonsDiff);
    }

    public static Geometry drapeMultiLineString(MultiLineString lines, Geometry triangles, STRtree sTRtree) {
        GeometryFactory factory = lines.getFactory();
        Geometry triangleLines = LinearComponentExtracter.getGeometry((Geometry)triangles, (boolean)true);
        int nbLines = lines.getNumGeometries();
        LineString[] lineStrings = new LineString[nbLines];
        for (int i = 0; i < nbLines; ++i) {
            LineString lineDiff = (LineString)ST_Drape.lineMerge(lines.getGeometryN(i).difference(triangleLines), factory);
            lineStrings[i] = factory.createLineString((CoordinateSequence)ST_Drape.updateCoordinates(lineDiff.getCoordinateSequence(), sTRtree));
        }
        return factory.createMultiLineString(lineStrings);
    }

    public static Geometry drapeLineString(LineString line, Geometry triangles, STRtree sTRtree) {
        GeometryFactory factory = line.getFactory();
        Geometry triangleLines = LinearComponentExtracter.getGeometry((Geometry)triangles, (boolean)true);
        LineString diffExt = (LineString)ST_Drape.lineMerge(line.difference(triangleLines), factory);
        return factory.createLineString((CoordinateSequence)ST_Drape.updateCoordinates(diffExt.getCoordinateSequence(), sTRtree));
    }

    public static Polygon drapePolygon(Polygon p, Geometry triangles, STRtree sTRtree) {
        GeometryFactory factory = p.getFactory();
        Geometry triangleLines = LinearComponentExtracter.getGeometry((Geometry)triangles, (boolean)true);
        Polygon splittedP = ST_Drape.processPolygon(p, triangleLines, factory, sTRtree);
        return splittedP;
    }

    private static Polygon processPolygon(Polygon p, Geometry triangleLines, GeometryFactory factory, STRtree sTRtree) {
        Geometry diffExt = p.getExteriorRing().difference(triangleLines);
        int nbOfHoles = p.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            LinearRing hole = factory.createLinearRing(ST_Drape.lineMerge(p.getInteriorRingN(i).difference(triangleLines), factory).getCoordinates());
            holes[i] = factory.createLinearRing((CoordinateSequence)ST_Drape.updateCoordinates(hole.getCoordinateSequence(), sTRtree));
        }
        LinearRing shell = factory.createLinearRing(ST_Drape.lineMerge(diffExt, factory).getCoordinates());
        return factory.createPolygon(factory.createLinearRing((CoordinateSequence)ST_Drape.updateCoordinates(shell.getCoordinateSequence(), sTRtree)), holes);
    }

    public static Geometry lineMerge(Geometry geom, GeometryFactory factory) {
        LineMerger merger = new LineMerger();
        merger.add(geom);
        Collection lines = merger.getMergedLineStrings();
        return factory.buildGeometry(lines);
    }

    private static CoordinateArraySequence updateCoordinates(CoordinateSequence cs, STRtree indexedTriangles) {
        int updateDim = cs.getDimension();
        if (cs.getDimension() == 2) {
            updateDim = 3;
        }
        Coordinate[] coords = cs.toCoordinateArray();
        for (int i = 0; i < coords.length; ++i) {
            Coordinate coord = coords[i];
            List result = indexedTriangles.query(new Envelope(coord = new Coordinate(coord)));
            if (!result.isEmpty()) {
                double z = 0.0;
                for (Triangle triangle : result) {
                    if (!TriMarkers.intersects((Coordinate)coord, (Triangle)triangle)) continue;
                    z = triangle.interpolateZ(coord);
                    break;
                }
                coord.z = z;
                coords[i] = coord;
                continue;
            }
            coord.z = 0.0;
            coords[i] = coord;
        }
        return new CoordinateArraySequence(coords, updateDim);
    }
}

