/*
 * Copyright (c) OSGi Alliance (2017, 2018). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.osgi.service.cdi;

import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;

/**
 * Define the possible values for {@link ComponentTemplateDTO#type}.
 *
 * @author $Id: 0c3f0fac305ef99032a822bd3069c7c01b40d2fe $
 */
public enum ComponentType {
	/**
	 * The component is the <em>Container Component</em>.
	 */
	CONTAINER,
	/**
	 * The component is an <em>Single Component</em>.
	 */
	SINGLE,
	/**
	 * The component is an <em>Factory Component</em>.
	 */
	FACTORY
}
