/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.active.collection;

import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.bam.active.collection.ActiveCollection;
import org.overlord.bam.active.collection.ActiveCollectionListener;
import org.overlord.bam.active.collection.ActiveCollectionManager;
import org.overlord.bam.active.collection.ActiveCollectionSource;
import org.overlord.bam.active.collection.ActiveCollectionType;
import org.overlord.bam.active.collection.ActiveList;
import org.overlord.bam.active.collection.ActiveMap;
import org.overlord.bam.active.collection.predicate.Predicate;

public abstract class AbstractActiveCollectionManager
implements ActiveCollectionManager {
    private static final Logger LOG = Logger.getLogger(AbstractActiveCollectionManager.class.getName());
    private Map<String, ActiveCollection> _activeCollections = new HashMap<String, ActiveCollection>();
    private Map<String, SoftReference<ActiveCollection>> _derivedActiveCollections = new HashMap<String, SoftReference<ActiveCollection>>();
    private List<ActiveCollectionListener> _activeCollectionListeners = new ArrayList<ActiveCollectionListener>();
    private long _houseKeepingInterval = 10000L;
    private HouseKeeper _houseKeeper = null;

    public void init() {
        this._houseKeeper = new HouseKeeper();
    }

    public void close() {
        if (this._houseKeeper != null) {
            this._houseKeeper.cancel();
        }
    }

    @Override
    public void setHouseKeepingInterval(long interval) {
        this._houseKeepingInterval = interval;
    }

    @Override
    public long getHouseKeepingInterval() {
        return this._houseKeepingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ActiveCollectionSource acs) throws Exception {
        ActiveCollection ac = null;
        Object object = this._activeCollections;
        synchronized (object) {
            if (this._activeCollections.containsKey(acs.getName())) {
                throw new IllegalArgumentException("Active collection already exists for '" + acs.getName() + "'");
            }
            if (acs.getType() == ActiveCollectionType.List) {
                ActiveList list = new ActiveList(acs.getName(), acs.getItemExpiration(), acs.getMaxItems(), acs.getHighWaterMark());
                this._activeCollections.put(acs.getName(), list);
                acs.setActiveCollection(list);
                acs.init();
                LOG.info("Registered active collection for source '" + acs.getName() + "'");
                ac = list;
            } else if (acs.getType() == ActiveCollectionType.Map) {
                ActiveMap map = new ActiveMap(acs.getName(), acs.getItemExpiration(), acs.getMaxItems(), acs.getHighWaterMark());
                this._activeCollections.put(acs.getName(), map);
                acs.setActiveCollection(map);
                acs.init();
                LOG.info("Registered active collection for source '" + acs.getName() + "'");
                ac = map;
            } else {
                throw new IllegalArgumentException("Active collection type not currently supported");
            }
        }
        if (ac != null) {
            object = this._activeCollectionListeners;
            synchronized (object) {
                for (int i = 0; i < this._activeCollectionListeners.size(); ++i) {
                    this._activeCollectionListeners.get(i).registered(ac);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ActiveCollectionSource acs) throws Exception {
        Object object;
        if (acs.getActiveCollection() != null) {
            object = this._activeCollectionListeners;
            synchronized (object) {
                for (int i = 0; i < this._activeCollectionListeners.size(); ++i) {
                    this._activeCollectionListeners.get(i).unregistered(acs.getActiveCollection());
                }
            }
        }
        object = this._activeCollections;
        synchronized (object) {
            if (!this._activeCollections.containsKey(acs.getName())) {
                throw new IllegalArgumentException("Active collection '" + acs.getName() + "' is not registered");
            }
            acs.close();
            acs.setActiveCollection(null);
            this._activeCollections.remove(acs.getName());
            LOG.info("Unregistered active collection for source '" + acs.getName() + "'");
        }
    }

    @Override
    public ActiveCollection getActiveCollection(String name) {
        SoftReference<ActiveCollection> ref;
        ActiveCollection ret = this._activeCollections.get(name);
        if (ret == null && (ref = this._derivedActiveCollections.get(name)) != null) {
            ret = ref.get();
        }
        return ret;
    }

    @Override
    public Collection<ActiveCollection> getActiveCollections() {
        return this._activeCollections.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActiveCollection create(String name, ActiveCollection parent, Predicate predicate) {
        ActiveCollection ret = null;
        Map<String, SoftReference<ActiveCollection>> map = this._derivedActiveCollections;
        synchronized (map) {
            SoftReference<ActiveCollection> ref = this._derivedActiveCollections.get(name);
            if (ref != null && (ret = ref.get()) == null) {
                this._derivedActiveCollections.remove(name);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Removing soft reference to active collection '" + name + "'");
                }
            }
            if (ret == null) {
                ret = parent.derive(name, predicate);
                this._derivedActiveCollections.put(name, new SoftReference<ActiveCollection>(ret));
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Derived active collection '" + name + "' with predicate: " + predicate);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String name) {
        Map<String, SoftReference<ActiveCollection>> map = this._derivedActiveCollections;
        synchronized (map) {
            this._derivedActiveCollections.remove(name);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Removed derived active collection '" + name + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Running active collection cleanup ....");
        }
        Map<String, ActiveCollection> map = this._activeCollections;
        synchronized (map) {
            for (ActiveCollection ac : this._activeCollections.values()) {
                try {
                    ac.cleanup();
                }
                catch (Exception e) {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-3"), ac.getName()));
                }
                if (ac.getHighWaterMark() <= 0) continue;
                if (ac.getHighWaterMarkWarningIssued()) {
                    if (ac.getSize() >= ac.getHighWaterMark()) continue;
                    LOG.info("Active collection '" + ac.getName() + "' has returned below its high water mark (" + ac.getHighWaterMark() + ")");
                    ac.setHighWaterMarkWarningIssued(false);
                    continue;
                }
                if (ac.getSize() <= ac.getHighWaterMark()) continue;
                LOG.warning("Active collection '" + ac.getName() + "' has exceeded its high water mark (" + ac.getHighWaterMark() + ")");
                ac.setHighWaterMarkWarningIssued(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActiveCollectionListener(ActiveCollectionListener l) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Register active collection listener=" + l);
        }
        List<ActiveCollectionListener> list = this._activeCollectionListeners;
        synchronized (list) {
            this._activeCollectionListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActiveCollectionListener(ActiveCollectionListener l) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unregister active collection listener=" + l);
        }
        List<ActiveCollectionListener> list = this._activeCollectionListeners;
        synchronized (list) {
            this._activeCollectionListeners.remove(l);
        }
    }

    public class HouseKeeper
    extends TimerTask {
        private Timer _timer = new Timer();

        public HouseKeeper() {
            this._timer.scheduleAtFixedRate((TimerTask)this, AbstractActiveCollectionManager.this.getHouseKeepingInterval(), AbstractActiveCollectionManager.this.getHouseKeepingInterval());
        }

        @Override
        public void run() {
            AbstractActiveCollectionManager.this.cleanup();
        }
    }
}

