/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.active.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.overlord.bam.active.collection.ActiveChangeListener;
import org.overlord.bam.active.collection.ActiveCollectionMBean;
import org.overlord.bam.active.collection.QuerySpec;
import org.overlord.bam.active.collection.predicate.Predicate;

public abstract class ActiveCollection
implements ActiveCollectionMBean,
Iterable<Object> {
    private String _name = null;
    private List<ActiveChangeListener> _listeners = new ArrayList<ActiveChangeListener>();
    private ActiveCollectionAdapter _adapter = null;
    private long _itemExpiration = 0L;
    private int _maxItems = 0;
    private int _highWaterMark = 0;
    private boolean _highWaterMarkWarningIssued = false;

    public ActiveCollection(String name) {
        this._name = name;
    }

    public ActiveCollection(String name, long itemExpiration, int maxItems, int highWaterMark) {
        this._name = name;
        this._itemExpiration = itemExpiration;
        this._maxItems = maxItems;
        this._highWaterMark = highWaterMark;
    }

    protected ActiveCollection(String name, ActiveCollection parent, Predicate predicate) {
        this(name);
        this._adapter = new ActiveCollectionAdapter(parent, predicate);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public long getItemExpiration() {
        return this._itemExpiration;
    }

    protected void setItemExpiration(long expire) {
        this._itemExpiration = expire;
    }

    @Override
    public int getMaxItems() {
        return this._maxItems;
    }

    protected void setMaxItems(int max) {
        this._maxItems = max;
    }

    @Override
    public int getHighWaterMark() {
        return this._highWaterMark;
    }

    protected void setHighWaterMark(int highWaterMark) {
        this._highWaterMark = highWaterMark;
    }

    protected boolean getHighWaterMarkWarningIssued() {
        return this._highWaterMarkWarningIssued;
    }

    protected void setHighWaterMarkWarningIssued(boolean issued) {
        this._highWaterMarkWarningIssued = issued;
    }

    protected abstract void cleanup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveChangeListener(ActiveChangeListener l) {
        List<ActiveChangeListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveChangeListener(ActiveChangeListener l) {
        List<ActiveChangeListener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(l);
        }
    }

    public List<ActiveChangeListener> getActiveChangeListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    @Override
    public abstract int getSize();

    protected abstract void insert(Object var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inserted(Object key, Object value) {
        List<ActiveChangeListener> list = this._listeners;
        synchronized (list) {
            if (this._listeners.size() > 0) {
                for (ActiveChangeListener l : this._listeners) {
                    l.inserted(key, value);
                }
            }
        }
    }

    protected abstract void update(Object var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updated(Object key, Object value) {
        List<ActiveChangeListener> list = this._listeners;
        synchronized (list) {
            if (this._listeners.size() > 0) {
                for (ActiveChangeListener l : this._listeners) {
                    l.updated(key, value);
                }
            }
        }
    }

    protected abstract void remove(Object var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removed(Object key, Object value) {
        List<ActiveChangeListener> list = this._listeners;
        synchronized (list) {
            if (this._listeners.size() > 0) {
                for (ActiveChangeListener l : this._listeners) {
                    l.removed(key, value);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._adapter != null) {
            this._adapter.close();
        }
    }

    protected abstract ActiveCollection derive(String var1, Predicate var2);

    public abstract List<Object> query(QuerySpec var1);

    public class ActiveCollectionAdapter
    implements ActiveChangeListener {
        private ActiveCollection _parent = null;
        private Predicate _predicate = null;

        public ActiveCollectionAdapter(ActiveCollection parent, Predicate predicate) {
            this._parent = parent;
            this._predicate = predicate;
            this._parent.addActiveChangeListener(this);
        }

        @Override
        public void inserted(Object key, Object value) {
            if (this._predicate.evaluate(value)) {
                ActiveCollection.this.insert(key, value);
            }
        }

        @Override
        public void updated(Object key, Object value) {
            if (this._predicate.evaluate(value)) {
                ActiveCollection.this.update(key, value);
            }
        }

        @Override
        public void removed(Object key, Object value) {
            if (this._predicate.evaluate(value)) {
                ActiveCollection.this.remove(key, value);
            }
        }

        public void close() {
            this._parent.removeActiveChangeListener(this);
            this._parent = null;
        }
    }
}

