/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.active.collection.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.TypeReference;
import org.overlord.bam.active.collection.ActiveCollectionSource;
import org.overlord.bam.active.collection.QuerySpec;

public final class ActiveCollectionUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<List<ActiveCollectionSource>> TYPEREF = new TypeReference<List<ActiveCollectionSource>>(){};

    private ActiveCollectionUtil() {
    }

    public static byte[] serializeACS(List<ActiveCollectionSource> acs) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, acs);
        ret = baos.toByteArray();
        baos.close();
        return ret;
    }

    public static List<ActiveCollectionSource> deserializeACS(byte[] acs) throws Exception {
        List ret = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(acs);
        ret = (List)MAPPER.readValue((InputStream)bais, TYPEREF);
        bais.close();
        return ret;
    }

    public static byte[] serializeQuerySpec(QuerySpec qs) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, (Object)qs);
        ret = baos.toByteArray();
        baos.close();
        return ret;
    }

    public static QuerySpec deserializeQuerySpec(byte[] qs) throws Exception {
        QuerySpec ret = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(qs);
        ret = (QuerySpec)MAPPER.readValue((InputStream)bais, QuerySpec.class);
        bais.close();
        return ret;
    }

    static {
        SerializationConfig config = MAPPER.getSerializationConfig().with(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
        MAPPER.setSerializationConfig(config);
    }
}

