/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.epn.embedded;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.bam.epn.AbstractEPNManager;
import org.overlord.bam.epn.Channel;
import org.overlord.bam.epn.EPNContainer;
import org.overlord.bam.epn.EventList;
import org.overlord.bam.epn.Network;
import org.overlord.bam.epn.Node;
import org.overlord.bam.epn.NotificationType;

public class EmbeddedEPNManager
extends AbstractEPNManager {
    private static final Logger LOG = Logger.getLogger(EmbeddedEPNManager.class.getName());
    private static final int MAX_THREADS = 10;
    private ExecutorService _executor = Executors.newFixedThreadPool(10);
    private EPNContainer _container = new EmbeddedEPNContainer();
    private Map<String, List<EmbeddedChannel>> _entryPoints = new HashMap<String, List<EmbeddedChannel>>();

    protected EPNContainer getContainer() {
        return this._container;
    }

    protected Map<String, List<EmbeddedChannel>> getEntryPoints() {
        return this._entryPoints;
    }

    protected void currentNetworkChanged(Network oldNet, Network newNet) {
        super.currentNetworkChanged(oldNet, newNet);
        if (oldNet != null) {
            this.unregisterEntryPoints(oldNet);
        }
        if (newNet != null) {
            this.registerEntryPoints(newNet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterEntryPoints(Network network) {
        Map<String, List<EmbeddedChannel>> map = this._entryPoints;
        synchronized (map) {
            block3: for (String subject : network.subjects()) {
                List<EmbeddedChannel> channels = this._entryPoints.get(subject);
                if (channels == null) continue;
                for (EmbeddedChannel ch : channels) {
                    if (!ch.getNetworkName().equals(network.getName())) continue;
                    channels.remove(ch);
                    if (channels.size() != 0) continue block3;
                    this._entryPoints.remove(subject);
                    continue block3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerEntryPoints(Network network) {
        Map<String, List<EmbeddedChannel>> map = this._entryPoints;
        synchronized (map) {
            for (String subject : network.subjects()) {
                List nodes;
                List<EmbeddedChannel> channels = this._entryPoints.get(subject);
                if (channels == null) {
                    channels = new ArrayList<EmbeddedChannel>();
                    this._entryPoints.put(subject, channels);
                }
                if ((nodes = network.getNodesForSubject(subject)) == null) continue;
                for (Node node : nodes) {
                    channels.add(new EmbeddedChannel(network, node, null));
                }
            }
        }
    }

    public void publish(String subject, List<? extends Serializable> events) throws Exception {
        this.publish(subject, new EventList(events));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish(String subject, EventList events) throws Exception {
        Map<String, List<EmbeddedChannel>> map = this._entryPoints;
        synchronized (map) {
            List<EmbeddedChannel> channels = this._entryPoints.get(subject);
            if (channels != null) {
                for (EmbeddedChannel channel : channels) {
                    channel.send(events);
                }
            }
        }
    }

    public void close() throws Exception {
        this._executor.awaitTermination(5L, TimeUnit.SECONDS);
    }

    protected class EPNTask
    implements Runnable {
        private Network _network = null;
        private Node _node = null;
        private String _source = null;
        private EventList _events = null;
        private int _retriesLeft = 0;
        private EmbeddedChannel _channel = null;

        public EPNTask(Network network, Node node, String source, EventList events, int retriesLeft, EmbeddedChannel channel) {
            this._network = network;
            this._node = node;
            this._source = source;
            this._events = events;
            this._retriesLeft = retriesLeft;
            this._channel = channel;
        }

        @Override
        public void run() {
            EventList retries = null;
            try {
                retries = EmbeddedEPNManager.this.process(this._network, this._node, this._source, this._events, this._retriesLeft);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("epn-container-embedded.Messages").getString("EPN-CONTAINER-EMBEDDED-2"), e);
                retries = this._events;
            }
            if (retries != null) {
                if (this._retriesLeft > 0) {
                    try {
                        this._channel.send(retries, this._retriesLeft - 1);
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("epn-container-embedded.Messages").getString("EPN-CONTAINER-EMBEDDED-3"), e);
                    }
                } else {
                    LOG.severe(PropertyResourceBundle.getBundle("epn-container-embedded.Messages").getString("EPN-CONTAINER-EMBEDDED-4"));
                }
            }
        }
    }

    protected class EmbeddedChannel
    implements Channel {
        private Network _network = null;
        private Node _node = null;
        private String _source = null;
        private String _subject = null;
        private boolean _notification = false;

        public EmbeddedChannel(Network network, Node node, String source) {
            this._network = network;
            this._node = node;
            this._source = source;
        }

        public EmbeddedChannel(Network network, String subject) {
            this._network = network;
            this._subject = subject;
            this._notification = true;
            this._source = subject;
        }

        public EmbeddedChannel(String subject) {
            this._subject = subject;
            this._source = subject;
        }

        public boolean isNotificationChannel() {
            return this._notification;
        }

        protected String getNetworkName() {
            return this._network.getName();
        }

        protected String getVersion() {
            return this._network.getVersion();
        }

        protected String getNodeName() {
            return this._node.getName();
        }

        public void send(EventList events) throws Exception {
            if (this.isNotificationChannel()) {
                EmbeddedEPNManager.this.notifyListeners(this._subject, this._network.getName(), this._network.getVersion(), this._source, NotificationType.Results, events);
            } else {
                this.send(events, this._node.getMaxRetries());
            }
        }

        public void send(EventList events, int retriesLeft) throws Exception {
            if (this._subject != null) {
                EmbeddedEPNManager.this.publish(this._subject, events);
            } else {
                if (retriesLeft == -1) {
                    retriesLeft = this._node.getMaxRetries();
                }
                EmbeddedEPNManager.this._executor.execute(new EPNTask(this._network, this._node, this._source, events, retriesLeft, this));
            }
        }

        public void close() throws Exception {
        }
    }

    protected class EmbeddedEPNContainer
    implements EPNContainer {
        protected EmbeddedEPNContainer() {
        }

        public Channel getChannel(Network network, String source, String dest) throws Exception {
            return new EmbeddedChannel(network, network.getNode(dest), source);
        }

        public Channel getNotificationChannel(Network network, String subject) throws Exception {
            return new EmbeddedChannel(network, subject);
        }

        public Channel getChannel(String subject) throws Exception {
            return new EmbeddedChannel(subject);
        }

        public void send(EventList events, List<Channel> channels) throws Exception {
            for (Channel channel : channels) {
                if (channel instanceof EmbeddedChannel) {
                    ((EmbeddedChannel)channel).send(events);
                    continue;
                }
                LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("epn-container-embedded.Messages").getString("EPN-CONTAINER-EMBEDDED-1"), channel));
            }
        }
    }
}

