/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.config.configurator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.overlord.commons.config.configurator.Configurator;

public abstract class AbstractPropertiesFileConfigurator
implements Configurator {
    @Override
    public Configuration provideConfiguration(String configName, Long refreshDelay) throws ConfigurationException {
        URL url = this.findConfigUrl(configName);
        if (url != null) {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(url);
            FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
            fileChangedReloadingStrategy.setRefreshDelay(refreshDelay.longValue());
            propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
            return propertiesConfiguration;
        }
        return null;
    }

    protected abstract URL findConfigUrl(String var1);

    protected URL findConfigUrlInDirectory(File directory, String configName) {
        File cfile;
        if (directory.isDirectory() && (cfile = new File(directory, configName)).isFile()) {
            try {
                return cfile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

