/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.analytics.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.overlord.rtgov.analytics.service.InvocationMetric;

public class InvocationDefinition
implements Externalizable {
    private static final int VERSION = 1;
    private String _serviceType = null;
    private String _operation = null;
    private String _fault = null;
    private InvocationMetric _metrics = new InvocationMetric();

    public InvocationDefinition() {
    }

    public InvocationDefinition(InvocationDefinition id) {
        this._serviceType = id.getServiceType();
        this._operation = id.getOperation();
        this._fault = id.getFault();
        if (id.getMetrics() != null) {
            this._metrics = new InvocationMetric(id.getMetrics());
        }
    }

    public void setServiceType(String serviceType) {
        this._serviceType = serviceType;
    }

    public String getServiceType() {
        return this._serviceType;
    }

    public void setOperation(String operation) {
        this._operation = operation;
    }

    public String getOperation() {
        return this._operation;
    }

    public void setFault(String fault) {
        this._fault = fault;
    }

    public String getFault() {
        return this._fault;
    }

    public InvocationMetric getMetrics() {
        return this._metrics;
    }

    protected void setMetrics(InvocationMetric im) {
        this._metrics = im;
    }

    public void merge(InvocationDefinition id) {
        this.getMetrics().merge(id.getMetrics());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this._serviceType);
        out.writeObject(this._operation);
        out.writeObject(this._fault);
        out.writeObject(this._metrics);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._serviceType = (String)in.readObject();
        this._operation = (String)in.readObject();
        this._fault = (String)in.readObject();
        this._metrics = (InvocationMetric)in.readObject();
    }
}

