/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.analytics.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class InvocationMetric
implements Externalizable {
    private static final int VERSION = 1;
    private int _count = 0;
    private int _countChange = 0;
    private long _avg = 0L;
    private int _avgChange = 0;
    private long _max = 0L;
    private int _maxChange = 0;
    private long _min = 0L;
    private int _minChange = 0;

    public InvocationMetric() {
    }

    public InvocationMetric(InvocationMetric im) {
        this._count = im.getCount();
        this._countChange = im.getCountChange();
        this._avg = im.getAverage();
        this._avgChange = im.getAverageChange();
        this._min = im.getMin();
        this._minChange = im.getMinChange();
        this._max = im.getMax();
        this._maxChange = im.getMaxChange();
    }

    public InvocationMetric(List<InvocationMetric> metrics) {
        if (metrics.size() > 0) {
            for (InvocationMetric m : metrics) {
                if (m.getCount() <= 0) continue;
                this._count += m.getCount();
                this._countChange += m.getCountChange() * m.getCount();
                this._avg += m.getAverage() * (long)m.getCount();
                this._avgChange += m.getAverageChange() * m.getCount();
                if (m.getMax() > this._max) {
                    this._max = m.getMax();
                }
                this._maxChange += m.getMaxChange() * m.getCount();
                if (this._min == 0L || m.getMin() < this._min) {
                    this._min = m.getMin();
                }
                this._minChange += m.getMinChange() * m.getCount();
            }
            if (this._count != 0) {
                this._countChange /= this._count;
                this._avg /= (long)this._count;
                this._avgChange /= this._count;
                this._minChange /= this._count;
                this._maxChange /= this._count;
            }
        }
    }

    public void setCount(int count) {
        this._count = count;
    }

    public int getCount() {
        return this._count;
    }

    public void setAverage(long time) {
        this._avg = time;
    }

    public long getAverage() {
        return this._avg;
    }

    public void setMax(long time) {
        this._max = time;
    }

    public long getMax() {
        return this._max;
    }

    public void setMin(long time) {
        this._min = time;
    }

    public long getMin() {
        return this._min;
    }

    public void setCountChange(int change) {
        this._countChange = change;
    }

    public int getCountChange() {
        return this._countChange;
    }

    public void setAverageChange(int change) {
        this._avgChange = change;
    }

    public int getAverageChange() {
        return this._avgChange;
    }

    public void setMaxChange(int change) {
        this._maxChange = change;
    }

    public int getMaxChange() {
        return this._maxChange;
    }

    public void setMinChange(int change) {
        this._minChange = change;
    }

    public int getMinChange() {
        return this._minChange;
    }

    public void merge(InvocationMetric metric) {
        if (metric.getCount() > 0) {
            int myCount = this.getCount();
            int mergeCount = metric.getCount();
            this.setCount(myCount + mergeCount);
            this.setCountChange((this.getCountChange() * myCount + metric.getCountChange() * mergeCount) / this.getCount());
            this.setAverage((this.getAverage() * (long)myCount + metric.getAverage() * (long)mergeCount) / (long)this.getCount());
            this.setAverageChange((this.getAverageChange() * myCount + metric.getAverageChange() * mergeCount) / this.getCount());
            if (this.getMin() == 0L || metric.getMin() < this.getMin()) {
                this.setMin(metric.getMin());
            }
            this.setMinChange((this.getMinChange() * myCount + metric.getMinChange() * mergeCount) / this.getCount());
            if (metric.getMax() > this.getMax()) {
                this.setMax(metric.getMax());
            }
            this.setMaxChange((this.getMaxChange() * myCount + metric.getMaxChange() * mergeCount) / this.getCount());
        }
    }

    public String toString() {
        return "InvocationMetric[count=" + this._count + "(" + this._countChange + "%) average=" + this._avg + "(" + this._avgChange + "%) min=" + this._min + "(" + this._minChange + "%) max=" + this._max + "(" + this._maxChange + "%)]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeInt(this._count);
        out.writeInt(this._countChange);
        out.writeLong(this._avg);
        out.writeInt(this._avgChange);
        out.writeLong(this._max);
        out.writeInt(this._maxChange);
        out.writeLong(this._min);
        out.writeInt(this._minChange);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._count = in.readInt();
        this._countChange = in.readInt();
        this._avg = in.readLong();
        this._avgChange = in.readInt();
        this._max = in.readLong();
        this._maxChange = in.readInt();
        this._min = in.readLong();
        this._minChange = in.readInt();
    }
}

