/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.analytics.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.overlord.rtgov.analytics.service.InvocationMetric;
import org.overlord.rtgov.analytics.service.RequestFaultDefinition;
import org.overlord.rtgov.analytics.service.RequestResponseDefinition;

public class OperationDefinition
implements Externalizable {
    private static final int VERSION = 1;
    private String _name = null;
    private RequestResponseDefinition _requestResponse = null;
    private List<RequestFaultDefinition> _requestFaults = new ArrayList<RequestFaultDefinition>();

    public OperationDefinition() {
    }

    public OperationDefinition(OperationDefinition od) {
        this._name = od.getName();
        if (od.getRequestResponse() != null) {
            this._requestResponse = new RequestResponseDefinition(od.getRequestResponse());
        }
        for (RequestFaultDefinition rfd : od.getRequestFaults()) {
            this._requestFaults.add(new RequestFaultDefinition(rfd));
        }
    }

    public void setName(String operation) {
        this._name = operation;
    }

    public String getName() {
        return this._name;
    }

    public void setRequestResponse(RequestResponseDefinition response) {
        this._requestResponse = response;
    }

    public RequestResponseDefinition getRequestResponse() {
        return this._requestResponse;
    }

    public void setRequestFaults(List<RequestFaultDefinition> faults) {
        this._requestFaults = faults;
    }

    public List<RequestFaultDefinition> getRequestFaults() {
        return this._requestFaults;
    }

    public RequestFaultDefinition getRequestFault(String name) {
        RequestFaultDefinition ret = null;
        for (int i = 0; i < this._requestFaults.size(); ++i) {
            if (!this._requestFaults.get(i).getFault().equals(name)) continue;
            ret = this._requestFaults.get(i);
            break;
        }
        return ret;
    }

    public InvocationMetric getMetrics() {
        ArrayList<InvocationMetric> metrics = new ArrayList<InvocationMetric>();
        if (this.getRequestResponse() != null) {
            metrics.add(this.getRequestResponse().getMetrics());
        }
        for (RequestFaultDefinition fault : this.getRequestFaults()) {
            metrics.add(fault.getMetrics());
        }
        return new InvocationMetric(metrics);
    }

    public void merge(OperationDefinition opdef) {
        if (opdef.getRequestResponse() != null) {
            if (this.getRequestResponse() != null) {
                this.getRequestResponse().merge(opdef.getRequestResponse());
            } else {
                this.setRequestResponse(new RequestResponseDefinition(opdef.getRequestResponse()));
            }
        }
        for (int i = 0; i < opdef.getRequestFaults().size(); ++i) {
            RequestFaultDefinition rfd = opdef.getRequestFaults().get(i);
            RequestFaultDefinition cur = this.getRequestFault(rfd.getFault());
            if (cur != null) {
                cur.merge(rfd);
                continue;
            }
            this.getRequestFaults().add(new RequestFaultDefinition(rfd));
        }
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof OperationDefinition && ((OperationDefinition)obj).getName().equals(this._name);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this._name);
        out.writeObject(this._requestResponse);
        out.writeInt(this._requestFaults.size());
        for (int i = 0; i < this._requestFaults.size(); ++i) {
            out.writeObject(this._requestFaults.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._name = (String)in.readObject();
        this._requestResponse = (RequestResponseDefinition)in.readObject();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this._requestFaults.add((RequestFaultDefinition)in.readObject());
        }
    }
}

