/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.analytics.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.overlord.rtgov.activity.model.ActivityTypeId;
import org.overlord.rtgov.activity.model.Context;

public class ResponseTime
implements Externalizable {
    private static final int VERSION = 1;
    private String _serviceType = null;
    private String _operation = null;
    private String _fault = null;
    private long _avg = 0L;
    private long _max = 0L;
    private long _min = 0L;
    private long _timestamp = 0L;
    private ActivityTypeId _requestId = null;
    private ActivityTypeId _responseId = null;
    private Map<String, String> _properties = new HashMap<String, String>();
    private List<Context> _contexts = new ArrayList<Context>();

    public ResponseTime() {
    }

    public ResponseTime(ResponseTime rt) {
        this._serviceType = rt.getServiceType();
        this._operation = rt.getOperation();
        this._fault = rt.getFault();
        this._avg = rt.getAverage();
        this._max = rt.getMax();
        this._min = rt.getMin();
        this._timestamp = rt.getTimestamp();
        this._requestId = rt.getRequestId();
        this._responseId = rt.getResponseId();
        this._properties.putAll(rt.getProperties());
        this._contexts.addAll(rt.getContext());
    }

    public void setServiceType(String serviceType) {
        this._serviceType = serviceType;
    }

    public String getServiceType() {
        return this._serviceType;
    }

    public void setOperation(String operation) {
        this._operation = operation;
    }

    public String getOperation() {
        return this._operation;
    }

    public void setFault(String fault) {
        this._fault = fault;
    }

    public String getFault() {
        return this._fault;
    }

    public void setAverage(long average) {
        this._avg = average;
    }

    public long getAverage() {
        return this._avg;
    }

    public void setMax(long time) {
        this._max = time;
    }

    public long getMax() {
        return this._max;
    }

    public void setMin(long time) {
        this._min = time;
    }

    public long getMin() {
        return this._min;
    }

    public void setTimestamp(long time) {
        this._timestamp = time;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setRequestId(ActivityTypeId id) {
        this._requestId = id;
    }

    public ActivityTypeId getRequestId() {
        return this._requestId;
    }

    public void setResponseId(ActivityTypeId id) {
        this._responseId = id;
    }

    public ActivityTypeId getResponseId() {
        return this._responseId;
    }

    public void setProperties(Map<String, String> props) {
        this._properties = props;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public void setContext(List<Context> context) {
        this._contexts = context;
    }

    public List<Context> getContext() {
        return this._contexts;
    }

    public String toString() {
        return "ResponseTime[service=" + this._serviceType + " op=" + this._operation + " fault=" + this._fault + " duration=" + this._avg + " min=" + this._min + " max=" + this._max + " timestamp=" + this._timestamp + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this._serviceType);
        out.writeObject(this._operation);
        out.writeObject(this._fault);
        out.writeLong(this._avg);
        out.writeLong(this._max);
        out.writeLong(this._min);
        out.writeLong(this._timestamp);
        out.writeObject(this._requestId);
        out.writeObject(this._responseId);
        out.writeObject(this._properties);
        out.writeInt(this._contexts.size());
        for (int i = 0; i < this._contexts.size(); ++i) {
            out.writeObject(this._contexts.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._serviceType = (String)in.readObject();
        this._operation = (String)in.readObject();
        this._fault = (String)in.readObject();
        this._avg = in.readLong();
        this._max = in.readLong();
        this._min = in.readLong();
        this._timestamp = in.readLong();
        this._requestId = (ActivityTypeId)in.readObject();
        this._responseId = (ActivityTypeId)in.readObject();
        this._properties = (Map)in.readObject();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this._contexts.add((Context)in.readObject());
        }
    }
}

