/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.analytics.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.analytics.service.InvocationMetric;
import org.overlord.rtgov.analytics.service.OperationDefinition;
import org.overlord.rtgov.analytics.service.util.ServiceDefinitionUtil;

public class ServiceDefinition
implements Externalizable {
    private static final Logger LOG = Logger.getLogger(ServiceDefinition.class.getName());
    private static final int VERSION = 1;
    private String _serviceType = null;
    private List<OperationDefinition> _operations = new ArrayList<OperationDefinition>();
    private List<Context> _contexts = new Vector<Context>();

    public ServiceDefinition() {
    }

    public ServiceDefinition(ServiceDefinition sd) {
        this._serviceType = sd.getServiceType();
        for (OperationDefinition op : sd.getOperations()) {
            this._operations.add(new OperationDefinition(op));
        }
        for (Context c : sd.getContext()) {
            this._contexts.add(new Context(c));
        }
    }

    public void setServiceType(String serviceType) {
        this._serviceType = serviceType;
    }

    public String getServiceType() {
        return this._serviceType;
    }

    public void setOperations(List<OperationDefinition> operations) {
        this._operations = operations;
    }

    public List<OperationDefinition> getOperations() {
        return this._operations;
    }

    public OperationDefinition getOperation(String name) {
        OperationDefinition ret = null;
        for (int i = 0; i < this._operations.size(); ++i) {
            if (!this._operations.get(i).getName().equals(name)) continue;
            ret = this._operations.get(i);
            break;
        }
        return ret;
    }

    public void setContext(List<Context> context) {
        this._contexts = context;
    }

    public List<Context> getContext() {
        return this._contexts;
    }

    public InvocationMetric getMetrics() {
        ArrayList<InvocationMetric> metrics = new ArrayList<InvocationMetric>();
        for (OperationDefinition op : this.getOperations()) {
            metrics.add(op.getMetrics());
        }
        return new InvocationMetric(metrics);
    }

    public void merge(ServiceDefinition sd) throws Exception {
        this.merge(sd, false);
    }

    public void merge(ServiceDefinition sd, boolean retainContexts) throws Exception {
        if (sd == null || !sd.getServiceType().equals(this.getServiceType())) {
            throw new IllegalArgumentException("Invalid service definition");
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Pre-merge this=[" + this + "] with=[" + sd + "]");
        }
        for (int i = 0; i < sd.getOperations().size(); ++i) {
            OperationDefinition opdef = sd.getOperations().get(i);
            OperationDefinition cur = this.getOperation(opdef.getName());
            if (cur != null) {
                cur.merge(opdef);
                continue;
            }
            this.getOperations().add(new OperationDefinition(opdef));
        }
        if (retainContexts) {
            for (Context c : sd.getContext()) {
                if (this._contexts.contains(c)) continue;
                this._contexts.add(c);
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Post-merge this=[" + this + "]");
        }
    }

    public int hashCode() {
        return this._serviceType.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceDefinition && ((ServiceDefinition)obj).getServiceType().equals(this._serviceType);
    }

    public String toString() {
        String ret = null;
        try {
            ret = new String(ServiceDefinitionUtil.serializeServiceDefinition(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeInt(1);
        out.writeObject(this._serviceType);
        out.writeInt(this._operations.size());
        for (i = 0; i < this._operations.size(); ++i) {
            out.writeObject(this._operations.get(i));
        }
        out.writeInt(this._contexts.size());
        for (i = 0; i < this._contexts.size(); ++i) {
            out.writeObject(this._contexts.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        in.readInt();
        this._serviceType = (String)in.readObject();
        int len = in.readInt();
        for (i = 0; i < len; ++i) {
            this._operations.add((OperationDefinition)in.readObject());
        }
        len = in.readInt();
        for (i = 0; i < len; ++i) {
            this._contexts.add((Context)in.readObject());
        }
    }
}

