/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.analytics.service.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.ActivityTypeId;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.activity.model.soa.RequestReceived;
import org.overlord.rtgov.activity.model.soa.RequestSent;
import org.overlord.rtgov.activity.model.soa.ResponseReceived;
import org.overlord.rtgov.activity.model.soa.ResponseSent;
import org.overlord.rtgov.analytics.service.InvocationDefinition;
import org.overlord.rtgov.analytics.service.InvocationMetric;
import org.overlord.rtgov.analytics.service.MEPDefinition;
import org.overlord.rtgov.analytics.service.OperationDefinition;
import org.overlord.rtgov.analytics.service.RequestFaultDefinition;
import org.overlord.rtgov.analytics.service.RequestResponseDefinition;
import org.overlord.rtgov.analytics.service.ServiceDefinition;

public final class ServiceDefinitionUtil {
    private static final String PRINCIPAL = "principal";
    private static final Logger LOG = Logger.getLogger(ServiceDefinitionUtil.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private ServiceDefinitionUtil() {
    }

    public static byte[] serializeServiceDefinition(ServiceDefinition sdef) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, (Object)sdef);
        ret = baos.toByteArray();
        baos.close();
        return ret;
    }

    public static ServiceDefinition deserializeServiceDefinition(byte[] sdef) throws Exception {
        ServiceDefinition ret = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(sdef);
        ret = (ServiceDefinition)MAPPER.readValue((InputStream)bais, ServiceDefinition.class);
        bais.close();
        return ret;
    }

    public static Collection<ServiceDefinition> derive(ActivityUnit actUnit) {
        HashMap<String, ServiceDefinition> ret = new HashMap<String, ServiceDefinition>();
        ServiceDefinitionUtil.checkForServiceInvoked(ret, actUnit, 0, actUnit.getActivityTypes().size());
        return ret.values();
    }

    protected static void checkForServiceInvoked(Map<String, ServiceDefinition> sdefs, ActivityUnit actUnit, int from, int to) {
        block0: for (int i = from; i < to; ++i) {
            RequestReceived rqr;
            ActivityType at1 = (ActivityType)actUnit.getActivityTypes().get(i);
            if (!(at1 instanceof RequestReceived) || (rqr = (RequestReceived)at1).getMessageId() == null) continue;
            for (int j = i + 1; j < to; ++j) {
                ActivityType at2 = (ActivityType)actUnit.getActivityTypes().get(j);
                if (!(at2 instanceof ResponseSent) || ((ResponseSent)at2).getReplyToId() == null || !((ResponseSent)at2).getReplyToId().equals(rqr.getMessageId())) continue;
                ResponseSent rps = (ResponseSent)at2;
                MEPDefinition resp = ServiceDefinitionUtil.processServiceInvoked(sdefs, actUnit, rqr, rps);
                ServiceDefinitionUtil.checkForExternalInvocations(sdefs, actUnit, resp, i + 1, j);
                i = j;
                continue block0;
            }
        }
    }

    protected static void checkForExternalInvocations(Map<String, ServiceDefinition> sdefs, ActivityUnit actUnit, MEPDefinition mep, int from, int to) {
        block0: for (int i = from; i < to; ++i) {
            RequestSent rqs;
            ActivityType at1 = (ActivityType)actUnit.getActivityTypes().get(i);
            if (!(at1 instanceof RequestSent) || (rqs = (RequestSent)at1).getMessageId() == null) continue;
            for (int j = i + 1; j < to; ++j) {
                ActivityType at2 = (ActivityType)actUnit.getActivityTypes().get(j);
                if (!(at2 instanceof ResponseReceived) || ((ResponseReceived)at2).getReplyToId() == null || !((ResponseReceived)at2).getReplyToId().equals(rqs.getMessageId())) continue;
                ResponseReceived rpr = (ResponseReceived)at2;
                ServiceDefinitionUtil.processExternalInvocation(sdefs, mep, rqs, rpr);
                ServiceDefinitionUtil.checkForServiceInvoked(sdefs, actUnit, i + 1, j);
                i = j;
                continue block0;
            }
        }
    }

    protected static MEPDefinition processServiceInvoked(Map<String, ServiceDefinition> sdefs, ActivityUnit actUnit, RequestReceived rqr, ResponseSent rps) {
        OperationDefinition op;
        MEPDefinition ret = null;
        ServiceDefinition sd = sdefs.get(rqr.getServiceType());
        if (sd == null) {
            sd = new ServiceDefinition();
            sd.setServiceType(rqr.getServiceType());
            sdefs.put(rqr.getServiceType(), sd);
        }
        if ((op = sd.getOperation(rqr.getOperation())) == null) {
            op = new OperationDefinition();
            op.setName(rqr.getOperation());
            sd.getOperations().add(op);
        }
        InvocationMetric metrics = null;
        if (rps.getFault() == null || rps.getFault().trim().length() == 0) {
            RequestResponseDefinition nrd = op.getRequestResponse();
            if (nrd == null) {
                nrd = new RequestResponseDefinition();
                op.setRequestResponse(nrd);
                nrd.setRequestId(ActivityTypeId.createId((ActivityType)rqr));
                nrd.setResponseId(ActivityTypeId.createId((ActivityType)rps));
            }
            metrics = nrd.getMetrics();
            ret = nrd;
        } else {
            RequestFaultDefinition frd = op.getRequestFault(rps.getFault());
            if (frd == null) {
                frd = new RequestFaultDefinition();
                frd.setFault(rps.getFault());
                frd.setRequestId(ActivityTypeId.createId((ActivityType)rqr));
                frd.setResponseId(ActivityTypeId.createId((ActivityType)rps));
                op.getRequestFaults().add(frd);
            }
            metrics = frd.getMetrics();
            ret = frd;
        }
        if (ret != null) {
            ret.getProperties().putAll(rqr.getProperties());
            ret.getProperties().putAll(rps.getProperties());
            if (!ret.getProperties().containsKey(PRINCIPAL)) {
                if (rqr.getPrincipal() != null) {
                    ret.getProperties().put(PRINCIPAL, rqr.getPrincipal());
                } else if (rps.getPrincipal() != null) {
                    ret.getProperties().put(PRINCIPAL, rps.getPrincipal());
                }
            }
            if (actUnit != null && actUnit.getOrigin() != null) {
                ret.getProperties().put("host", actUnit.getOrigin().getHost());
                ret.getProperties().put("node", actUnit.getOrigin().getNode());
            }
        }
        long duration = rps.getTimestamp() - rqr.getTimestamp();
        metrics.setAverage((metrics.getAverage() * (long)metrics.getCount() + duration) / (long)(metrics.getCount() + 1));
        if (metrics.getMin() == 0L || duration < metrics.getMin()) {
            metrics.setMin(duration);
        }
        if (duration > metrics.getMax()) {
            metrics.setMax(duration);
        }
        metrics.setCount(metrics.getCount() + 1);
        sd.getContext().addAll(rqr.getContext());
        for (Context c : rps.getContext()) {
            if (sd.getContext().contains(c)) continue;
            sd.getContext().add(c);
        }
        return ret;
    }

    protected static void processExternalInvocation(Map<String, ServiceDefinition> sdefs, MEPDefinition call, RequestSent rqs, ResponseReceived rpr) {
        InvocationDefinition idef = call.getInvocation(rqs.getServiceType(), rqs.getOperation(), rpr.getFault());
        if (idef == null) {
            idef = new InvocationDefinition();
            idef.setServiceType(rqs.getServiceType());
            idef.setOperation(rqs.getOperation());
            idef.setFault(rpr.getFault());
            call.getInvocations().add(idef);
        }
        InvocationMetric metrics = idef.getMetrics();
        long duration = rpr.getTimestamp() - rqs.getTimestamp();
        metrics.setAverage((metrics.getAverage() * (long)metrics.getCount() + duration) / (long)(metrics.getCount() + 1));
        if (metrics.getMin() == 0L || duration < metrics.getMin()) {
            metrics.setMin(duration);
        }
        if (duration > metrics.getMax()) {
            metrics.setMax(duration);
        }
        metrics.setCount(metrics.getCount() + 1);
    }

    public static Map<String, ServiceDefinition> mergeSnapshots(List<Map<String, ServiceDefinition>> snapshots) {
        return ServiceDefinitionUtil.mergeSnapshots(snapshots, false);
    }

    public static Map<String, ServiceDefinition> mergeSnapshots(List<Map<String, ServiceDefinition>> snapshots, boolean retainContexts) {
        HashMap<String, ServiceDefinition> ret = new HashMap<String, ServiceDefinition>();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("MERGE: " + snapshots);
        }
        HashSet<String> keys = new HashSet<String>();
        for (Map<String, ServiceDefinition> sds : snapshots) {
            keys.addAll(sds.keySet());
        }
        for (String key : keys) {
            ServiceDefinition sd = new ServiceDefinition();
            sd.setServiceType(key);
            for (Map<String, ServiceDefinition> sds : snapshots) {
                if (!sds.containsKey(key)) continue;
                try {
                    sd.merge(sds.get(key), retainContexts);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity-server-jmsc.Messages").getString("ANALTICS-1"), e);
                }
            }
            ret.put(key, sd);
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("MERGED: " + ret);
        }
        return ret;
    }

    static {
        SerializationConfig config = MAPPER.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL).withSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        DeserializationConfig config2 = MAPPER.getDeserializationConfig().without(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        MAPPER.setSerializationConfig(config);
        MAPPER.setDeserializationConfig(config2);
    }
}

